/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunManagerSettingsImpl
implements RunManagerSettings {
    @NonNls
    public static final String RUN_MANAGER_COMPONENT_NAME = "RunManager";
    @NonNls
    public static final String CONFIGURATION_ELEMENT = "configuration";
    private SettingsXmlFile myWorkspaceFile;
    private SettingsXmlFile myProjectFile;
    private final List<SettingsXmlFile> mySharedConfigurationFiles;

    public RunManagerSettingsImpl(@NotNull Path workspaceFile, @Nullable Path projectFile, File @Nullable [] sharedConfigurationFiles, ConversionContextImpl context) throws CannotConvertException {
        if (workspaceFile == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(0);
        }
        if (Files.exists(workspaceFile, new LinkOption[0])) {
            this.myWorkspaceFile = context.getOrCreateFile(workspaceFile);
        }
        if (projectFile != null && Files.exists(projectFile, new LinkOption[0])) {
            this.myProjectFile = context.getOrCreateFile(projectFile);
        }
        this.mySharedConfigurationFiles = new ArrayList<SettingsXmlFile>();
        if (sharedConfigurationFiles != null) {
            for (File file2 : sharedConfigurationFiles) {
                this.mySharedConfigurationFiles.add(context.getOrCreateFile(file2.toPath()));
            }
        }
    }

    @Override
    @NotNull
    public Collection<? extends Element> getRunConfigurations() {
        ArrayList<Element> result2 = new ArrayList<Element>();
        if (this.myWorkspaceFile != null) {
            result2.addAll(JDOMUtil.getChildren(this.myWorkspaceFile.findComponent(RUN_MANAGER_COMPONENT_NAME), CONFIGURATION_ELEMENT));
        }
        if (this.myProjectFile != null) {
            result2.addAll(JDOMUtil.getChildren(this.myProjectFile.findComponent("ProjectRunConfigurationManager"), CONFIGURATION_ELEMENT));
        }
        for (SettingsXmlFile file2 : this.mySharedConfigurationFiles) {
            result2.addAll(JDOMUtil.getChildren(file2.getRootElement(), CONFIGURATION_ELEMENT));
        }
        ArrayList<Element> arrayList = result2;
        if (arrayList == null) {
            RunManagerSettingsImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public Collection<Path> getAffectedFiles() {
        ArrayList<Path> files2 = new ArrayList<Path>();
        if (this.myWorkspaceFile != null) {
            files2.add(this.myWorkspaceFile.getFile());
        }
        if (this.myProjectFile != null) {
            files2.add(this.myProjectFile.getFile());
        }
        for (SettingsXmlFile file2 : this.mySharedConfigurationFiles) {
            files2.add(file2.getFile());
        }
        return files2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/RunManagerSettingsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/RunManagerSettingsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

