/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl.ui;

import com.intellij.CommonBundle;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ProjectConversionUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ConvertProjectDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ConvertProjectDialog.class);
    private JPanel myMainPanel;
    private JTextPane myTextPane;
    private boolean myConverted;
    private final ConversionContextImpl myContext;
    private final List<? extends ConversionRunner> myConversionRunners;
    private final File myBackupDir;
    private final Set<Path> myAffectedFiles;
    private boolean myNonExistingFilesMessageShown;

    public ConvertProjectDialog(ConversionContextImpl context, final List<? extends ConversionRunner> conversionRunners) {
        super(true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(IdeBundle.message("dialog.title.convert.project", objectArray));
        this.setModal(true);
        this.myContext = context;
        this.myConversionRunners = conversionRunners;
        this.myAffectedFiles = new HashSet<Path>();
        for (ConversionRunner conversionRunner : conversionRunners) {
            this.myAffectedFiles.addAll(conversionRunner.getAffectedFiles());
        }
        this.myBackupDir = ProjectConversionUtil.getBackupDir(context.getProjectBaseDir());
        this.myTextPane.setSize(new Dimension(350, Integer.MAX_VALUE));
        StringBuilder message = new StringBuilder();
        if (this.myConversionRunners.size() == 1 && this.myConversionRunners.get(0).getProvider().getConversionDialogText(context) != null) {
            message.append(this.myConversionRunners.get(0).getProvider().getConversionDialogText(context));
        } else {
            message.append(IdeBundle.message("conversion.dialog.text.1", context.getProjectFile().getName(), ApplicationNamesInfo.getInstance().getFullProductName()));
        }
        message.append(IdeBundle.message("conversion.dialog.text.2", this.myBackupDir.getAbsolutePath()));
        Messages.configureMessagePaneUi(this.myTextPane, XmlStringUtil.wrapInHtml(message), null);
        this.myTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    StringBuilder descriptions = new StringBuilder("<html>The following conversions will be performed:<br>");
                    for (ConversionRunner runner : conversionRunners) {
                        descriptions.append(runner.getProvider().getConversionDescription()).append("<br>");
                    }
                    descriptions.append("</html>");
                    Messages.showInfoMessage(descriptions.toString(), IdeBundle.message("dialog.title.convert.project", new Object[0]));
                }
            }
        });
        this.init();
        this.setOKButtonText("Convert");
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Override
    protected void doOKAction() {
        List<Path> nonexistentFiles = this.myContext.getNonExistingModuleFiles();
        if (!nonexistentFiles.isEmpty() && !this.myNonExistingFilesMessageShown) {
            String filesString = ConvertProjectDialog.getFilesString(nonexistentFiles);
            String message = IdeBundle.message("message.text.files.do.not.exist", filesString);
            int n = Messages.showYesNoDialog(this.getContentPane(), message, IdeBundle.message("dialog.title.convert.project", new Object[0]), Messages.getQuestionIcon());
            if (n != 0) {
                super.doOKAction();
                return;
            }
            this.myNonExistingFilesMessageShown = false;
        }
        try {
            if (!this.checkReadOnlyFiles()) {
                return;
            }
            ProjectConversionUtil.backupFiles(this.myAffectedFiles, this.myContext.getProjectBaseDir(), this.myBackupDir);
            ArrayList<ConversionRunner> usedRunners = new ArrayList<ConversionRunner>();
            for (ConversionRunner conversionRunner : this.myConversionRunners) {
                if (!conversionRunner.isConversionNeeded()) continue;
                conversionRunner.preProcess();
                conversionRunner.process();
                conversionRunner.postProcess();
                usedRunners.add(conversionRunner);
            }
            this.myContext.saveFiles(this.myAffectedFiles, usedRunners);
            this.myConverted = true;
            super.doOKAction();
        }
        catch (CannotConvertException | IOException e) {
            LOG.info(e);
            this.showErrorMessage(IdeBundle.message("error.cannot.convert.project", e.getMessage()));
        }
    }

    private static String getFilesString(List<? extends Path> files2) {
        StringBuilder buffer = new StringBuilder();
        for (Path path2 : files2) {
            buffer.append(path2.toAbsolutePath().toString()).append("<br>");
        }
        return buffer.toString();
    }

    private boolean checkReadOnlyFiles() {
        List<Path> files2 = this.getReadOnlyFiles();
        if (!files2.isEmpty()) {
            String message = IdeBundle.message("message.text.unlock.read.only.files", ApplicationNamesInfo.getInstance().getFullProductName(), ConvertProjectDialog.getFilesString(files2));
            String[] options = new String[]{CommonBundle.getContinueButtonText(), CommonBundle.getCancelButtonText()};
            if (Messages.showOkCancelDialog(this.myMainPanel, message, IdeBundle.message("dialog.title.convert.project", new Object[0]), options[0], options[1], null) != 0) {
                return false;
            }
            ConvertProjectDialog.unlockFiles(files2);
            files2 = this.getReadOnlyFiles();
            if (!files2.isEmpty()) {
                this.showErrorMessage(IdeBundle.message("error.message.cannot.make.files.writable", ConvertProjectDialog.getFilesString(files2)));
                return false;
            }
        }
        return true;
    }

    private List<Path> getReadOnlyFiles() {
        return ConversionRunner.getReadOnlyFiles(this.myAffectedFiles);
    }

    private static void unlockFiles(List<? extends Path> files2) {
        for (Path path2 : files2) {
            FileUtil.setReadOnlyAttribute(path2.toAbsolutePath().toString(), false);
        }
    }

    private void showErrorMessage(String message) {
        Messages.showErrorDialog(this.myMainPanel, message, IdeBundle.message("dialog.title.convert.project", new Object[0]));
    }

    public boolean isConverted() {
        return this.myConverted;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTextPane = jTextPane = new JTextPane();
        jPanel.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(350, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

