/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.Nullable;

public abstract class SourcePositionHighlighter {
    public static final ExtensionPointName<SourcePositionHighlighter> EP_NAME = ExtensionPointName.create("com.intellij.debugger.sourcePositionHighlighter");

    public abstract TextRange getHighlightRange(SourcePosition var1);

    @Nullable
    public static TextRange getHighlightRangeFor(SourcePosition sourcePosition) {
        for (SourcePositionHighlighter provider : DumbService.getDumbAwareExtensions(sourcePosition.getFile().getProject(), EP_NAME)) {
            TextRange range2 = provider.getHighlightRange(sourcePosition);
            if (range2 == null) continue;
            return range2;
        }
        return null;
    }
}

