/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.editors;

import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.openapi.ui.ComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public abstract class ComboEditor
extends PropertyEditor {
    protected final ComboBox myCombo = new ComboBox(-1);
    protected final Border myComboBorder = this.myCombo.getBorder();

    public ComboEditor() {
        ComboEditor.installListeners(this.myCombo, this.createComboListeners());
    }

    protected ComboEditorListener createComboListeners() {
        return new ComboEditorListener(this);
    }

    public static void installListeners(JComboBox myCombo, final ComboEditorListener listener2) {
        myCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                listener2.onValueChosen();
            }
        });
        myCombo.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                listener2.onCancelled();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myCombo;
    }

    @Override
    public void activate() {
        super.activate();
        this.myCombo.showPopup();
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.myCombo);
        ListCellRenderer renderer = this.myCombo.getRenderer();
        if (renderer instanceof JComponent) {
            SwingUtilities.updateComponentTreeUI((JComponent)((Object)renderer));
        }
    }

    public static class ComboEditorListener {
        private final PropertyEditor myEditor;

        public ComboEditorListener(PropertyEditor editor) {
            this.myEditor = editor;
        }

        protected void onValueChosen() {
            this.myEditor.fireValueCommitted(true, true);
        }

        protected void onCancelled() {
            this.myEditor.fireEditingCancelled();
        }
    }
}

