/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.LogEventException;
import com.intellij.diagnostic.LogMessage;
import com.intellij.idea.Main;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.jetbrains.annotations.NotNull;

public class DialogAppender
extends AppenderSkeleton {
    private static final ErrorLogger[] LOGGERS = new ErrorLogger[]{new DefaultIdeaErrorLogger()};
    private static final int MAX_EARLY_LOGGING_EVENTS = 5;
    private static final int MAX_ASYNC_LOGGING_EVENTS = 5;
    private final Queue<LoggingEvent> myEarlyEvents = new ArrayDeque<LoggingEvent>();
    private final AtomicInteger myPendingAppendCounts = new AtomicInteger();
    private volatile Runnable myDialogRunnable;

    protected synchronized void append(@NotNull LoggingEvent event) {
        if (event == null) {
            DialogAppender.$$$reportNull$$$0(0);
        }
        if (!event.getLevel().isGreaterOrEqual((Priority)Level.ERROR) || Main.isCommandLine()) {
            return;
        }
        if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
            LoggingEvent queued;
            while ((queued = this.myEarlyEvents.poll()) != null) {
                this.queueAppend(queued);
            }
            this.queueAppend(event);
        } else if (this.myEarlyEvents.size() < 5) {
            this.myEarlyEvents.add(event);
        }
    }

    private void queueAppend(@NotNull LoggingEvent event) {
        if (event == null) {
            DialogAppender.$$$reportNull$$$0(1);
        }
        if (this.myPendingAppendCounts.addAndGet(1) > 5) {
            this.myPendingAppendCounts.decrementAndGet();
        } else {
            SwingUtilities.invokeLater(() -> {
                try {
                    this.appendToLoggers(event, LOGGERS);
                }
                finally {
                    this.myPendingAppendCounts.decrementAndGet();
                }
            });
        }
    }

    void appendToLoggers(@NotNull LoggingEvent event, ErrorLogger @NotNull [] errorLoggers) {
        IdeaLoggingEvent ideaEvent;
        if (event == null) {
            DialogAppender.$$$reportNull$$$0(2);
        }
        if (errorLoggers == null) {
            DialogAppender.$$$reportNull$$$0(3);
        }
        if (this.myDialogRunnable != null) {
            return;
        }
        Object messageObject = event.getMessage();
        if (messageObject instanceof IdeaLoggingEvent) {
            ideaEvent = (IdeaLoggingEvent)messageObject;
        } else {
            ThrowableInformation info = event.getThrowableInformation();
            if (info == null || info.getThrowable() == null) {
                return;
            }
            ideaEvent = DialogAppender.extractLoggingEvent(messageObject, info.getThrowable());
        }
        for (int i = errorLoggers.length - 1; i >= 0; --i) {
            ErrorLogger logger = errorLoggers[i];
            if (!logger.canHandle(ideaEvent)) continue;
            this.myDialogRunnable = () -> {
                try {
                    logger.handle(ideaEvent);
                }
                finally {
                    this.myDialogRunnable = null;
                }
            };
            AppExecutorUtil.getAppExecutorService().execute(this.myDialogRunnable);
            break;
        }
    }

    private static IdeaLoggingEvent extractLoggingEvent(Object messageObject, Throwable throwable) {
        Throwable rootCause = ExceptionUtil.getRootCause(throwable);
        if (rootCause instanceof LogEventException) {
            return ((LogEventException)rootCause).getLogMessage();
        }
        String message = null;
        ExceptionWithAttachments withAttachments = ExceptionUtil.findCause(throwable, ExceptionWithAttachments.class);
        if (withAttachments instanceof RuntimeExceptionWithAttachments) {
            message = ((RuntimeExceptionWithAttachments)withAttachments).getUserMessage();
        }
        if (message == null && messageObject != null) {
            message = messageObject.toString();
        }
        if (withAttachments != null) {
            return LogMessage.createEvent(throwable, message, withAttachments.getAttachments());
        }
        return new IdeaLoggingEvent(message, throwable);
    }

    Runnable getDialogRunnable() {
        return this.myDialogRunnable;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorLoggers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/DialogAppender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "queueAppend";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendToLoggers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

