/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdeErrorsIcon;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeMessagePanel
extends NonOpaquePanel
implements MessagePoolListener,
IconLikeCustomStatusBarWidget {
    public static final String FATAL_ERROR = "FatalError";
    private final IdeErrorsIcon myIcon;
    private final IdeFrame myFrame;
    private final MessagePool myMessagePool;
    private Balloon myBalloon;
    private IdeErrorsDialog myDialog;
    private boolean myOpeningInProgress;
    private boolean myNotificationPopupAlreadyShown;
    private static final Color TEXT_COLOR = JBColor.namedColor("Notification.errorForeground", NotificationsManagerImpl.DEFAULT_TEXT_COLOR);
    private static final Color FILL_COLOR = JBColor.namedColor("Notification.errorBackground", new JBColor(16115431, 5848385));
    private static final Color BORDER_COLOR = JBColor.namedColor("Notification.errorBorderColor", new JBColor(14723241, 7554379));

    public IdeMessagePanel(@Nullable IdeFrame frame, @NotNull MessagePool messagePool) {
        if (messagePool == null) {
            IdeMessagePanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myIcon = new IdeErrorsIcon(frame != null);
        this.myIcon.setVerticalAlignment(0);
        this.add((Component)this.myIcon, "Center");
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeMessagePanel.this.openErrorsDialog(null);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diagnostic/IdeMessagePanel$1", "onClick"));
            }
        }.installOn(this.myIcon);
        this.myFrame = frame;
        this.myMessagePool = messagePool;
        messagePool.addListener(this);
        this.updateIconAndNotify();
    }

    @Override
    @NotNull
    public String ID() {
        return FATAL_ERROR;
    }

    @Override
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @Override
    public void dispose() {
        UIUtil.dispose(this.myIcon);
        this.myMessagePool.removeListener(this);
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            IdeMessagePanel.$$$reportNull$$$0(1);
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public void openFatals(@Nullable LogMessage message) {
        this.openErrorsDialog(message);
    }

    public void openErrorsDialog(final @Nullable LogMessage message) {
        if (this.myDialog != null) {
            return;
        }
        if (this.myOpeningInProgress) {
            return;
        }
        this.myOpeningInProgress = true;
        new Runnable(){

            @Override
            public void run() {
                if (!IdeMessagePanel.this.isOtherModalWindowActive()) {
                    try {
                        IdeMessagePanel.this.doOpenErrorsDialog(message);
                    }
                    finally {
                        IdeMessagePanel.this.myOpeningInProgress = false;
                    }
                } else if (IdeMessagePanel.this.myDialog == null) {
                    EdtExecutorService.getScheduledExecutorInstance().schedule(this, 300L, TimeUnit.MILLISECONDS);
                }
            }
        }.run();
    }

    private void doOpenErrorsDialog(@Nullable LogMessage message) {
        Project project2 = this.myFrame != null ? this.myFrame.getProject() : null;
        this.myDialog = new IdeErrorsDialog(this.myMessagePool, project2, message){

            @Override
            protected void dispose() {
                super.dispose();
                IdeMessagePanel.this.myDialog = null;
                IdeMessagePanel.this.updateIconAndNotify();
            }

            @Override
            protected void updateOnSubmit() {
                super.updateOnSubmit();
                IdeMessagePanel.this.updateIcon(IdeMessagePanel.this.myMessagePool.getState());
            }
        };
        this.myDialog.show();
    }

    private void updateIcon(MessagePool.State state) {
        this.myIcon.setState(state);
        UIUtil.invokeLaterIfNeeded(() -> this.setVisible(state != MessagePool.State.NoErrors));
    }

    @Override
    public void newEntryAdded() {
        this.updateIconAndNotify();
    }

    @Override
    public void poolCleared() {
        this.updateIconAndNotify();
    }

    @Override
    public void entryWasRead() {
        this.updateIconAndNotify();
    }

    private boolean isOtherModalWindowActive() {
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        return activeWindow instanceof JDialog && ((JDialog)activeWindow).isModal() && (this.myDialog == null || this.myDialog.getWindow() != activeWindow);
    }

    private void updateIconAndNotify() {
        Project project2;
        MessagePool.State state = this.myMessagePool.getState();
        this.updateIcon(state);
        if (state == MessagePool.State.NoErrors) {
            this.myNotificationPopupAlreadyShown = false;
            if (this.myBalloon != null) {
                Disposer.dispose(this.myBalloon);
            }
        } else if (state == MessagePool.State.UnreadErrors && !this.myNotificationPopupAlreadyShown && IdeMessagePanel.isActive(this.myFrame) && (project2 = this.myFrame.getProject()) != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.showErrorNotification(project2), project2.getDisposed());
            this.myNotificationPopupAlreadyShown = true;
        }
    }

    private static boolean isActive(IdeFrame frame) {
        return frame instanceof Window && ((Window)((Object)frame)).isActive();
    }

    private void showErrorNotification(@NotNull Project project2) {
        if (project2 == null) {
            IdeMessagePanel.$$$reportNull$$$0(2);
        }
        String title = DiagnosticBundle.message("error.new.notification.title", new Object[0]);
        String linkText = DiagnosticBundle.message("error.new.notification.link", new Object[0]);
        Notification notification = new Notification("", AllIcons.Ide.FatalError, title, null, null, NotificationType.ERROR, null);
        notification.addAction(new NotificationAction(linkText){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    4.$$$reportNull$$$0(1);
                }
                notification.expire();
                IdeMessagePanel.this.openErrorsDialog(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/diagnostic/IdeMessagePanel$4";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        BalloonLayout layout = this.myFrame.getBalloonLayout();
        assert (layout != null) : this.myFrame;
        BalloonLayoutData layoutData = BalloonLayoutData.createEmpty();
        layoutData.fadeoutTime = 5000L;
        layoutData.textColor = TEXT_COLOR;
        layoutData.fillColor = FILL_COLOR;
        layoutData.borderColor = BORDER_COLOR;
        assert (this.myBalloon == null);
        this.myBalloon = NotificationsManagerImpl.createBalloon(this.myFrame, notification, false, false, new Ref<BalloonLayoutData>(layoutData), (Disposable)project2);
        Disposer.register(this.myBalloon, () -> {
            this.myBalloon = null;
        });
        layout.add(this.myBalloon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/IdeMessagePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

