/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.application.options.RegistryManager;
import com.intellij.diagnostic.ApdexData;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.SamplingTask;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PerformanceWatcher
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PerformanceWatcher.class);
    private static final int TOLERABLE_LATENCY = 100;
    private static final String THREAD_DUMPS_PREFIX = "threadDumps-";
    static final String DUMP_PREFIX = "threadDump-";
    private static final String DURATION_FILE_NAME = ".duration";
    private ScheduledFuture<?> myThread;
    private final File myLogDir = new File(PathManager.getLogPath());
    private volatile ApdexData mySwingApdex = ApdexData.EMPTY;
    private volatile ApdexData myGeneralApdex = ApdexData.EMPTY;
    private volatile long myLastSampling = System.nanoTime();
    private int myActiveEvents;
    private static final long ourIdeStart = System.currentTimeMillis();
    private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService("EDT Performance Checker", 1);
    private FreezeCheckerTask myCurrentEDTEventChecker;
    private static final boolean SHOULD_WATCH = PerformanceWatcher.shouldWatch();

    @NotNull
    public static PerformanceWatcher getInstance() {
        LoadingState.CONFIGURATION_STORE_INITIALIZED.checkOccurred();
        PerformanceWatcher performanceWatcher = ServiceManager.getService(PerformanceWatcher.class);
        if (performanceWatcher == null) {
            PerformanceWatcher.$$$reportNull$$$0(0);
        }
        return performanceWatcher;
    }

    public PerformanceWatcher() {
        if (!PerformanceWatcher.shouldWatch()) {
            return;
        }
        final AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
        service.setNewThreadListener((Consumer<? super Thread>)new Consumer<Thread>(){
            private final int ourReasonableThreadPoolSize = RegistryManager.getInstance().intValue("core.pooled.threads");

            @Override
            public void accept(Thread thread) {
                if (service.getBackendPoolExecutorSize() > this.ourReasonableThreadPoolSize && ApplicationInfoImpl.getShadowInstance().isEAP()) {
                    File file2 = PerformanceWatcher.this.dumpThreads("newPooledThread/", true);
                    LOG.info("Not enough pooled threads" + (file2 != null ? "; dumped threads into file '" + file2.getPath() + "'" : ""));
                }
            }
        });
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!"Code Cache".equals(bean.getName())) continue;
            this.watchCodeCache(bean);
            break;
        }
        PerformanceWatcher.cleanOldFiles(this.myLogDir, 0);
        this.myThread = this.myExecutor.scheduleWithFixedDelay(this::samplePerformance, PerformanceWatcher.getSamplingInterval(), PerformanceWatcher.getSamplingInterval(), TimeUnit.MILLISECONDS);
    }

    @NotNull
    private static IdePerformanceListener getPublisher() {
        IdePerformanceListener idePerformanceListener = ApplicationManager.getApplication().getMessageBus().syncPublisher(IdePerformanceListener.TOPIC);
        if (idePerformanceListener == null) {
            PerformanceWatcher.$$$reportNull$$$0(1);
        }
        return idePerformanceListener;
    }

    private static int getMaxAttempts() {
        return RegistryManager.getInstance().intValue("performance.watcher.unresponsive.max.attempts.before.log");
    }

    private void watchCodeCache(final MemoryPoolMXBean bean) {
        final long threshold = bean.getUsage().getMax() - 0x500000L;
        if (!bean.isUsageThresholdSupported() || threshold <= 0L) {
            return;
        }
        bean.setUsageThreshold(threshold);
        final NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        emitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object hb) {
                if (bean.getUsage().getUsed() > threshold) {
                    LOG.info("Code Cache is almost full");
                    PerformanceWatcher.this.dumpThreads("codeCacheFull", true);
                    try {
                        emitter.removeNotificationListener(this);
                    }
                    catch (ListenerNotFoundException e) {
                        LOG.error(e);
                    }
                }
            }
        }, null, null);
    }

    public void processUnfinishedFreeze(BiConsumer<File, Integer> consumer) {
        File[] files2 = this.myLogDir.listFiles();
        if (files2 != null) {
            Arrays.stream(files2).filter(file2 -> file2.getName().startsWith(THREAD_DUMPS_PREFIX)).filter(file2 -> Files.exists(file2.toPath().resolve(DURATION_FILE_NAME), new LinkOption[0])).findFirst().ifPresent(f -> {
                File marker = new File((File)f, DURATION_FILE_NAME);
                try {
                    String s = FileUtil.loadFile(marker);
                    PerformanceWatcher.cleanup(f);
                    consumer.accept((File)f, Integer.parseInt(s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    private static void cleanOldFiles(File dir, int level) {
        Object[] children2 = dir.listFiles((dir1, name) -> level > 0 || name.startsWith(THREAD_DUMPS_PREFIX));
        if (children2 == null) {
            return;
        }
        Arrays.sort(children2);
        for (int i = 0; i < children2.length; ++i) {
            Object child2 = children2[i];
            if (i < children2.length - 100 || PerformanceWatcher.ageInDays((File)child2) > 10L) {
                FileUtil.delete((File)child2);
                continue;
            }
            if (level >= 3) continue;
            PerformanceWatcher.cleanOldFiles((File)child2, level + 1);
        }
    }

    private static long ageInDays(File file2) {
        return TimeUnit.DAYS.convert(System.currentTimeMillis() - file2.lastModified(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void dispose() {
        if (this.myThread != null) {
            this.myThread.cancel(true);
        }
        this.myExecutor.shutdownNow();
    }

    private static boolean shouldWatch() {
        return !ApplicationManager.getApplication().isHeadlessEnvironment() && PerformanceWatcher.getUnresponsiveInterval() != 0 && PerformanceWatcher.getMaxAttempts() != 0;
    }

    private void samplePerformance() {
        long current2 = System.nanoTime();
        this.myLastSampling = current2;
        for (long diffMs = TimeUnit.NANOSECONDS.toMillis(current2 - this.myLastSampling) - (long)PerformanceWatcher.getSamplingInterval(); diffMs >= 0L; diffMs -= (long)PerformanceWatcher.getSamplingInterval()) {
            this.myGeneralApdex = this.myGeneralApdex.withEvent(100L, diffMs);
        }
        SwingUtilities.invokeLater(() -> {
            long latencyMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - current2);
            this.mySwingApdex = this.mySwingApdex.withEvent(100L, latencyMs);
            if (ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            PerformanceWatcher.getPublisher().uiResponded(latencyMs);
        });
    }

    @NotNull
    public static String printStacktrace(@NotNull String headerMsg, @NotNull Thread thread, StackTraceElement @NotNull [] stackTrace) {
        if (headerMsg == null) {
            PerformanceWatcher.$$$reportNull$$$0(2);
        }
        if (thread == null) {
            PerformanceWatcher.$$$reportNull$$$0(3);
        }
        if (stackTrace == null) {
            PerformanceWatcher.$$$reportNull$$$0(4);
        }
        StringBuilder trace = new StringBuilder(headerMsg + thread + " (" + (thread.isAlive() ? "alive" : "dead") + ") " + (Object)((Object)thread.getState()) + "\n--- its stacktrace:\n");
        for (StackTraceElement stackTraceElement : stackTrace) {
            trace.append(" at ").append(stackTraceElement).append("\n");
        }
        trace.append("---\n");
        String string = trace.toString();
        if (string == null) {
            PerformanceWatcher.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static int getSamplingInterval() {
        return RegistryManager.getInstance().intValue("performance.watcher.sampling.interval.ms");
    }

    static int getDumpInterval() {
        return PerformanceWatcher.getSamplingInterval() * PerformanceWatcher.getMaxAttempts();
    }

    static int getUnresponsiveInterval() {
        return RegistryManager.getInstance().intValue("performance.watcher.unresponsive.interval.ms");
    }

    static int getMaxDumpDuration() {
        return RegistryManager.getInstance().intValue("performance.watcher.dump.duration.s") * 1000;
    }

    private static String buildName() {
        return ApplicationInfo.getInstance().getBuild().asString();
    }

    private static String formatTime(long timeMs) {
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(timeMs));
    }

    private static void cleanup(File dir) {
        FileUtil.delete(new File(dir, DURATION_FILE_NAME));
    }

    public void edtEventStarted() {
        long start2 = System.nanoTime();
        ++this.myActiveEvents;
        if (SHOULD_WATCH) {
            this.finishTracking();
            this.startTracking(start2);
        }
    }

    public void edtEventFinished() {
        --this.myActiveEvents;
        this.finishTracking();
        if (SHOULD_WATCH && this.myActiveEvents > 0) {
            this.startTracking(System.nanoTime());
        }
    }

    private void startTracking(long start2) {
        this.myCurrentEDTEventChecker = new FreezeCheckerTask(start2);
    }

    private void finishTracking() {
        FreezeCheckerTask currentChecker = this.myCurrentEDTEventChecker;
        if (currentChecker != null) {
            currentChecker.stop();
            this.myCurrentEDTEventChecker = null;
        }
    }

    @Nullable
    public File dumpThreads(@NotNull String pathPrefix, boolean millis) {
        if (pathPrefix == null) {
            PerformanceWatcher.$$$reportNull$$$0(6);
        }
        return this.dumpThreads(pathPrefix, millis, ThreadDumper.getThreadInfos(), null);
    }

    @Nullable
    private File dumpThreads(@NotNull String pathPrefix, boolean millis, ThreadInfo[] threadInfos, @Nullable FreezeCheckerTask task2) {
        if (pathPrefix == null) {
            PerformanceWatcher.$$$reportNull$$$0(7);
        }
        if (!PerformanceWatcher.shouldWatch()) {
            return null;
        }
        if (!pathPrefix.contains("/")) {
            pathPrefix = THREAD_DUMPS_PREFIX + pathPrefix + "-" + PerformanceWatcher.formatTime(ourIdeStart) + "-" + PerformanceWatcher.buildName() + "/";
        } else if (!pathPrefix.startsWith(THREAD_DUMPS_PREFIX)) {
            pathPrefix = THREAD_DUMPS_PREFIX + pathPrefix;
        }
        long now = System.currentTimeMillis();
        String suffix = millis ? "-" + now : "";
        File file2 = new File(this.myLogDir, pathPrefix + DUMP_PREFIX + PerformanceWatcher.formatTime(now) + suffix + ".txt");
        File dir = file2.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        PerformanceWatcher.checkMemoryUsage(file2);
        ThreadDump threadDump = ThreadDumper.getThreadDumpInfo(threadInfos);
        try {
            FileUtil.writeToFile(file2, threadDump.getRawDump());
            if (task2 != null) {
                FileUtil.writeToFile(new File(dir, DURATION_FILE_NAME), String.valueOf(TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - task2.myFreezeStart)));
                PerformanceWatcher.getPublisher().dumpedThreads(file2, threadDump);
            }
        }
        catch (IOException e) {
            LOG.info("failed to write thread dump file: " + e.getMessage());
        }
        return file2;
    }

    private static void checkMemoryUsage(File file2) {
        long usedMemory;
        Runtime rt = Runtime.getRuntime();
        long maxMemory = rt.maxMemory();
        long freeMemory = maxMemory - (usedMemory = rt.totalMemory() - rt.freeMemory());
        if (freeMemory < maxMemory / 5L) {
            LOG.info("High memory usage (free " + freeMemory / 1024L / 1024L + " of " + maxMemory / 1024L / 1024L + " MB) while dumping threads to " + file2);
        }
    }

    public static void dumpThreadsToConsole(String message) {
        System.err.println(message);
        System.err.println(ThreadDumper.dumpThreadsToString());
    }

    static List<StackTraceElement> getStacktraceCommonPart(List<StackTraceElement> commonPart, StackTraceElement[] stackTraceElements) {
        for (int i = 0; i < commonPart.size() && i < stackTraceElements.length; ++i) {
            StackTraceElement el2;
            StackTraceElement el1 = commonPart.get(commonPart.size() - i - 1);
            if (PerformanceWatcher.compareStackTraceElements(el1, el2 = stackTraceElements[stackTraceElements.length - i - 1])) continue;
            return commonPart.subList(commonPart.size() - i, commonPart.size());
        }
        return commonPart;
    }

    static boolean compareStackTraceElements(StackTraceElement el1, StackTraceElement el2) {
        if (el1 == el2) {
            return true;
        }
        return el1.getClassName().equals(el2.getClassName()) && Objects.equals(el1.getMethodName(), el2.getMethodName()) && Objects.equals(el1.getFileName(), el2.getFileName());
    }

    @NotNull
    public static Snapshot takeSnapshot() {
        PerformanceWatcher performanceWatcher = PerformanceWatcher.getInstance();
        performanceWatcher.getClass();
        return performanceWatcher.new Snapshot();
    }

    ScheduledExecutorService getExecutor() {
        return this.myExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/PerformanceWatcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerMsg";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/PerformanceWatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "printStacktrace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "printStacktrace";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreads";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FreezeCheckerTask {
        private final AtomicReference<CheckerState> myState = new AtomicReference<CheckerState>(CheckerState.CHECKING);
        private final Future<?> myFuture;
        private final long myFreezeStart;
        private String myFreezeFolder;
        private boolean myFreezeDuringStartup;
        private volatile SamplingTask myDumpTask;

        FreezeCheckerTask(long start2) {
            this.myFuture = !PerformanceWatcher.this.myExecutor.isShutdown() ? PerformanceWatcher.this.myExecutor.schedule(this::edtFrozen, (long)PerformanceWatcher.getUnresponsiveInterval(), TimeUnit.MILLISECONDS) : null;
            this.myFreezeStart = start2;
        }

        void stop() {
            if (this.myFuture == null) {
                return;
            }
            this.myFuture.cancel(false);
            if (this.myState.getAndSet(CheckerState.FINISHED) == CheckerState.FREEZE) {
                long end = System.nanoTime();
                this.stopDumping();
                try {
                    PerformanceWatcher.this.myExecutor.submit(() -> this.edtResponds(end)).get();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }

        private void edtFrozen() {
            this.myFreezeFolder = PerformanceWatcher.THREAD_DUMPS_PREFIX + (this.myFreezeDuringStartup ? "freeze-startup-" : "freeze-") + PerformanceWatcher.formatTime(System.currentTimeMillis()) + "-" + PerformanceWatcher.buildName();
            if (this.myState.compareAndSet(CheckerState.CHECKING, CheckerState.FREEZE)) {
                PerformanceWatcher.getPublisher().uiFreezeStarted();
                this.myDumpTask = new SamplingTask(PerformanceWatcher.getDumpInterval(), PerformanceWatcher.getMaxDumpDuration()){

                    @Override
                    protected void dumpedThreads(ThreadInfo[] infos) {
                        if (FreezeCheckerTask.this.myState.get() == CheckerState.FINISHED) {
                            this.stop();
                        } else {
                            PerformanceWatcher.this.dumpThreads(FreezeCheckerTask.this.myFreezeFolder + "/", false, infos, FreezeCheckerTask.this);
                        }
                    }
                };
            }
        }

        private void edtResponds(long current2) {
            this.stopDumping();
            long durationMs = TimeUnit.NANOSECONDS.toMillis(current2 - this.myFreezeStart);
            File dir = new File(PerformanceWatcher.this.myLogDir, this.myFreezeFolder);
            File reportDir = null;
            if (dir.exists()) {
                PerformanceWatcher.cleanup(dir);
                reportDir = new File(PerformanceWatcher.this.myLogDir, dir.getName() + this.getFreezePlaceSuffix() + "-" + TimeUnit.MILLISECONDS.toSeconds(durationMs) + "sec");
                if (!dir.renameTo(reportDir)) {
                    reportDir = dir;
                }
                String message = "UI was frozen for " + durationMs + "ms, details saved to " + reportDir;
                if (PluginManagerCore.isRunningFromSources()) {
                    LOG.info(message);
                } else {
                    LOG.warn(message);
                }
            }
            PerformanceWatcher.getPublisher().uiFreezeFinished(durationMs, reportDir);
        }

        private void stopDumping() {
            SamplingTask task2 = this.myDumpTask;
            if (task2 != null) {
                task2.stop();
            }
        }

        private String getFreezePlaceSuffix() {
            List<StackTraceElement> stacktraceCommonPart = null;
            for (ThreadInfo[] info : this.myDumpTask.getThreadInfos()) {
                StackTraceElement[] edtStack;
                ThreadInfo edt = ContainerUtil.find(info, ThreadDumper::isEDT);
                if (edt == null || (edtStack = edt.getStackTrace()) == null) continue;
                if (stacktraceCommonPart == null) {
                    stacktraceCommonPart = ContainerUtil.newArrayList(edtStack);
                    continue;
                }
                stacktraceCommonPart = PerformanceWatcher.getStacktraceCommonPart(stacktraceCommonPart, edtStack);
            }
            if (!ContainerUtil.isEmpty(stacktraceCommonPart)) {
                StackTraceElement element2 = (StackTraceElement)stacktraceCommonPart.get(0);
                return "-" + StringUtil.getShortName(element2.getClassName()) + "." + element2.getMethodName();
            }
            return "";
        }
    }

    private static enum CheckerState {
        CHECKING,
        FREEZE,
        FINISHED;

    }

    public class Snapshot {
        private final ApdexData myStartGeneralSnapshot;
        private final ApdexData myStartSwingSnapshot;
        private final long myStartMillis;

        private Snapshot() {
            this.myStartGeneralSnapshot = PerformanceWatcher.this.myGeneralApdex;
            this.myStartSwingSnapshot = PerformanceWatcher.this.mySwingApdex;
            this.myStartMillis = System.currentTimeMillis();
        }

        public void logResponsivenessSinceCreation(@NotNull String activityName) {
            if (activityName == null) {
                Snapshot.$$$reportNull$$$0(0);
            }
            LOG.info(activityName + " took " + (System.currentTimeMillis() - this.myStartMillis) + "ms; general responsiveness: " + PerformanceWatcher.this.myGeneralApdex.summarizePerformanceSince(this.myStartGeneralSnapshot) + "; EDT responsiveness: " + PerformanceWatcher.this.mySwingApdex.summarizePerformanceSince(this.myStartSwingSnapshot));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityName", "com/intellij/diagnostic/PerformanceWatcher$Snapshot", "logResponsivenessSinceCreation"));
        }
    }
}

