/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginStartupCostEntry;
import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ObjectLongHashMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import gnu.trove.TLongProcedure;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/diagnostic/PluginStartupCostDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "pluginsToDisable", "", "", "getPluginsToDisable", "()Ljava/util/Set;", "table", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/diagnostic/PluginStartupCostEntry;", "getTable", "()Lcom/intellij/ui/table/TableView;", "setTable", "(Lcom/intellij/ui/table/TableView;)V", "tableModel", "Lcom/intellij/util/ui/ListTableModel;", "getTableModel", "()Lcom/intellij/util/ui/ListTableModel;", "setTableModel", "(Lcom/intellij/util/ui/ListTableModel;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "createLeftSideActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "doOKAction", "", "intellij.platform.ide.impl"})
public final class PluginStartupCostDialog
extends DialogWrapper {
    @NotNull
    private final Set<String> pluginsToDisable;
    @NotNull
    public ListTableModel<PluginStartupCostEntry> tableModel;
    @NotNull
    public TableView<PluginStartupCostEntry> table;
    private final Project project;

    @NotNull
    public final Set<String> getPluginsToDisable() {
        return this.pluginsToDisable;
    }

    @NotNull
    public final ListTableModel<PluginStartupCostEntry> getTableModel() {
        ListTableModel<PluginStartupCostEntry> listTableModel = this.tableModel;
        if (listTableModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tableModel");
        }
        return listTableModel;
    }

    public final void setTableModel(@NotNull ListTableModel<PluginStartupCostEntry> listTableModel) {
        Intrinsics.checkParameterIsNotNull(listTableModel, (String)"<set-?>");
        this.tableModel = listTableModel;
    }

    @NotNull
    public final TableView<PluginStartupCostEntry> getTable() {
        TableView<PluginStartupCostEntry> tableView = this.table;
        if (tableView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        return tableView;
    }

    public final void setTable(@NotNull TableView<PluginStartupCostEntry> tableView) {
        Intrinsics.checkParameterIsNotNull(tableView, (String)"<set-?>");
        this.table = tableView;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        Object object;
        ColumnInfo[] columnInfoArray;
        Iterable $this$mapNotNullTo$iv$iv;
        Map<String, ObjectLongHashMap<String>> pluginCostMap;
        StartUpPerformanceService startUpPerformanceService = StartUpPerformanceService.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)startUpPerformanceService, (String)"StartUpPerformanceService.getInstance()");
        Map<String, ObjectLongHashMap<String>> map2 = startUpPerformanceService.getPluginCostMap();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"StartUpPerformanceServic\u2026tInstance().pluginCostMap");
        Map<String, ObjectLongHashMap<String>> $this$mapNotNull$iv = pluginCostMap = map2;
        boolean $i$f$mapNotNull = false;
        Map<String, ObjectLongHashMap<String>> map3 = $this$mapNotNull$iv;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var10_14 = $this$forEach$iv$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var10_14.entrySet().iterator();
        while (iterator2.hasNext()) {
            PluginStartupCostEntry pluginStartupCostEntry;
            void pluginId;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry $dstr$pluginId$costMap = element$iv$iv;
            boolean bl3 = false;
            Map.Entry entry = $dstr$pluginId$costMap;
            boolean bl4 = false;
            String string = (String)entry.getKey();
            entry = $dstr$pluginId$costMap;
            bl4 = false;
            ObjectLongHashMap costMap = (ObjectLongHashMap)entry.getValue();
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isInternal() && ApplicationInfoEx.getInstanceEx().isEssentialPlugin((String)pluginId)) {
                pluginStartupCostEntry = null;
            } else {
                Object object2 = PluginManagerCore.getPlugin(PluginId.getId((String)pluginId));
                if (object2 == null || (object2 = object2.getName()) == null) {
                    pluginStartupCostEntry = null;
                } else {
                    void totalCost;
                    Object name = object2;
                    Ref.LongRef longRef = new Ref.LongRef();
                    longRef.element = 0L;
                    costMap.forEachValue(new TLongProcedure((Ref.LongRef)totalCost){
                        final /* synthetic */ Ref.LongRef $totalCost;

                        public final boolean execute(long it) {
                            this.$totalCost.element += it;
                            return true;
                        }
                        {
                            this.$totalCost = longRef;
                        }
                    });
                    Object[] ids = costMap.keys();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ids, (String)"ids");
                    ArraysKt.sort((Object[])ids);
                    StringBuilder costDetails = new StringBuilder();
                    Object[] objectArray = ids;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object id2;
                        Object object3 = id2 = objectArray[i];
                        if (object3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                        }
                        costDetails.append(id2).append(": ").append(TimeUnit.NANOSECONDS.toMillis(costMap.get((String)object3)));
                        costDetails.append('\n');
                    }
                    void v6 = pluginId;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"pluginId");
                    long l = totalCost.element;
                    String string2 = costDetails.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"costDetails.toString()");
                    pluginStartupCostEntry = new PluginStartupCostEntry((String)v6, (String)name, l, string2);
                }
            }
            if (pluginStartupCostEntry == null) continue;
            PluginStartupCostEntry pluginStartupCostEntry2 = pluginStartupCostEntry;
            boolean bl5 = false;
            boolean bl6 = false;
            PluginStartupCostEntry it$iv$iv = pluginStartupCostEntry2;
            boolean bl7 = false;
            destination$iv$iv22.add(it$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv22;
        boolean $i$f$sortedByDescending = false;
        $this$mapNotNullTo$iv$iv = $this$sortedByDescending$iv;
        boolean destination$iv$iv22 = false;
        Object object4 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PluginStartupCostEntry it = (PluginStartupCostEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getCost());
                it = (PluginStartupCostEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getCost();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        List tableData2 = CollectionsKt.sortedWith((Iterable)$this$mapNotNullTo$iv$iv, (Comparator)object4);
        ColumnInfo<PluginStartupCostEntry, String> pluginColumn2 = new ColumnInfo<PluginStartupCostEntry, String>(this, "Plugin"){
            final /* synthetic */ PluginStartupCostDialog this$0;

            @NotNull
            public String valueOf(@NotNull PluginStartupCostEntry item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return item.getPluginName() + (this.this$0.getPluginsToDisable().contains(item.getPluginId()) ? " (will be disabled)" : "");
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        ColumnInfo<PluginStartupCostEntry, Integer> costColumn2 = new ColumnInfo<PluginStartupCostEntry, Integer>("Startup Time (ms)"){

            @NotNull
            public Integer valueOf(@NotNull PluginStartupCostEntry item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return (int)TimeUnit.NANOSECONDS.toMillis(item.getCost());
            }
        };
        ColumnInfo<PluginStartupCostEntry, String> costDetailsColumn2 = new ColumnInfo<PluginStartupCostEntry, String>("Cost Details"){

            @NotNull
            public String valueOf(@NotNull PluginStartupCostEntry item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return item.getCostDetails();
            }
        };
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isInternal()) {
            ColumnInfo[] columnInfoArray2 = new ColumnInfo[3];
            columnInfoArray2[0] = pluginColumn2;
            columnInfoArray2[1] = costColumn2;
            columnInfoArray = columnInfoArray2;
            columnInfoArray2[2] = costDetailsColumn2;
        } else {
            ColumnInfo[] columnInfoArray3 = new ColumnInfo[2];
            columnInfoArray3[0] = pluginColumn2;
            columnInfoArray = columnInfoArray3;
            columnInfoArray3[1] = costColumn2;
        }
        ColumnInfo[] columns = columnInfoArray;
        ListTableModel<PluginStartupCostEntry> listTableModel = this.tableModel = new ListTableModel(columns, tableData2);
        if (listTableModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tableModel");
        }
        object4 = new TableView<PluginStartupCostEntry>(listTableModel);
        PluginStartupCostDialog pluginStartupCostDialog = this;
        boolean bl8 = false;
        boolean bl9 = false;
        Object $this$apply = object4;
        boolean bl10 = false;
        ((JBTable)$this$apply).setShowColumns(true);
        pluginStartupCostDialog.table = object = object4;
        TableView<PluginStartupCostEntry> tableView = this.table;
        if (tableView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        return new JBScrollPane(tableView);
    }

    @Override
    @NotNull
    protected Action[] createLeftSideActions() {
        AbstractAction disableAction2 = new AbstractAction(this, "Disable Selected Plugins"){
            final /* synthetic */ PluginStartupCostDialog this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                for (PluginStartupCostEntry costEntry : this.this$0.getTable().getSelectedObjects()) {
                    this.this$0.getPluginsToDisable().add(costEntry.getPluginId());
                }
                this.this$0.getTableModel().fireTableDataChanged();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        return new Action[]{disableAction2};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doOKAction() {
        super.doOKAction();
        Collection collection = this.pluginsToDisable;
        boolean bl = false;
        if (!collection.isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.pluginsToDisable;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin(PluginId.getId((String)it));
                collection2.add(ideaPluginDescriptor);
            }
            Set plugins2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            IdeErrorsDialog.confirmDisablePlugins(this.project, plugins2);
        }
    }

    public PluginStartupCostDialog(@NotNull Project project2) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.project = project2;
        PluginStartupCostDialog pluginStartupCostDialog = this;
        boolean bl = false;
        pluginStartupCostDialog.pluginsToDisable = set = (Set)new LinkedHashSet();
        this.setTitle("Startup Time Cost per Plugin");
        this.init();
    }
}

