/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.visitors;

import com.intellij.diagnostic.hprof.classstore.ThreadInfo;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.RecordType;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0016\n\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J(\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016J8\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/diagnostic/hprof/visitors/CollectThreadInfoVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "threadsMap", "Lgnu/trove/TLongObjectHashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ThreadInfo;", "stringIdMap", "", "(Lgnu/trove/TLongObjectHashMap;Lgnu/trove/TLongObjectHashMap;)V", "classSerialNumberToNameMap", "stackFrameIdToStringMap", "getStackFrameString", "methodNameStringId", "", "sourceFilenameStringId", "classSerialNumber", "lineNumber", "", "preVisit", "", "visitLoadClass", "classObjectId", "stackSerialNumber", "classNameStringId", "visitStackFrame", "stackFrameId", "methodSignatureStringId", "visitStackTrace", "stackTraceSerialNumber", "threadSerialNumber", "numberOfFrames", "stackFrameIds", "", "intellij.platform.ide.impl"})
public final class CollectThreadInfoVisitor
extends HProfVisitor {
    private final TLongObjectHashMap<String> stackFrameIdToStringMap;
    private final TLongObjectHashMap<String> classSerialNumberToNameMap;
    private final TLongObjectHashMap<ThreadInfo> threadsMap;
    private final TLongObjectHashMap<String> stringIdMap;

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(RecordType.StackFrame);
        this.enable(RecordType.StackTrace);
        this.enable(RecordType.LoadClass);
    }

    @Override
    public void visitLoadClass(long classSerialNumber, long classObjectId, long stackSerialNumber, long classNameStringId) {
        String string = this.stringIdMap.get(classNameStringId);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringIdMap[classNameStringId]");
        this.classSerialNumberToNameMap.put(classSerialNumber, StringsKt.replace$default((String)string, (String)"/", (String)".", (boolean)false, (int)4, null));
    }

    @Override
    public void visitStackFrame(long stackFrameId, long methodNameStringId, long methodSignatureStringId, long sourceFilenameStringId, long classSerialNumber, int lineNumber) {
        this.stackFrameIdToStringMap.put(stackFrameId, this.getStackFrameString(methodNameStringId, sourceFilenameStringId, classSerialNumber, lineNumber));
    }

    private final String getStackFrameString(long methodNameStringId, long sourceFilenameStringId, long classSerialNumber, int lineNumber) {
        StringBuilder sb = new StringBuilder();
        if (classSerialNumber != 0L) {
            sb.append(this.classSerialNumberToNameMap.get(classSerialNumber));
            sb.append(".");
            if (methodNameStringId != 0L) {
                sb.append(this.stringIdMap.get(methodNameStringId));
            } else {
                sb.append("<unknown method>");
            }
        } else {
            sb.append("<unknown location>");
        }
        if (lineNumber == -1) {
            sb.append("(Native method)");
        } else if (sourceFilenameStringId != 0L) {
            sb.append('(' + this.stringIdMap.get(sourceFilenameStringId));
            if (lineNumber > 0) {
                sb.append("" + ':' + lineNumber);
            }
            sb.append(")");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitStackTrace(long stackTraceSerialNumber, long threadSerialNumber, int numberOfFrames, @NotNull long[] stackFrameIds) {
        Intrinsics.checkParameterIsNotNull((Object)stackFrameIds, (String)"stackFrameIds");
        ArrayList<String> frames = new ArrayList<String>(stackFrameIds.length);
        int n = 0;
        int n2 = stackFrameIds.length;
        while (n < n2) {
            void i;
            frames.add(this.stackFrameIdToStringMap.get(stackFrameIds[i]));
            ++i;
        }
        this.threadsMap.put(threadSerialNumber, new ThreadInfo((List<String>)frames));
    }

    public CollectThreadInfoVisitor(@NotNull TLongObjectHashMap<ThreadInfo> threadsMap, @NotNull TLongObjectHashMap<String> stringIdMap) {
        Intrinsics.checkParameterIsNotNull(threadsMap, (String)"threadsMap");
        Intrinsics.checkParameterIsNotNull(stringIdMap, (String)"stringIdMap");
        this.threadsMap = threadsMap;
        this.stringIdMap = stringIdMap;
        this.stackFrameIdToStringMap = new TLongObjectHashMap();
        this.classSerialNumberToNameMap = new TLongObjectHashMap();
    }
}

