/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jdom.Element;

public class LogFilter
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(LogFilter.class);
    public String myName;
    public String myIconPath;
    private Icon myIcon;

    public LogFilter(String name, Icon icon2) {
        this.myName = name;
        this.myIcon = icon2;
    }

    public LogFilter(String name, String iconPath) {
        this.myName = name;
        this.myIconPath = iconPath;
    }

    public LogFilter(String name) {
        this.myName = name;
    }

    public LogFilter() {
    }

    public String toString() {
        return this.myName;
    }

    public void setIcon(Icon icon2) {
        this.myIcon = icon2;
    }

    public boolean isAcceptable(String line) {
        return true;
    }

    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        if (this.myIconPath != null && new File(FileUtil.toSystemDependentName(this.myIconPath)).exists()) {
            Image image = null;
            try {
                image = ImageLoader.loadFromStream(VfsUtilCore.convertToURL(VfsUtil.pathToUrl(this.myIconPath)).openStream());
            }
            catch (IOException e) {
                LOG.debug(e);
            }
            if (image != null) {
                return new JBImageIcon(image);
            }
        }
        return null;
    }

    @Override
    public void readExternal(Element element2) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element2);
    }

    @Override
    public void writeExternal(Element element2) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(this, element2);
    }
}

