/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.tracing;

import com.intellij.diagnostic.tracing.MethodTracerData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.swing.SwingUtilities;

public class MethodTracer {
    private final String myId;
    private final String myClassName;
    private final String myMethodName;
    private final AtomicLong myInvocationCount = new AtomicLong(0L);
    private final AtomicLong myNonRecursiveCount = new AtomicLong(0L);
    private final AtomicLong myTotalTime = new AtomicLong(0L);
    private final AtomicLong myMaxTime = new AtomicLong(0L);
    private final AtomicLong myTimeOnEdt = new AtomicLong(0L);
    private final AtomicLong myCountOnEdt = new AtomicLong(0L);
    private final AtomicLong myMaxTimeOnEdt = new AtomicLong(0L);
    private final AtomicInteger myMaxRecursionDepth = new AtomicInteger(0);
    private final ThreadLocal<Long> currentCalculationStart = ThreadLocal.withInitial(() -> null);
    private final ThreadLocal<Integer> currentRecursionDepth = ThreadLocal.withInitial(() -> 0);
    private static final MyConcurrentMap<String, MethodTracer> tracersMap = new MyConcurrentMap();
    private static boolean enabled = true;
    private static final MethodTracer empty = new MethodTracer("$$emptyTracer$$", "", ""){

        @Override
        public void onMethodEnter() {
        }

        @Override
        public void onMethodExit() {
        }

        @Override
        public MethodTracerData getCurrentData() {
            throw new UnsupportedOperationException();
        }
    };
    private static final ThreadLocal<Boolean> isDispatchThread = ThreadLocal.withInitial(() -> SwingUtilities.isEventDispatchThread());

    private MethodTracer(String id2, String className, String methodName) {
        this.myId = id2;
        this.myClassName = className;
        this.myMethodName = methodName;
    }

    public void onMethodEnter() {
        this.myInvocationCount.incrementAndGet();
        Integer recursionOnStart = this.currentRecursionDepth.get();
        this.myMaxRecursionDepth.updateAndGet(old -> Math.max(old, recursionOnStart));
        if (recursionOnStart == 0) {
            this.currentCalculationStart.set(System.nanoTime());
            this.myNonRecursiveCount.incrementAndGet();
        }
        this.currentRecursionDepth.set(recursionOnStart + 1);
    }

    public void onMethodExit() {
        this.currentRecursionDepth.set(this.currentRecursionDepth.get() - 1);
        if (this.currentRecursionDepth.get() == 0) {
            long duration = System.nanoTime() - this.currentCalculationStart.get();
            this.currentCalculationStart.set(null);
            this.myTotalTime.addAndGet(duration);
            this.myMaxTime.updateAndGet(old -> Math.max(old, duration));
            if (isDispatchThread.get().booleanValue()) {
                this.myCountOnEdt.incrementAndGet();
                this.myTimeOnEdt.addAndGet(duration);
                this.myMaxTimeOnEdt.updateAndGet(old -> Math.max(old, duration));
            }
        }
    }

    public MethodTracerData getCurrentData() {
        return new MethodTracerData(this.myId, this.myClassName, this.myMethodName, this.myInvocationCount.get(), this.myNonRecursiveCount.get(), MethodTracer.toMillis(this.myTotalTime.get()), MethodTracer.toMillis(this.myMaxTime.get()), this.myCountOnEdt.get(), MethodTracer.toMillis(this.myTimeOnEdt.get()), MethodTracer.toMillis(this.myMaxTimeOnEdt.get()), this.myMaxRecursionDepth.get());
    }

    private static long toMillis(long time) {
        return TimeUnit.NANOSECONDS.toMillis(time);
    }

    public static MethodTracer getInstance(String id2, String className, String methodName) {
        return MethodTracer.isEnabled() ? tracersMap.putIfAbsent(id2, new MethodTracer(id2, className, methodName)) : empty;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        MethodTracer.enabled = enabled;
    }

    public static void clearAll() {
        tracersMap.clear();
    }

    public static List<MethodTracerData> getAllData() {
        return tracersMap.map((k, v) -> v.getCurrentData());
    }

    private static class MyConcurrentMap<K, V> {
        private final AtomicReference<Map<K, V>> myReference = new AtomicReference(Collections.emptyMap());

        private MyConcurrentMap() {
        }

        public V putIfAbsent(K key, V value2) {
            HashMap<K, V> newMap;
            Map<K, V> prevMap;
            do {
                V existingValue;
                if ((existingValue = (prevMap = this.myReference.get()).get(key)) != null) {
                    return existingValue;
                }
                newMap = new HashMap<K, V>(prevMap);
                newMap.put(key, value2);
            } while (!this.myReference.compareAndSet(prevMap, Collections.unmodifiableMap(newMap)));
            return value2;
        }

        public void clear() {
            this.myReference.set(Collections.emptyMap());
        }

        public Collection<V> values() {
            return this.myReference.get().values();
        }

        public <T> List<T> map(BiFunction<? super K, ? super V, T> function) {
            Map<Object, Object> map2 = this.myReference.get();
            ArrayList result2 = new ArrayList(map2.size());
            map2.forEach((k, v) -> result2.add(function.apply((Object)k, (Object)v)));
            return result2;
        }
    }
}

