/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactoryEx {
    private static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @Override
    @NotNull
    public EmptyContent createEmpty() {
        return new EmptyContent();
    }

    @Override
    @NotNull
    public DocumentContent create(@NotNull String text2) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(0);
        }
        DocumentContent documentContent = this.create(null, text2);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(1);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable FileType type) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(2);
        }
        DocumentContent documentContent = this.create(null, text2, type);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(3);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable FileType type, boolean respectLineSeparators) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(4);
        }
        DocumentContent documentContent = this.create(null, text2, type, respectLineSeparators);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(5);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable VirtualFile highlightFile) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(6);
        }
        DocumentContent documentContent = this.create(null, text2, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(7);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@NotNull String text2, @Nullable DocumentContent referent) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(8);
        }
        DocumentContent documentContent = this.create(null, text2, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(9);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(10);
        }
        DocumentContent documentContent = this.create(project2, text2, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(11);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable FileType type) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(12);
        }
        DocumentContent documentContent = this.create(project2, text2, type, true);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(13);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable FileType type, boolean respectLineSeparators) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(14);
        }
        return DiffContentFactoryImpl.createImpl(project2, text2, type, null, null, null, respectLineSeparators, true);
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @NotNull FilePath filePath2) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(15);
        }
        if (filePath2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(16);
        }
        return DiffContentFactoryImpl.createImpl(project2, text2, filePath2.getFileType(), filePath2, filePath2.getName(), filePath2.getVirtualFile(), true, true);
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable VirtualFile highlightFile) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(17);
        }
        FileType fileType = highlightFile != null ? highlightFile.getFileType() : null;
        FilePath filePath2 = highlightFile != null ? VcsUtil.getFilePath(highlightFile) : null;
        String fileName = highlightFile != null ? highlightFile.getName() : null;
        return DiffContentFactoryImpl.createImpl(project2, text2, fileType, filePath2, fileName, highlightFile, true, true);
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull String text2, @Nullable DocumentContent referent) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(18);
        }
        if (referent == null) {
            DocumentContent documentContent = this.create(text2);
            if (documentContent == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(19);
            }
            return documentContent;
        }
        return DiffContentFactoryImpl.createImpl(project2, text2, referent.getContentType(), null, null, referent.getHighlightFile(), false, true);
    }

    @Override
    @NotNull
    public DocumentContent createEditable(@Nullable Project project2, @NotNull String text2, @Nullable FileType fileType) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(20);
        }
        return DiffContentFactoryImpl.createImpl(project2, text2, fileType, null, null, null, false, false);
    }

    @Override
    @NotNull
    public DocumentContent create(@NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(21);
        }
        DocumentContent documentContent = this.create(null, document, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(22);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(23);
        }
        DocumentContent documentContent = this.create(project2, document, (FileType)null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(24);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable FileType fileType) {
        VirtualFile file2;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(25);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) != null) {
            return new FileDocumentContentImpl(project2, document, file2);
        }
        return new DocumentContentImpl(project2, document, fileType, null, null, null, null);
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable VirtualFile highlightFile) {
        VirtualFile file2;
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(26);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) != null && file2.equals(highlightFile)) {
            return new FileDocumentContentImpl(project2, document, file2);
        }
        if (highlightFile == null) {
            return new DocumentContentImpl(document);
        }
        return new DocumentContentImpl(project2, document, highlightFile.getFileType(), highlightFile, null, null, null);
    }

    @Override
    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable DocumentContent referent) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(27);
        }
        if (referent == null) {
            return new DocumentContentImpl(document);
        }
        return new DocumentContentImpl(project2, document, referent.getContentType(), referent.getHighlightFile(), null, null, null);
    }

    @Override
    @NotNull
    public DiffContent create(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(28);
        }
        return DiffContentFactoryImpl.createContentFromFile(project2, file2);
    }

    @Override
    @Nullable
    public DocumentContent createDocument(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(29);
        }
        return ObjectUtils.tryCast(DiffContentFactoryImpl.createContentFromFile(project2, file2), DocumentContent.class);
    }

    @Override
    @Nullable
    public FileContent createFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(30);
        }
        if (file2.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project2, file2);
    }

    @Override
    @NotNull
    public DocumentContent createFragment(@Nullable Project project2, @NotNull Document document, @NotNull TextRange range2) {
        if (document == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(31);
        }
        if (range2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(32);
        }
        DocumentContent content2 = this.create(project2, document);
        DocumentContent documentContent = this.createFragment(project2, content2, range2);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(33);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createFragment(@Nullable Project project2, @NotNull DocumentContent content2, @NotNull TextRange range2) {
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(34);
        }
        if (range2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(35);
        }
        return new DocumentFragmentContent(project2, content2, range2);
    }

    @Override
    @NotNull
    public DiffContent createClipboardContent() {
        DocumentContent documentContent = this.createClipboardContent(null, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(36);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent referent) {
        DocumentContent documentContent = this.createClipboardContent(null, referent);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(37);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createClipboardContent(@Nullable Project project2) {
        DocumentContent documentContent = this.createClipboardContent(project2, null);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(38);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createClipboardContent(@Nullable Project project2, @Nullable DocumentContent referent) {
        String text2 = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        FileType type = referent != null ? referent.getContentType() : null;
        VirtualFile highlightFile = referent != null ? referent.getHighlightFile() : null;
        FilePath filePath2 = highlightFile != null ? VcsUtil.getFilePath(highlightFile) : null;
        return DiffContentFactoryImpl.createImpl(project2, StringUtil.notNullize(text2), type, filePath2, "Clipboard.txt", highlightFile, false, false);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, byte @NotNull [] content2, @NotNull FilePath filePath2) throws IOException {
        if (filePath2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(39);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(40);
        }
        DiffContent diffContent = this.createFromBytes(project2, content2, filePath2, null);
        if (diffContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(41);
        }
        return diffContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, byte @NotNull [] content2, @NotNull FilePath filePath2, @Nullable Charset defaultCharset) throws IOException {
        if (filePath2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(42);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(43);
        }
        if (defaultCharset == null && DiffContentFactoryImpl.isBinaryContent(content2, filePath2.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project2, content2, filePath2.getFileType(), filePath2, filePath2.getVirtualFile());
        }
        return DiffContentFactoryImpl.createDocumentFromBytes(project2, content2, filePath2, defaultCharset);
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, byte @NotNull [] content2, @NotNull FileType fileType, @NotNull String fileName) throws IOException {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(44);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(45);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(46);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content2, fileType)) {
            return DiffContentFactoryImpl.createBinaryImpl(project2, content2, fileType, VcsUtil.getFilePath(fileName), null);
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project2, content2, fileType, fileName);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(47);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, byte @NotNull [] content2, @NotNull VirtualFile highlightFile) throws IOException {
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(48);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(49);
        }
        if (DiffContentFactoryImpl.isBinaryContent(content2, highlightFile.getFileType())) {
            return DiffContentFactoryImpl.createBinaryImpl(project2, content2, highlightFile.getFileType(), VcsUtil.getFilePath(highlightFile), highlightFile);
        }
        DocumentContent documentContent = this.createDocumentFromBytes(project2, content2, highlightFile);
        if (documentContent == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(50);
        }
        return documentContent;
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, byte @NotNull [] content2, @NotNull FileType fileType, @NotNull String fileName) {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(51);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(52);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(53);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(project2, content2, fileType);
        return DiffContentFactoryImpl.createFromBytesImpl(project2, content2, fileType, null, fileName, null, charset);
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, byte @NotNull [] content2, @NotNull FilePath filePath2) {
        if (filePath2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(54);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(55);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(content2, filePath2);
        return DiffContentFactoryImpl.createFromBytesImpl(project2, content2, filePath2.getFileType(), filePath2, filePath2.getName(), filePath2.getVirtualFile(), charset);
    }

    @NotNull
    private static DocumentContent createDocumentFromBytes(@Nullable Project project2, byte @NotNull [] content2, @NotNull FilePath filePath2, @Nullable Charset defaultCharset) {
        if (filePath2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(56);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(57);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(content2, filePath2.getFileType(), defaultCharset != null ? defaultCharset : filePath2.getCharset());
        return DiffContentFactoryImpl.createFromBytesImpl(project2, content2, filePath2.getFileType(), filePath2, filePath2.getName(), filePath2.getVirtualFile(), charset);
    }

    @Override
    @NotNull
    public DocumentContent createDocumentFromBytes(@Nullable Project project2, byte @NotNull [] content2, @NotNull VirtualFile highlightFile) {
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(58);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(59);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset(content2, highlightFile);
        FilePath filePath2 = VcsUtil.getFilePath(highlightFile);
        return DiffContentFactoryImpl.createFromBytesImpl(project2, content2, highlightFile.getFileType(), filePath2, highlightFile.getName(), highlightFile, charset);
    }

    @Override
    @NotNull
    public DiffContent createBinary(@Nullable Project project2, byte @NotNull [] content2, @NotNull FileType type, @NotNull String fileName) throws IOException {
        if (type == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(60);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(61);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(62);
        }
        return DiffContentFactoryImpl.createBinaryImpl(project2, content2, type, VcsUtil.getFilePath(fileName), null);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(63);
        }
        return DiffContentFactoryImpl.createContentFromFile(project2, file2, file2);
    }

    @NotNull
    private static DiffContent createContentFromFile(@Nullable Project project2, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        if (file2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(64);
        }
        if (file2.isDirectory()) {
            return new DirectoryContentImpl(project2, file2, highlightFile);
        }
        Document document = ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file2));
        if (document != null) {
            return new FileDocumentContentImpl(project2, document, file2, highlightFile);
        }
        return new FileContentImpl(project2, file2, highlightFile);
    }

    @NotNull
    private static DiffContent createBinaryImpl(@Nullable Project project2, byte @NotNull [] content2, @NotNull FileType type, @NotNull FilePath path2, @Nullable VirtualFile highlightFile) throws IOException {
        VirtualFile file2;
        boolean useTemporalFile;
        if (type == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(65);
        }
        if (path2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(66);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(67);
        }
        boolean bl = useTemporalFile = type instanceof ArchiveFileType || BinaryFileTypeDecompilers.getInstance().forFileType(type) != null;
        if (useTemporalFile) {
            file2 = DiffContentFactoryImpl.createTemporalFile(project2, "tmp", path2.getName(), content2);
        } else {
            file2 = new MyBinaryLightVirtualFile(path2, type, content2);
            file2.setWritable(false);
        }
        file2.putUserData(DiffUtil.TEMP_FILE_KEY, Boolean.TRUE);
        return DiffContentFactoryImpl.createContentFromFile(project2, file2, highlightFile);
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project2, @NotNull String text2, @Nullable FileType fileType, @Nullable FilePath originalFilePath, @Nullable String fileName, @Nullable VirtualFile highlightFile, boolean respectLineSeparators, boolean readOnly) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(68);
        }
        return DiffContentFactoryImpl.createImpl(project2, text2, fileType, originalFilePath, fileName, highlightFile, null, null, respectLineSeparators, readOnly);
    }

    @NotNull
    private static DocumentContent createImpl(@Nullable Project project2, @NotNull String text2, @Nullable FileType fileType, @Nullable FilePath originalFilePath, @Nullable @NonNls String fileName, @Nullable VirtualFile highlightFile, @Nullable Charset charset, @Nullable Boolean bom, boolean respectLineSeparators, boolean readOnly) {
        if (text2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(69);
        }
        if (FileTypes.UNKNOWN.equals(fileType)) {
            fileType = PlainTextFileType.INSTANCE;
        }
        LineSeparator separator = respectLineSeparators ? StringUtil.detectSeparators(text2) : null;
        String correctedContent = StringUtil.convertLineSeparators(text2);
        Document document = DiffContentFactoryImpl.createDocument(project2, correctedContent, fileType, originalFilePath, fileName, readOnly);
        DocumentContentImpl content2 = new DocumentContentImpl(project2, document, fileType, highlightFile, separator, charset, bom);
        if (fileName != null) {
            content2.putUserData(DiffUserDataKeysEx.FILE_NAME, fileName);
        }
        DocumentContentImpl documentContentImpl = content2;
        if (documentContentImpl == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(70);
        }
        return documentContentImpl;
    }

    @NotNull
    private static DocumentContent createFromBytesImpl(@Nullable Project project2, byte @NotNull [] content2, @NotNull FileType fileType, @Nullable FilePath originalFilePath, @NotNull String fileName, @Nullable VirtualFile highlightFile, @NotNull Charset charset) {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(71);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(72);
        }
        if (charset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(73);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(74);
        }
        if (fileType.isBinary()) {
            fileType = PlainTextFileType.INSTANCE;
        }
        boolean isBOM = CharsetToolkit.guessFromBOM(content2) != null;
        boolean malformedContent = false;
        String text2 = CharsetToolkit.tryDecodeString(content2, charset);
        if (text2 == null) {
            text2 = CharsetToolkit.decodeString(content2, charset);
            malformedContent = true;
        }
        DocumentContent documentContent = DiffContentFactoryImpl.createImpl(project2, text2, fileType, originalFilePath, fileName, highlightFile, charset, isBOM, true, true);
        if (malformedContent) {
            String notificationText = DiffBundle.message("error.content.decoded.with.wrong.charset", charset.name());
            DiffUtil.addNotification(DiffNotifications.createNotification(notificationText, LightColors.RED), documentContent);
        }
        DocumentContent documentContent2 = documentContent;
        if (documentContent2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(75);
        }
        return documentContent2;
    }

    @NotNull
    private static VirtualFile createTemporalFile(@Nullable Project project2, @NonNls @NotNull String prefix, @NonNls @NotNull String suffix, byte @NotNull [] content2) throws IOException {
        VirtualFile file2;
        if (prefix == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(76);
        }
        if (suffix == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(77);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(78);
        }
        File tempFile = FileUtil.createTempFile(PathUtil.suggestFileName(prefix + "_", true, false), PathUtil.suggestFileName("_" + suffix, true, false), true);
        if (content2.length != 0) {
            FileUtil.writeToFile(tempFile, content2);
        }
        if (!tempFile.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file2 = VfsUtil.findFileByIoFile(tempFile, true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh(true, true, true, file2);
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(79);
        }
        return virtualFile2;
    }

    @NotNull
    private static Document createDocument(@Nullable Project project2, @NotNull String content2, @Nullable FileType fileType, @Nullable FilePath originalFilePath, @Nullable @NonNls String fileName, boolean readOnly) {
        Document document;
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(80);
        }
        if (project2 != null && !project2.isDefault() && fileType != null && !fileType.isBinary() && Registry.is("diff.enable.psi.highlighting")) {
            if (fileName == null) {
                fileName = "diff." + StringUtil.defaultIfEmpty(fileType.getDefaultExtension(), "txt");
            }
            if ((document = DiffContentFactoryImpl.createPsiDocument(project2, content2, fileType, originalFilePath, fileName, readOnly)) != null) {
                Document document2 = document;
                if (document2 == null) {
                    DiffContentFactoryImpl.$$$reportNull$$$0(81);
                }
                return document2;
            }
        }
        document = EditorFactory.getInstance().createDocument(content2);
        document.setReadOnly(readOnly);
        Document document3 = document;
        if (document3 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(82);
        }
        return document3;
    }

    @Nullable
    private static Document createPsiDocument(@NotNull Project project2, @NotNull String content2, @NotNull FileType fileType, @Nullable FilePath originalFilePath, @NonNls @NotNull String fileName, boolean readOnly) {
        if (project2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(83);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(84);
        }
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(85);
        }
        if (fileName == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(86);
        }
        return ReadAction.compute(() -> {
            LightVirtualFile file2 = new LightVirtualFile(fileName, fileType, (CharSequence)content2);
            file2.setWritable(!readOnly);
            OutsidersPsiFileSupport.markFile(file2, originalFilePath != null ? originalFilePath.getPath() : null);
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document == null) {
                return null;
            }
            PsiDocumentManager.getInstance(project2).getPsiFile(document);
            return document;
        });
    }

    private static boolean isBinaryContent(byte @NotNull [] content2, @NotNull FileType fileType) {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(87);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(88);
        }
        if (UnknownFileType.INSTANCE.equals(fileType)) {
            return DiffContentFactoryImpl.guessCharsetFromContent(content2) == null;
        }
        if (fileType instanceof UIBasedFileType) {
            return true;
        }
        return fileType.isBinary();
    }

    @NotNull
    public static Charset guessCharset(byte @NotNull [] content2, @NotNull FilePath filePath2) {
        if (filePath2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(89);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(90);
        }
        return DiffContentFactoryImpl.guessCharset(content2, filePath2.getFileType(), filePath2.getCharset());
    }

    @NotNull
    public static Charset guessCharset(byte @NotNull [] content2, @NotNull VirtualFile highlightFile) {
        if (highlightFile == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(91);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(92);
        }
        return DiffContentFactoryImpl.guessCharset(content2, highlightFile.getFileType(), highlightFile.getCharset());
    }

    @NotNull
    public static Charset guessCharset(@Nullable Project project2, byte @NotNull [] content2, @NotNull FileType fileType) {
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(93);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(94);
        }
        EncodingManager e = project2 != null ? EncodingProjectManager.getInstance(project2) : EncodingManager.getInstance();
        return DiffContentFactoryImpl.guessCharset(content2, fileType, e.getDefaultCharset());
    }

    @NotNull
    private static Charset guessCharset(byte @NotNull [] content2, @NotNull FileType fileType, @NotNull Charset defaultCharset) {
        Charset guessedCharset;
        Charset bomCharset;
        if (fileType == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(95);
        }
        if (defaultCharset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(96);
        }
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(97);
        }
        if ((bomCharset = CharsetToolkit.guessFromBOM(content2)) != null) {
            Charset charset = bomCharset;
            if (charset == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(98);
            }
            return charset;
        }
        if (fileType.isBinary() && (guessedCharset = DiffContentFactoryImpl.guessCharsetFromContent(content2)) != null) {
            Charset charset = guessedCharset;
            if (charset == null) {
                DiffContentFactoryImpl.$$$reportNull$$$0(99);
            }
            return charset;
        }
        Charset charset = defaultCharset;
        if (charset == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(100);
        }
        return charset;
    }

    @Nullable
    private static Charset guessCharsetFromContent(byte @NotNull [] content2) {
        CharsetToolkit toolkit;
        Charset fromBOM;
        if (content2 == null) {
            DiffContentFactoryImpl.$$$reportNull$$$0(101);
        }
        if ((fromBOM = (toolkit = new CharsetToolkit(content2)).guessFromBOM()) != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content2.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: {
                return Charset.forName("US-ASCII");
            }
            case VALID_UTF8: {
                return StandardCharsets.UTF_8;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 22: 
            case 24: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 47: 
            case 50: 
            case 70: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 98: 
            case 99: 
            case 100: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 22: 
            case 24: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 47: 
            case 50: 
            case 70: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 98: 
            case 99: 
            case 100: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 22: 
            case 24: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 47: 
            case 50: 
            case 70: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 98: 
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 16: 
            case 39: 
            case 42: 
            case 54: 
            case 56: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 34: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 53: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 67: 
            case 74: 
            case 78: 
            case 80: 
            case 84: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 97: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 44: 
            case 51: 
            case 71: 
            case 85: 
            case 87: 
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 45: 
            case 52: 
            case 61: 
            case 72: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 48: 
            case 58: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightFile";
                break;
            }
            case 60: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createFragment";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createClipboardContent";
                break;
            }
            case 41: 
            case 47: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromBytes";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createImpl";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromBytesImpl";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporalFile";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "guessCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 22: 
            case 24: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 47: 
            case 50: 
            case 70: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 98: 
            case 99: 
            case 100: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createEditable";
                break;
            }
            case 29: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createFragment";
                break;
            }
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createFromBytes";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentFromBytes";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createBinary";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createContentFromFile";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryImpl";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createImpl";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createFromBytesImpl";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createTemporalFile";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "createPsiDocument";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryContent";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "guessCharset";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "guessCharsetFromContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 22: 
            case 24: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 47: 
            case 50: 
            case 70: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 98: 
            case 99: 
            case 100: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBinaryLightVirtualFile
    extends BinaryLightVirtualFile {
        private final FilePath myPath;

        MyBinaryLightVirtualFile(@NotNull FilePath path2, FileType type, byte @NotNull [] content2) {
            if (path2 == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(1);
            }
            super(path2.getName(), type, content2);
            this.myPath = path2;
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myPath.getPath();
            if (string == null) {
                MyBinaryLightVirtualFile.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/DiffContentFactoryImpl$MyBinaryLightVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/DiffContentFactoryImpl$MyBinaryLightVirtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

