/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.BinaryMergeRequestImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.TextMergeRequestImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    public static final String DIFF_TITLE_RENAME_SEPARATOR = " -> ";
    private final DiffContentFactoryEx myContentFactory = DiffContentFactoryEx.getInstanceEx();

    @Override
    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project2, @Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        assert (file1 != null || file2 != null);
        EmptyContent content1 = file1 != null ? this.myContentFactory.create(project2, file1) : this.myContentFactory.createEmpty();
        EmptyContent content2 = file2 != null ? this.myContentFactory.create(project2, file2) : this.myContentFactory.createEmpty();
        String title1 = this.getContentTitle(file1);
        String title2 = this.getContentTitle(file2);
        String title = this.getTitle(file1, file2);
        return new SimpleDiffRequest(title, content1, content2, title1, title2);
    }

    @Override
    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project2, @NotNull VirtualFile leftFile, @NotNull VirtualFile baseFile, @NotNull VirtualFile rightFile) {
        if (leftFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(1);
        }
        if (rightFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(2);
        }
        DiffContent content1 = this.myContentFactory.create(project2, leftFile);
        DiffContent content2 = this.myContentFactory.create(project2, baseFile);
        DiffContent content3 = this.myContentFactory.create(project2, rightFile);
        String title1 = this.getContentTitle(leftFile);
        String title2 = this.getContentTitle(baseFile);
        String title3 = this.getContentTitle(rightFile);
        return new SimpleDiffRequest(null, content1, content2, content3, title1, title2, title3);
    }

    @Override
    @NotNull
    public ContentDiffRequest createClipboardVsValue(@NotNull String value2) {
        if (value2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(3);
        }
        DiffContent content1 = this.myContentFactory.createClipboardContent();
        DocumentContent content2 = this.myContentFactory.create(value2);
        String title1 = DiffBundle.message("diff.content.clipboard.content.title", new Object[0]);
        String title2 = DiffBundle.message("diff.content.selected.value", new Object[0]);
        String title = DiffBundle.message("diff.clipboard.vs.value.dialog.title", new Object[0]);
        return new SimpleDiffRequest(title, content1, content2, title1, title2);
    }

    @Override
    @Nullable
    public String getContentTitle(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        return DiffRequestFactoryImpl.getContentTitle(VcsUtil.getFilePath(file2));
    }

    @Override
    @NotNull
    public String getTitle(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        FilePath path1 = file1 != null ? VcsUtil.getFilePath(file1) : null;
        FilePath path2 = file2 != null ? VcsUtil.getFilePath(file2) : null;
        return DiffRequestFactoryImpl.getTitle(path1, path2, " vs ");
    }

    @Override
    @NotNull
    public String getTitle(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(4);
        }
        String string = this.getTitle(file2, null);
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getContentTitle(@NotNull FilePath path2) {
        if (path2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(6);
        }
        if (path2.isDirectory()) {
            String string = path2.getPresentableUrl();
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        FilePath parent = path2.getParentPath();
        return DiffRequestFactoryImpl.getContentTitle(path2.getName(), path2.getPresentableUrl(), parent != null ? parent.getPresentableUrl() : null);
    }

    @NotNull
    public static String getTitle(@Nullable FilePath path1, @Nullable FilePath path2, @NotNull String separator) {
        if (separator == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(8);
        }
        assert (path1 != null || path2 != null);
        if (path1 == null || path2 == null) {
            return DiffRequestFactoryImpl.getContentTitle(ObjectUtils.chooseNotNull(path1, path2));
        }
        if ((path1.isDirectory() || path2.isDirectory()) && path1.getPath().equals(path2.getPath())) {
            String string = path1.getPresentableUrl();
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        String name1 = path1.getName();
        String name2 = path2.getName();
        if (path1.isDirectory() ^ path2.isDirectory()) {
            if (path1.isDirectory()) {
                name1 = name1 + File.separatorChar;
            }
            if (path2.isDirectory()) {
                name2 = name2 + File.separatorChar;
            }
        }
        FilePath parent1 = path1.getParentPath();
        FilePath parent2 = path2.getParentPath();
        return DiffRequestFactoryImpl.getRequestTitle(name1, path1.getPresentableUrl(), parent1 != null ? parent1.getPresentableUrl() : null, name2, path2.getPresentableUrl(), parent2 != null ? parent2.getPresentableUrl() : null, separator);
    }

    @NotNull
    private static String getContentTitle(@NotNull String name, @NotNull String path2, @Nullable String parentPath) {
        if (name == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(10);
        }
        if (path2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(11);
        }
        if (parentPath != null) {
            String string = name + " (" + parentPath + ")";
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getRequestTitle(@NotNull String name1, @NotNull String path1, @Nullable String parentPath1, @NotNull String name2, @NotNull String path2, @Nullable String parentPath2, @NotNull String sep) {
        if (name1 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(14);
        }
        if (path1 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(16);
        }
        if (path2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(17);
        }
        if (sep == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(18);
        }
        if (path1.equals(path2)) {
            return DiffRequestFactoryImpl.getContentTitle(name1, path1, parentPath1);
        }
        if (Comparing.equal(parentPath1, parentPath2)) {
            if (parentPath1 != null) {
                String string = name1 + sep + name2 + " (" + parentPath1 + ")";
                if (string == null) {
                    DiffRequestFactoryImpl.$$$reportNull$$$0(19);
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(20);
            }
            return string;
        }
        if (name1.equals(name2)) {
            if (parentPath1 != null && parentPath2 != null) {
                String string = name1 + " (" + parentPath1 + sep + parentPath2 + ")";
                if (string == null) {
                    DiffRequestFactoryImpl.$$$reportNull$$$0(21);
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(22);
            }
            return string;
        }
        if (parentPath1 != null && parentPath2 != null) {
            String string = name1 + sep + name2 + " (" + parentPath1 + sep + parentPath2 + ")";
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = path1 + sep + path2;
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project2, @Nullable FileType fileType, @NotNull Document outputDocument, @NotNull List<String> textContents, @Nullable String title, @NotNull List<String> titles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (outputDocument == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(25);
        }
        if (textContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(26);
        }
        if (titles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(27);
        }
        if (textContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (titles.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only");
        }
        DocumentContent outputContent = this.myContentFactory.create(project2, outputDocument, fileType);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (String text2 : textContents) {
            contents.add(this.myContentFactory.create(project2, text2, fileType));
        }
        TextMergeRequestImpl request2 = new TextMergeRequestImpl(project2, outputContent, originalContent, contents, title, titles);
        TextMergeRequestImpl textMergeRequestImpl = MergeCallback.register(request2, applyCallback);
        if (textMergeRequestImpl == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(28);
        }
        return textMergeRequestImpl;
    }

    @Override
    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(29);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(30);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(31);
        }
        MergeRequest request2 = this.createMergeRequest(project2, output, byteContents, title, contentTitles);
        MergeRequest mergeRequest = MergeCallback.register(request2, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(32);
        }
        return mergeRequest;
    }

    @Override
    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(33);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(34);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(35);
        }
        try {
            return this.createTextMergeRequest(project2, output, byteContents, title, contentTitles);
        }
        catch (InvalidDiffRequestException e) {
            return this.createBinaryMergeRequest(project2, output, byteContents, title, contentTitles);
        }
    }

    @Override
    @NotNull
    public TextMergeRequest createTextMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(36);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(37);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(38);
        }
        TextMergeRequest request2 = this.createTextMergeRequest(project2, output, byteContents, title, contentTitles);
        TextMergeRequest textMergeRequest = MergeCallback.register(request2, applyCallback);
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(39);
        }
        return textMergeRequest;
    }

    @NotNull
    private TextMergeRequest createTextMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(40);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(41);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(42);
        }
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        Document outputDocument = ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(output));
        if (outputDocument == null) {
            throw new InvalidDiffRequestException("Can't get output document: " + output.getPresentableUrl());
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only: " + output.getPresentableUrl());
        }
        DocumentContent outputContent = this.myContentFactory.create(project2, outputDocument);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (byte[] bytes : byteContents) {
            contents.add(this.myContentFactory.createDocumentFromBytes(project2, bytes, output));
        }
        return new TextMergeRequestImpl(project2, outputContent, originalContent, contents, title, contentTitles);
    }

    @Override
    @NotNull
    public MergeRequest createBinaryMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(43);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(44);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(45);
        }
        MergeRequest request2 = this.createBinaryMergeRequest(project2, output, byteContents, title, contentTitles);
        MergeRequest mergeRequest = MergeCallback.register(request2, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(46);
        }
        return mergeRequest;
    }

    @NotNull
    private MergeRequest createBinaryMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(47);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(48);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(49);
        }
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project2, output);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output);
            }
            byte[] originalContent = ReadAction.compute(() -> output.contentsToByteArray());
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            for (byte[] bytes : byteContents) {
                contents.add(this.myContentFactory.createFromBytes(project2, bytes, output));
            }
            return new BinaryMergeRequestImpl(project2, outputContent, originalContent, contents, byteContents, title, contentTitles);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", e);
        }
    }

    @Override
    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(50);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(51);
        }
        String title = DiffBundle.message("merge.window.title.file", output.getPresentableUrl());
        List<String> titles = Arrays.asList(DiffBundle.message("merge.version.title.our", new Object[0]), DiffBundle.message("merge.version.title.base", new Object[0]), DiffBundle.message("merge.version.title.their", new Object[0]));
        MergeRequest mergeRequest = this.createMergeRequestFromFiles(project2, output, fileContents, title, titles, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(52);
        }
        return mergeRequest;
    }

    @Override
    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        TextMergeRequest textMergeRequest;
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(53);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(54);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(55);
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            textMergeRequest = this.createTextMergeRequestFromFiles(project2, output, fileContents, title, contentTitles, applyCallback);
        }
        catch (InvalidDiffRequestException e) {
            MergeRequest mergeRequest = this.createBinaryMergeRequestFromFiles(project2, output, fileContents, title, contentTitles, applyCallback);
            if (mergeRequest == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(57);
            }
            return mergeRequest;
        }
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(56);
        }
        return textMergeRequest;
    }

    @Override
    @NotNull
    public TextMergeRequest createTextMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(58);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(59);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(60);
        }
        ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
        for (VirtualFile virtualFile2 : fileContents) {
            try {
                byteContents.add(ReadAction.compute(() -> file2.contentsToByteArray()));
            }
            catch (IOException e) {
                throw new InvalidDiffRequestException("Can't read from file: " + virtualFile2.getPresentableUrl(), e);
            }
        }
        TextMergeRequest textMergeRequest = this.createTextMergeRequest(project2, output, byteContents, title, contentTitles, applyCallback);
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(61);
        }
        return textMergeRequest;
    }

    @NotNull
    public MergeRequest createBinaryMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        BinaryMergeRequestImpl binaryMergeRequestImpl;
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(62);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(63);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(64);
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project2, output);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output.getPresentableUrl());
            }
            byte[] originalContent = ReadAction.compute(() -> output.contentsToByteArray());
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
            for (VirtualFile virtualFile2 : fileContents) {
                FileContent content2 = this.myContentFactory.createFile(project2, virtualFile2);
                if (content2 == null) {
                    throw new InvalidDiffRequestException("Can't process file: " + virtualFile2.getPresentableUrl());
                }
                contents.add(content2);
                byteContents.add(ReadAction.compute(() -> file2.contentsToByteArray()));
            }
            BinaryMergeRequestImpl request2 = new BinaryMergeRequestImpl(project2, outputContent, originalContent, contents, byteContents, title, contentTitles);
            binaryMergeRequestImpl = MergeCallback.register(request2, applyCallback);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", e);
        }
        if (binaryMergeRequestImpl == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(65);
        }
        return binaryMergeRequestImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffRequestFactoryImpl";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sep";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDocument";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textContents";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 29: 
            case 33: 
            case 36: 
            case 40: 
            case 43: 
            case 47: 
            case 50: 
            case 53: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 30: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteContents";
                break;
            }
            case 31: 
            case 35: 
            case 38: 
            case 42: 
            case 45: 
            case 49: 
            case 55: 
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTitles";
                break;
            }
            case 51: 
            case 54: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffRequestFactoryImpl";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitle";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestTitle";
                break;
            }
            case 28: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequest";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextMergeRequest";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryMergeRequest";
                break;
            }
            case 52: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequestFromFiles";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextMergeRequestFromFiles";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryMergeRequestFromFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createClipboardVsValue";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContentTitle";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRequestTitle";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequest";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createTextMergeRequest";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryMergeRequest";
                break;
            }
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequestFromFiles";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createTextMergeRequestFromFiles";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryMergeRequestFromFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 39: 
            case 46: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

