/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseShowDiffAction
extends DumbAwareAction {
    BaseShowDiffAction() {
        this.setEnabledInModalContext(true);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseShowDiffAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        boolean canShow = this.isAvailable(e);
        presentation.setEnabled(canShow);
        if (ActionPlaces.isPopupPlace(e.getPlace())) {
            presentation.setVisible(canShow);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseShowDiffAction.$$$reportNull$$$0(1);
        }
        Project project2 = e.getProject();
        DiffRequestChain chain = this.getDiffRequestChain(e);
        if (chain == null) {
            return;
        }
        DiffManager.getInstance().showDiff(project2, chain, DiffDialogHints.DEFAULT);
    }

    protected abstract boolean isAvailable(@NotNull AnActionEvent var1);

    protected static boolean hasContent(VirtualFile file2) {
        return !(file2 instanceof VirtualFileWithoutContent);
    }

    @Nullable
    protected abstract DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent var1);

    @NotNull
    protected static MutableDiffRequestChain createMutableChainFromFiles(@Nullable Project project2, @NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            BaseShowDiffAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            BaseShowDiffAction.$$$reportNull$$$0(3);
        }
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DiffRequestFactory requestFactory = DiffRequestFactory.getInstance();
        DiffContent content1 = contentFactory.create(project2, file1);
        DiffContent content2 = contentFactory.create(project2, file2);
        MutableDiffRequestChain chain = new MutableDiffRequestChain(content1, content2);
        chain.setWindowTitle(requestFactory.getTitle(file1, file2));
        chain.setTitle1(requestFactory.getContentTitle(file1));
        chain.setTitle2(requestFactory.getContentTitle(file2));
        MutableDiffRequestChain mutableDiffRequestChain = chain;
        if (mutableDiffRequestChain == null) {
            BaseShowDiffAction.$$$reportNull$$$0(4);
        }
        return mutableDiffRequestChain;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/BaseShowDiffAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/BaseShowDiffAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createMutableChainFromFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMutableChainFromFiles";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

