/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeModelBase<S extends State>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MergeModelBase.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @Nullable
    private final UndoManager myUndoManager;
    @NotNull
    private final TIntArrayList myStartLines;
    @NotNull
    private final TIntArrayList myEndLines;
    @NotNull
    private final TIntHashSet myChangesToUpdate;
    private int myBulkChangeUpdateDepth;
    private boolean myInsideCommand;
    private boolean myDisposed;

    public MergeModelBase(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            MergeModelBase.$$$reportNull$$$0(0);
        }
        this.myStartLines = new TIntArrayList();
        this.myEndLines = new TIntArrayList();
        this.myChangesToUpdate = new TIntHashSet();
        this.myProject = project2;
        this.myDocument = document;
        this.myUndoManager = this.myProject != null ? UndoManager.getInstance(this.myProject) : UndoManager.getGlobalInstance();
        this.myDocument.addDocumentListener(new MyDocumentListener(), this);
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        LOG.assertTrue(this.myBulkChangeUpdateDepth == 0);
        this.myStartLines.clear();
        this.myEndLines.clear();
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public int getChangesCount() {
        return this.myStartLines.size();
    }

    public int getLineStart(int index) {
        return this.myStartLines.get(index);
    }

    public int getLineEnd(int index) {
        return this.myEndLines.get(index);
    }

    public void setChanges(@NotNull List<? extends LineRange> changes) {
        if (changes == null) {
            MergeModelBase.$$$reportNull$$$0(1);
        }
        this.myStartLines.clear(changes.size());
        this.myEndLines.clear(changes.size());
        for (LineRange lineRange : changes) {
            this.myStartLines.add(lineRange.start);
            this.myEndLines.add(lineRange.end);
        }
    }

    public boolean isInsideCommand() {
        return this.myInsideCommand;
    }

    private void setLineStart(int index, int line) {
        this.myStartLines.set(index, line);
    }

    private void setLineEnd(int index, int line) {
        this.myEndLines.set(index, line);
    }

    public void invalidateHighlighters(int index) {
        if (this.myBulkChangeUpdateDepth > 0) {
            this.myChangesToUpdate.add(index);
        } else {
            this.reinstallHighlighters(index);
        }
    }

    public void enterBulkChangeUpdateBlock() {
        ++this.myBulkChangeUpdateDepth;
    }

    public void exitBulkChangeUpdateBlock() {
        --this.myBulkChangeUpdateDepth;
        LOG.assertTrue(this.myBulkChangeUpdateDepth >= 0);
        if (this.myBulkChangeUpdateDepth == 0) {
            this.myChangesToUpdate.forEach(index -> {
                this.reinstallHighlighters(index);
                return true;
            });
            this.myChangesToUpdate.clear();
        }
    }

    protected abstract void reinstallHighlighters(int var1);

    @NotNull
    protected abstract S storeChangeState(int var1);

    protected void restoreChangeState(@NotNull S state) {
        if (state == null) {
            MergeModelBase.$$$reportNull$$$0(2);
        }
        this.setLineStart(((State)state).myIndex, ((State)state).myStartLine);
        this.setLineEnd(((State)state).myIndex, ((State)state).myEndLine);
    }

    @Nullable
    protected S processDocumentChange(int index, int oldLine1, int oldLine2, int shift) {
        int line1 = this.getLineStart(index);
        int line2 = this.getLineEnd(index);
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        boolean rangeAffected = newRange.damaged || oldLine2 >= line1 && oldLine1 <= line2;
        S oldState = rangeAffected ? (S)this.storeChangeState(index) : null;
        this.setLineStart(index, newRange.startLine);
        this.setLineEnd(index, newRange.endLine);
        return oldState;
    }

    public boolean executeMergeCommand(@Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @Nullable TIntArrayList affectedChanges, @NotNull Runnable task2) {
        if (confirmationPolicy == null) {
            MergeModelBase.$$$reportNull$$$0(3);
        }
        if (task2 == null) {
            MergeModelBase.$$$reportNull$$$0(4);
        }
        TIntArrayList allAffectedChanges = affectedChanges != null ? this.collectAffectedChanges(affectedChanges) : null;
        return DiffUtil.executeWriteCommand(this.myProject, this.myDocument, commandName, commandGroupId, confirmationPolicy, underBulkUpdate, () -> {
            LOG.assertTrue(!this.myInsideCommand);
            this.myInsideCommand = true;
            this.enterBulkChangeUpdateBlock();
            try {
                this.registerUndoRedo(true, allAffectedChanges);
                try {
                    task2.run();
                }
                finally {
                    this.registerUndoRedo(false, allAffectedChanges);
                }
            }
            finally {
                this.exitBulkChangeUpdateBlock();
                this.myInsideCommand = false;
            }
        });
    }

    private void registerUndoRedo(boolean undo, @Nullable TIntArrayList affectedChanges) {
        ArrayList<S> states;
        if (this.myUndoManager == null) {
            return;
        }
        if (affectedChanges != null) {
            states = new ArrayList<S>(affectedChanges.size());
            affectedChanges.forEach(index -> {
                states.add(this.storeChangeState(index));
                return true;
            });
        } else {
            states = new ArrayList(this.getChangesCount());
            for (int index2 = 0; index2 < this.getChangesCount(); ++index2) {
                states.add(this.storeChangeState(index2));
            }
        }
        this.myUndoManager.undoableActionPerformed(new MyUndoableAction(this, states, undo));
    }

    public void replaceChange(int index, @NotNull List<? extends CharSequence> newContent) {
        if (newContent == null) {
            MergeModelBase.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(this.isInsideCommand());
        int outputStartLine = this.getLineStart(index);
        int outputEndLine = this.getLineEnd(index);
        DiffUtil.applyModification(this.myDocument, outputStartLine, outputEndLine, newContent);
        if (outputStartLine == outputEndLine) {
            int newOutputEndLine = outputStartLine + newContent.size();
            this.moveChangesAfterInsertion(index, outputStartLine, newOutputEndLine);
        }
    }

    public void appendChange(int index, @NotNull List<? extends CharSequence> newContent) {
        if (newContent == null) {
            MergeModelBase.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(this.isInsideCommand());
        int outputStartLine = this.getLineStart(index);
        int outputEndLine = this.getLineEnd(index);
        DiffUtil.applyModification(this.myDocument, outputEndLine, outputEndLine, newContent);
        int newOutputEndLine = outputEndLine + newContent.size();
        this.moveChangesAfterInsertion(index, outputStartLine, newOutputEndLine);
    }

    private void moveChangesAfterInsertion(int index, int newOutputStartLine, int newOutputEndLine) {
        LOG.assertTrue(this.isInsideCommand());
        if (this.getLineStart(index) != newOutputStartLine || this.getLineEnd(index) != newOutputEndLine) {
            this.setLineStart(index, newOutputStartLine);
            this.setLineEnd(index, newOutputEndLine);
            this.invalidateHighlighters(index);
        }
        boolean beforeChange = true;
        for (int otherIndex = 0; otherIndex < this.getChangesCount(); ++otherIndex) {
            int newEndLine;
            int startLine = this.getLineStart(otherIndex);
            int endLine = this.getLineEnd(otherIndex);
            if (endLine < newOutputStartLine) continue;
            if (startLine > newOutputEndLine) break;
            if (index == otherIndex) {
                beforeChange = false;
                continue;
            }
            int newStartLine = beforeChange ? Math.min(startLine, newOutputStartLine) : Math.max(startLine, newOutputEndLine);
            int n = newEndLine = beforeChange ? Math.min(endLine, newOutputStartLine) : Math.max(endLine, newOutputEndLine);
            if (startLine == newStartLine && endLine == newEndLine) continue;
            this.setLineStart(otherIndex, newStartLine);
            this.setLineEnd(otherIndex, newEndLine);
            this.invalidateHighlighters(otherIndex);
        }
    }

    @NotNull
    private TIntArrayList collectAffectedChanges(@NotNull TIntArrayList directChanges) {
        if (directChanges == null) {
            MergeModelBase.$$$reportNull$$$0(7);
        }
        TIntArrayList result2 = new TIntArrayList(directChanges.size());
        int directArrayIndex = 0;
        int otherIndex = 0;
        while (directArrayIndex < directChanges.size() && otherIndex < this.getChangesCount()) {
            int directIndex = directChanges.get(directArrayIndex);
            if (directIndex == otherIndex) {
                result2.add(directIndex);
                ++otherIndex;
                continue;
            }
            int directStart = this.getLineStart(directIndex);
            int directEnd = this.getLineEnd(directIndex);
            int otherStart = this.getLineStart(otherIndex);
            int otherEnd = this.getLineEnd(otherIndex);
            if (otherEnd < directStart) {
                ++otherIndex;
                continue;
            }
            if (otherStart > directEnd) {
                ++directArrayIndex;
                continue;
            }
            result2.add(otherIndex);
            ++otherIndex;
        }
        LOG.assertTrue(directChanges.size() <= result2.size());
        TIntArrayList tIntArrayList = result2;
        if (tIntArrayList == null) {
            MergeModelBase.$$$reportNull$$$0(8);
        }
        return tIntArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directChanges";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeModelBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeModelBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAffectedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restoreChangeState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeMergeCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedChanges";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        public final int myIndex;
        public final int myStartLine;
        public final int myEndLine;

        public State(int index, int startLine, int endLine) {
            this.myIndex = index;
            this.myStartLine = startLine;
            this.myEndLine = endLine;
        }
    }

    private static class MyUndoableAction
    extends BasicUndoableAction {
        @NotNull
        private final WeakReference<MergeModelBase> myModelRef;
        @NotNull
        private final List<? extends State> myStates;
        private final boolean myUndo;

        MyUndoableAction(@NotNull MergeModelBase model, @NotNull List<? extends State> states, boolean undo) {
            if (model == null) {
                MyUndoableAction.$$$reportNull$$$0(0);
            }
            if (states == null) {
                MyUndoableAction.$$$reportNull$$$0(1);
            }
            super(model.myDocument);
            this.myModelRef = new WeakReference<MergeModelBase>(model);
            this.myStates = states;
            this.myUndo = undo;
        }

        @Override
        public final void undo() {
            MergeModelBase model = (MergeModelBase)this.myModelRef.get();
            if (model != null && this.myUndo) {
                this.restoreStates(model);
            }
        }

        @Override
        public final void redo() {
            MergeModelBase model = (MergeModelBase)this.myModelRef.get();
            if (model != null && !this.myUndo) {
                this.restoreStates(model);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restoreStates(@NotNull MergeModelBase model) {
            if (model == null) {
                MyUndoableAction.$$$reportNull$$$0(2);
            }
            if (model.isDisposed()) {
                return;
            }
            if (model.getChangesCount() == 0) {
                return;
            }
            model.enterBulkChangeUpdateBlock();
            try {
                for (State state : this.myStates) {
                    model.restoreChangeState(state);
                    model.invalidateHighlighters(state.myIndex);
                }
            }
            finally {
                model.exitBulkChangeUpdateBlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "states";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeModelBase$MyUndoableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreStates";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (MergeModelBase.this.isDisposed()) {
                return;
            }
            MergeModelBase.this.enterBulkChangeUpdateBlock();
            if (MergeModelBase.this.getChangesCount() == 0) {
                return;
            }
            LineRange lineRange = DiffUtil.getAffectedLineRange(e);
            int shift = DiffUtil.countLinesShift(e);
            SmartList corruptedStates = new SmartList();
            for (int index = 0; index < MergeModelBase.this.getChangesCount(); ++index) {
                Object oldState = MergeModelBase.this.processDocumentChange(index, lineRange.start, lineRange.end, shift);
                if (oldState == null) continue;
                MergeModelBase.this.invalidateHighlighters(index);
                if (MergeModelBase.this.isInsideCommand()) continue;
                corruptedStates.add(oldState);
            }
            if (MergeModelBase.this.myUndoManager != null && !corruptedStates.isEmpty()) {
                MergeModelBase.this.myUndoManager.undoableActionPerformed(new MyUndoableAction(MergeModelBase.this, corruptedStates, true));
            }
        }

        @Override
        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            if (MergeModelBase.this.isDisposed()) {
                return;
            }
            MergeModelBase.this.exitBulkChangeUpdateBlock();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/merge/MergeModelBase$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

