/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.actions.impl.NextDifferenceAction;
import com.intellij.diff.actions.impl.PrevDifferenceAction;
import com.intellij.diff.merge.ErrorMergeTool;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeContextEx;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MessageMergeViewer;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeRequestProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MergeRequestProcessor.class);
    private boolean myDisposed;
    @Nullable
    private final Project myProject;
    @NotNull
    private final MergeContext myContext;
    @NotNull
    private final List<MergeTool> myAvailableTools;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyPanel myMainPanel;
    @NotNull
    private final Wrapper myContentPanel;
    @NotNull
    private final Wrapper myToolbarPanel;
    @NotNull
    private final Wrapper myToolbarStatusPanel;
    @NotNull
    private final Wrapper myNotificationPanel;
    @NotNull
    private final Wrapper myButtonsPanel;
    @Nullable
    private MergeRequest myRequest;
    @NotNull
    private MergeTool.MergeViewer myViewer;
    @Nullable
    private BooleanGetter myCloseHandler;
    private boolean myConflictResolved = false;

    public MergeRequestProcessor(@Nullable Project project2) {
        this.myProject = project2;
        this.myContext = new MyDiffContext();
        this.myContext.putUserData(DiffUserDataKeys.PLACE, "Merge");
        this.myAvailableTools = DiffManagerEx.getInstance().getMergeTools();
        this.myMainPanel = new MyPanel();
        this.myContentPanel = new Wrapper();
        this.myToolbarPanel = new Wrapper();
        this.myToolbarPanel.setFocusable(true);
        this.myToolbarStatusPanel = new Wrapper();
        this.myNotificationPanel = new Wrapper();
        this.myButtonsPanel = new Wrapper();
        this.myPanel = JBUI.Panels.simplePanel(this.myMainPanel);
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel(this.myToolbarPanel).addToRight(this.myToolbarStatusPanel).addToBottom(this.myNotificationPanel);
        this.myMainPanel.add((Component)topPanel, "North");
        this.myMainPanel.add((Component)this.myContentPanel, "Center");
        this.myMainPanel.add((Component)this.myButtonsPanel, "South");
        this.myMainPanel.setFocusTraversalPolicyProvider(true);
        this.myMainPanel.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.myViewer = new MessageMergeViewer(this.myContext, CommonBundle.getLoadingTreeNodeText());
    }

    public void init(@NotNull MergeRequest request2) {
        if (request2 == null) {
            MergeRequestProcessor.$$$reportNull$$$0(0);
        }
        this.setTitle(request2.getTitle());
        this.myRequest = request2;
        this.myViewer = this.createViewerFor(request2);
        this.initViewer();
        this.installCallbackListener(this.myRequest);
    }

    public void init(@NotNull MergeRequestProducer request2) {
        if (request2 == null) {
            MergeRequestProcessor.$$$reportNull$$$0(1);
        }
        this.setTitle(request2.getName());
        this.initViewer();
        ModalityState modality = ModalityState.stateForComponent(this.myPanel);
        BackgroundTaskUtil.executeOnPooledThread(this, () -> {
            try {
                MergeRequest mergeRequest = request2.process(this.myContext, ProgressManager.getInstance().getProgressIndicator());
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myRequest = mergeRequest;
                    this.swapViewer(this.createViewerFor(mergeRequest));
                    this.installCallbackListener(this.myRequest);
                }, modality);
            }
            catch (Throwable e) {
                LOG.warn(e);
                ApplicationManager.getApplication().invokeLater(() -> this.swapViewer(new MessageMergeViewer(this.myContext, DiffBundle.message("label.cant.show.merge.with.description", e.getMessage()))), modality);
            }
        });
    }

    @NotNull
    private MergeTool.MergeViewer createViewerFor(@NotNull MergeRequest request2) {
        MergeTool.MergeViewer mergeViewer;
        if (request2 == null) {
            MergeRequestProcessor.$$$reportNull$$$0(2);
        }
        try {
            mergeViewer = this.getFittedTool(request2).createComponent(this.myContext, request2);
        }
        catch (Throwable e) {
            LOG.error(e);
            MergeTool.MergeViewer mergeViewer2 = ErrorMergeTool.INSTANCE.createComponent(this.myContext, request2);
            if (mergeViewer2 == null) {
                MergeRequestProcessor.$$$reportNull$$$0(4);
            }
            return mergeViewer2;
        }
        if (mergeViewer == null) {
            MergeRequestProcessor.$$$reportNull$$$0(3);
        }
        return mergeViewer;
    }

    private void initViewer() {
        this.myContentPanel.setContent(this.myViewer.getComponent());
        MergeTool.ToolbarComponents toolbarComponents = this.myViewer.init();
        this.buildToolbar(toolbarComponents.toolbarActions);
        this.myToolbarStatusPanel.setContent(toolbarComponents.statusPanel);
        this.myCloseHandler = toolbarComponents.closeHandler;
        this.updateBottomActions();
    }

    private void destroyViewer() {
        Disposer.dispose(this.myViewer);
        ActionUtil.clearActions(this.myMainPanel);
        this.myContentPanel.setContent(null);
        this.myToolbarPanel.setContent(null);
        this.myToolbarStatusPanel.setContent(null);
        this.myButtonsPanel.setContent(null);
        this.myCloseHandler = null;
    }

    private void updateBottomActions() {
        Action applyLeft = this.myViewer.getResolveAction(MergeResult.LEFT);
        Action applyRight = this.myViewer.getResolveAction(MergeResult.RIGHT);
        final Action resolveAction = this.myViewer.getResolveAction(MergeResult.RESOLVED);
        Action cancelAction = this.myViewer.getResolveAction(MergeResult.CANCEL);
        if (resolveAction != null) {
            resolveAction.putValue("DefaultAction", true);
            new DumbAwareAction(){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    resolveAction.actionPerformed(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/merge/MergeRequestProcessor$1", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, this.getRootPane(), this);
        }
        List<Action> leftActions = ContainerUtil.packNullables(applyLeft, applyRight);
        List<Action> rightActions = SystemInfo.isMac ? ContainerUtil.packNullables(cancelAction, resolveAction) : ContainerUtil.packNullables(resolveAction, cancelAction);
        JRootPane rootPane = this.getRootPane();
        NonOpaquePanel buttonsPanel = new NonOpaquePanel(new BorderLayout());
        buttonsPanel.setBorder(new JBEmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        if (leftActions.size() > 0) {
            buttonsPanel.add((Component)MergeRequestProcessor.createButtonsPanel(leftActions, rootPane), "West");
        }
        if (rightActions.size() > 0) {
            buttonsPanel.add((Component)MergeRequestProcessor.createButtonsPanel(rightActions, rootPane), "East");
        }
        this.myButtonsPanel.setContent(buttonsPanel);
    }

    @NotNull
    private static JPanel createButtonsPanel(@NotNull List<? extends Action> actions, @Nullable JRootPane rootPane) {
        if (actions == null) {
            MergeRequestProcessor.$$$reportNull$$$0(5);
        }
        List<JButton> buttons = ContainerUtil.map(actions, action2 -> DialogWrapper.createJButtonForAction(action2, rootPane));
        JPanel jPanel = DialogWrapper.layoutButtonsPanel(buttons);
        if (jPanel == null) {
            MergeRequestProcessor.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    protected DefaultActionGroup collectToolbarActions(@Nullable List<? extends AnAction> viewerActions) {
        DefaultActionGroup group = new DefaultActionGroup();
        List<AnAction> navigationActions = Arrays.asList(new MyPrevDifferenceAction(), new MyNextDifferenceAction());
        DiffUtil.addActionBlock(group, navigationActions);
        DiffUtil.addActionBlock(group, viewerActions);
        List<AnAction> requestContextActions = this.myRequest != null ? this.myRequest.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS) : null;
        DiffUtil.addActionBlock(group, requestContextActions);
        List<AnAction> contextActions = this.myContext.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(group, contextActions);
        DiffUtil.addActionBlock(group, ActionManager.getInstance().getAction("ContextHelp"));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            MergeRequestProcessor.$$$reportNull$$$0(7);
        }
        return defaultActionGroup;
    }

    protected void buildToolbar(@Nullable List<? extends AnAction> viewerActions) {
        DefaultActionGroup group = this.collectToolbarActions(viewerActions);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DiffToolbar", group, true);
        toolbar.setShowSeparatorTitles(true);
        DataManager.registerDataProvider(toolbar.getComponent(), this.myMainPanel);
        toolbar.setTargetComponent(toolbar.getComponent());
        this.myToolbarPanel.setContent(toolbar.getComponent());
        ActionUtil.recursiveRegisterShortcutSet(group, this.myMainPanel, null);
    }

    @NotNull
    private MergeTool getFittedTool(@NotNull MergeRequest request2) {
        if (request2 == null) {
            MergeRequestProcessor.$$$reportNull$$$0(8);
        }
        for (MergeTool tool : this.myAvailableTools) {
            MergeTool mergeTool;
            try {
                if (!tool.canShow(this.myContext, request2)) continue;
                mergeTool = tool;
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (mergeTool == null) {
                MergeRequestProcessor.$$$reportNull$$$0(9);
            }
            return mergeTool;
        }
        ErrorMergeTool errorMergeTool = ErrorMergeTool.INSTANCE;
        if (errorMergeTool == null) {
            MergeRequestProcessor.$$$reportNull$$$0(10);
        }
        return errorMergeTool;
    }

    private void setTitle(@Nullable String title) {
        if (title == null) {
            title = DiffBundle.message("merge.files.dialog.title", new Object[0]);
        }
        this.setWindowTitle(title);
    }

    private void installCallbackListener(@NotNull MergeRequest request2) {
        if (request2 == null) {
            MergeRequestProcessor.$$$reportNull$$$0(11);
        }
        MergeCallback callback2 = MergeCallback.getCallback(request2);
        callback2.addListener(new MergeCallback.Listener(){

            @Override
            public void fireConflictInvalid() {
                MergeRequestProcessor.this.showInvalidRequestNotification();
            }
        }, this);
        if (!callback2.checkIsValid()) {
            this.showInvalidRequestNotification();
        }
    }

    private void showInvalidRequestNotification() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myDisposed) {
                return;
            }
            if (!this.myNotificationPanel.isNull()) {
                return;
            }
            EditorNotificationPanel notification = new EditorNotificationPanel(LightColors.RED);
            notification.setText(DiffBundle.message("error.conflict.is.not.valid.and.no.longer.can.be.resolved", new Object[0]));
            notification.createActionLabel(DiffBundle.message("button.abort.resolve", new Object[0]), () -> {
                this.applyRequestResult(MergeResult.CANCEL);
                this.closeDialog();
            });
            this.myNotificationPanel.setContent(notification);
            this.myMainPanel.validate();
            this.myMainPanel.repaint();
        }, ModalityState.stateForComponent(this.myPanel));
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.onDispose();
            this.destroyViewer();
            this.applyRequestResult(MergeResult.CANCEL);
        });
    }

    private void applyRequestResult(@NotNull MergeResult result2) {
        if (result2 == null) {
            MergeRequestProcessor.$$$reportNull$$$0(12);
        }
        if (this.myConflictResolved || this.myRequest == null) {
            return;
        }
        this.myConflictResolved = true;
        try {
            this.myRequest.applyResult(result2);
        }
        catch (Exception e) {
            LOG.warn(e);
            new Notification("Merge", DiffBundle.message("can.t.finish.merge.resolve", new Object[0]), e.getMessage(), NotificationType.ERROR).notify(this.myProject);
        }
    }

    private void reopenWithTool(@NotNull MergeTool tool) {
        MergeTool.MergeViewer newViewer;
        if (tool == null) {
            MergeRequestProcessor.$$$reportNull$$$0(13);
        }
        if (this.myRequest == null) {
            return;
        }
        if (this.myConflictResolved) {
            LOG.warn("Can't reopen with " + tool + " - conflict already resolved");
            return;
        }
        if (!tool.canShow(this.myContext, this.myRequest)) {
            LOG.warn("Can't reopen with " + tool + " - " + this.myRequest);
            return;
        }
        try {
            newViewer = tool.createComponent(this.myContext, this.myRequest);
        }
        catch (Throwable e) {
            LOG.error(e);
            return;
        }
        this.swapViewer(newViewer);
    }

    private void swapViewer(@NotNull MergeTool.MergeViewer newViewer) {
        if (newViewer == null) {
            MergeRequestProcessor.$$$reportNull$$$0(14);
        }
        DiffUtil.runPreservingFocus(this.myContext, () -> {
            this.destroyViewer();
            this.myViewer = newViewer;
            this.initViewer();
        });
    }

    protected void onDispose() {
    }

    protected void setWindowTitle(@NotNull String title) {
        if (title == null) {
            MergeRequestProcessor.$$$reportNull$$$0(15);
        }
    }

    public abstract void closeDialog();

    @Nullable
    protected abstract JRootPane getRootPane();

    @Nullable
    public <T> T getContextUserData(@NotNull Key<T> key) {
        if (key == null) {
            MergeRequestProcessor.$$$reportNull$$$0(16);
        }
        return this.myContext.getUserData(key);
    }

    public <T> void putContextUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            MergeRequestProcessor.$$$reportNull$$$0(17);
        }
        this.myContext.putUserData(key, value2);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            MergeRequestProcessor.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component2 = this.myViewer.getPreferredFocusedComponent();
        return component2 != null ? component2 : this.myToolbarPanel.getTargetComponent();
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public MergeContext getContext() {
        MergeContext mergeContext = this.myContext;
        if (mergeContext == null) {
            MergeRequestProcessor.$$$reportNull$$$0(19);
        }
        return mergeContext;
    }

    public boolean checkCloseAction() {
        return this.myConflictResolved || this.myCloseHandler == null || this.myCloseHandler.get();
    }

    private boolean isFocusedInWindow() {
        return DiffUtil.isFocusedComponentInWindow(this.myPanel);
    }

    private void requestFocusInWindow() {
        DiffUtil.requestFocusInWindow(this.getPreferredFocusedComponent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeRequestProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newViewer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewerFor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtonsPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectToolbarActions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFittedTool";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createViewerFor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createButtonsPanel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFittedTool";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installCallbackListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyRequestResult";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reopenWithTool";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "swapViewer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setWindowTitle";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContextUserData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "putContextUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDiffContext
    extends MergeContextEx {
        private MyDiffContext() {
        }

        @Override
        @Nullable
        public Project getProject() {
            return MergeRequestProcessor.this.getProject();
        }

        @Override
        public boolean isFocusedInWindow() {
            return MergeRequestProcessor.this.isFocusedInWindow();
        }

        @Override
        public void requestFocusInWindow() {
            MergeRequestProcessor.this.requestFocusInWindow();
        }

        @Override
        public void finishMerge(@NotNull MergeResult result2) {
            if (result2 == null) {
                MyDiffContext.$$$reportNull$$$0(0);
            }
            MergeRequestProcessor.this.applyRequestResult(result2);
            MergeRequestProcessor.this.closeDialog();
        }

        @Override
        public void reopenWithTool(@NotNull MergeTool tool) {
            if (tool == null) {
                MyDiffContext.$$$reportNull$$$0(1);
            }
            MergeRequestProcessor.this.reopenWithTool(tool);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor$MyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finishMerge";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reopenWithTool";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponent(Container focusCycleRoot) {
            JComponent component2 = MergeRequestProcessor.this.getPreferredFocusedComponent();
            if (component2 == null) {
                return null;
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2, this);
        }

        @Override
        @Nullable
        protected Project getProject() {
            return MergeRequestProcessor.this.myProject;
        }
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        MyPanel() {
            super(new BorderLayout());
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            DataProvider requestProvider;
            Object data2;
            DataProvider contentProvider;
            if (dataId == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            if ((contentProvider = DataManagerImpl.getDataProviderEx(MergeRequestProcessor.this.myContentPanel.getTargetComponent())) != null && (data2 = contentProvider.getData(dataId)) != null) {
                return data2;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return MergeRequestProcessor.this.myProject;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                if (MergeRequestProcessor.this.myRequest != null && MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.HELP_ID) != null) {
                    return MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.HELP_ID);
                }
                return "procedures.vcWithIDEA.commonVcsOps.integrateDiffs.resolveConflict";
            }
            if (DiffDataKeys.MERGE_VIEWER.is(dataId)) {
                return MergeRequestProcessor.this.myViewer;
            }
            DataProvider dataProvider = requestProvider = MergeRequestProcessor.this.myRequest != null ? MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.DATA_PROVIDER) : null;
            if (requestProvider != null && (data2 = requestProvider.getData(dataId)) != null) {
                return data2;
            }
            DataProvider contextProvider = MergeRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (contextProvider != null && (data2 = contextProvider.getData(dataId)) != null) {
                return data2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/diff/merge/MergeRequestProcessor$MyPanel", "getData"));
        }
    }

    private static class MyPrevDifferenceAction
    extends PrevDifferenceAction {
        private MyPrevDifferenceAction() {
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPrevDifferenceAction.$$$reportNull$$$0(0);
            }
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabled(true);
                return;
            }
            PrevNextDifferenceIterable iterable = e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoPrev()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable;
            if (e == null) {
                MyPrevDifferenceAction.$$$reportNull$$$0(1);
            }
            if ((iterable = e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE)) != null && iterable.canGoPrev()) {
                iterable.goPrev();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor$MyPrevDifferenceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyNextDifferenceAction
    extends NextDifferenceAction {
        private MyNextDifferenceAction() {
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNextDifferenceAction.$$$reportNull$$$0(0);
            }
            if (!"DiffToolbar".equals(e.getPlace())) {
                e.getPresentation().setEnabled(true);
                return;
            }
            PrevNextDifferenceIterable iterable = e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoNext()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable;
            if (e == null) {
                MyNextDifferenceAction.$$$reportNull$$$0(1);
            }
            if ((iterable = e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE)) != null && iterable.canGoNext()) {
                iterable.goNext();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor$MyNextDifferenceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

