/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.Function;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeUtil {
    @NotNull
    public static Action createSimpleResolveAction(final @NotNull MergeResult result2, final @NotNull MergeRequest request2, final @NotNull MergeContext context, final @NotNull MergeTool.MergeViewer viewer, final boolean contentWasModified) {
        if (result2 == null) {
            MergeUtil.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MergeUtil.$$$reportNull$$$0(2);
        }
        if (viewer == null) {
            MergeUtil.$$$reportNull$$$0(3);
        }
        String caption = MergeUtil.getResolveActionTitle(result2, request2, context);
        return new AbstractAction(caption){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(viewer, request2, context, contentWasModified)) {
                    return;
                }
                context.finishMerge(result2);
            }
        };
    }

    @Nls
    @NotNull
    public static String getResolveActionTitle(@NotNull MergeResult result2, @Nullable MergeRequest request2, @Nullable MergeContext context) {
        Function<MergeResult, String> getter;
        String message;
        if (result2 == null) {
            MergeUtil.$$$reportNull$$$0(4);
        }
        String string = message = (getter = DiffUtil.getUserData(request2, context, DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS)) != null ? getter.fun(result2) : null;
        if (message != null) {
            String string2 = message;
            if (string2 == null) {
                MergeUtil.$$$reportNull$$$0(5);
            }
            return string2;
        }
        switch (result2) {
            case CANCEL: {
                String string3 = DiffBundle.message("button.merge.resolve.cancel", new Object[0]);
                if (string3 == null) {
                    MergeUtil.$$$reportNull$$$0(6);
                }
                return string3;
            }
            case LEFT: {
                String string4 = DiffBundle.message("button.merge.resolve.accept.left", new Object[0]);
                if (string4 == null) {
                    MergeUtil.$$$reportNull$$$0(7);
                }
                return string4;
            }
            case RIGHT: {
                String string5 = DiffBundle.message("button.merge.resolve.accept.right", new Object[0]);
                if (string5 == null) {
                    MergeUtil.$$$reportNull$$$0(8);
                }
                return string5;
            }
            case RESOLVED: {
                String string6 = DiffBundle.message("button.merge.resolve.apply", new Object[0]);
                if (string6 == null) {
                    MergeUtil.$$$reportNull$$$0(9);
                }
                return string6;
            }
        }
        throw new IllegalArgumentException(result2.toString());
    }

    @NotNull
    public static List<String> notNullizeContentTitles(@NotNull List<String> mergeContentTitles) {
        if (mergeContentTitles == null) {
            MergeUtil.$$$reportNull$$$0(10);
        }
        String left = StringUtil.notNullize(ThreeSide.LEFT.select(mergeContentTitles), DiffBundle.message("merge.version.title.our", new Object[0]));
        String base = StringUtil.notNullize(ThreeSide.BASE.select(mergeContentTitles), DiffBundle.message("merge.version.title.base", new Object[0]));
        String right = StringUtil.notNullize(ThreeSide.RIGHT.select(mergeContentTitles), DiffBundle.message("merge.version.title.their", new Object[0]));
        List<String> list2 = Arrays.asList(left, base, right);
        if (list2 == null) {
            MergeUtil.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull MergeTool.MergeViewer viewer, @NotNull MergeRequest request2, @NotNull MergeContext context, boolean contentWasModified) {
        Condition<MergeTool.MergeViewer> customHandler;
        if (viewer == null) {
            MergeUtil.$$$reportNull$$$0(12);
        }
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(13);
        }
        if (context == null) {
            MergeUtil.$$$reportNull$$$0(14);
        }
        if ((customHandler = DiffUtil.getUserData(request2, context, DiffUserDataKeysEx.MERGE_CANCEL_HANDLER)) != null) {
            return customHandler.value(viewer);
        }
        return !contentWasModified || MergeUtil.showExitWithoutApplyingChangesDialog(viewer.getComponent(), request2, context);
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull JComponent component2, @NotNull MergeRequest request2, @NotNull MergeContext context) {
        Couple<String> customMessage;
        if (component2 == null) {
            MergeUtil.$$$reportNull$$$0(15);
        }
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            MergeUtil.$$$reportNull$$$0(17);
        }
        if ((customMessage = DiffUtil.getUserData(request2, context, DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE)) != null) {
            String message = (String)customMessage.second;
            String title = (String)customMessage.first;
            return Messages.showConfirmationDialog(component2, message, title, CommonBundle.message("button.without.mnemonic.yes", new Object[0]), CommonBundle.message("button.without.mnemonic.no", new Object[0])) == 0;
        }
        return MergeUtil.showConfirmDiscardChangesDialog(component2, DiffBundle.message("button.cancel.merge", new Object[0]), true);
    }

    public static boolean showConfirmDiscardChangesDialog(@NotNull JComponent parent, @NotNull @Nls String actionName, boolean contentWasModified) {
        if (parent == null) {
            MergeUtil.$$$reportNull$$$0(18);
        }
        if (actionName == null) {
            MergeUtil.$$$reportNull$$$0(19);
        }
        if (!contentWasModified) {
            return true;
        }
        return Messages.showConfirmationDialog(parent, DiffBundle.message("label.merge.unsaved.changes.discard.and.do.anyway", actionName.toLowerCase(Locale.ENGLISH)), actionName, DiffBundle.message("button.discard.changes.and.do", actionName), DiffBundle.message("button.continue.merge", new Object[0])) == 0;
    }

    public static boolean shouldRestoreOriginalContentOnCancel(@NotNull MergeRequest request2) {
        MergeCallback callback2;
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(20);
        }
        if ((callback2 = MergeCallback.getCallback(request2)).checkIsValid()) {
            return true;
        }
        return Messages.showYesNoDialog(DiffBundle.message("merge.conflict.is.outdated", new Object[0]), DiffBundle.message("cancel.visual.merge.dialog.title", new Object[0]), CommonBundle.message("button.without.mnemonic.restore", new Object[0]), CommonBundle.message("button.without.mnemonic.do.nothing", new Object[0]), Messages.getQuestionIcon()) == 0;
    }

    public static void putRevisionInfos(@NotNull MergeRequest request2, @NotNull MergeData data2) {
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(21);
        }
        if (data2 == null) {
            MergeUtil.$$$reportNull$$$0(22);
        }
        if (request2 instanceof ThreesideMergeRequest) {
            List<? extends DiffContent> contents = ((ThreesideMergeRequest)request2).getContents();
            MergeUtil.putRevisionInfo(contents, data2);
        }
    }

    public static void putRevisionInfos(@NotNull DiffRequest request2, @NotNull MergeData data2) {
        List<DiffContent> contents;
        if (request2 == null) {
            MergeUtil.$$$reportNull$$$0(23);
        }
        if (data2 == null) {
            MergeUtil.$$$reportNull$$$0(24);
        }
        if (request2 instanceof ContentDiffRequest && (contents = ((ContentDiffRequest)request2).getContents()).size() == 3) {
            MergeUtil.putRevisionInfo(contents, data2);
        }
    }

    private static void putRevisionInfo(@NotNull List<? extends DiffContent> contents, @NotNull MergeData data2) {
        if (contents == null) {
            MergeUtil.$$$reportNull$$$0(25);
        }
        if (data2 == null) {
            MergeUtil.$$$reportNull$$$0(26);
        }
        for (ThreeSide side : ThreeSide.values()) {
            DiffContent content2 = side.select(contents);
            FilePath filePath2 = side.select(data2.CURRENT_FILE_PATH, data2.ORIGINAL_FILE_PATH, data2.LAST_FILE_PATH);
            VcsRevisionNumber revision = side.select(data2.CURRENT_REVISION_NUMBER, data2.ORIGINAL_REVISION_NUMBER, data2.LAST_REVISION_NUMBER);
            if (filePath2 == null || revision == null) continue;
            content2.putUserData(DiffUserDataKeysEx.REVISION_INFO, Pair.create(filePath2, revision));
        }
    }

    public static void reportProjectFileChangeIfNeeded(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (project2 != null && file2 != null && MergeUtil.isProjectFile(file2)) {
            StoreReloadManager.getInstance().saveChangedProjectFile(file2, project2);
        }
    }

    private static boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            MergeUtil.$$$reportNull$$$0(27);
        }
        if (file2.isDirectory()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile(file2)) {
            return true;
        }
        ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider(file2);
        return importProvider != null && importProvider.lookForProjectsInDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 13: 
            case 16: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContentTitles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveActionTitle";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullizeContentTitles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleResolveAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResolveActionTitle";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notNullizeContentTitles";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showExitWithoutApplyingChangesDialog";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showConfirmDiscardChangesDialog";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreOriginalContentOnCancel";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "putRevisionInfos";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "putRevisionInfo";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isProjectFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProxyDiffContext
    extends DiffContext {
        @NotNull
        private final MergeContext myMergeContext;

        public ProxyDiffContext(@NotNull MergeContext mergeContext) {
            if (mergeContext == null) {
                ProxyDiffContext.$$$reportNull$$$0(0);
            }
            this.myMergeContext = mergeContext;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myMergeContext.getProject();
        }

        @Override
        public boolean isWindowFocused() {
            return true;
        }

        @Override
        public boolean isFocusedInWindow() {
            return this.myMergeContext.isFocusedInWindow();
        }

        @Override
        public void requestFocusInWindow() {
            this.myMergeContext.requestFocusInWindow();
        }

        @Override
        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                ProxyDiffContext.$$$reportNull$$$0(1);
            }
            return this.myMergeContext.getUserData(key);
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                ProxyDiffContext.$$$reportNull$$$0(2);
            }
            this.myMergeContext.putUserData(key, value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergeContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeUtil$ProxyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

