/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffTool {
    private static final Logger LOG = Logger.getInstance(ExternalDiffTool.class);

    public static boolean isDefault() {
        return ExternalDiffSettings.getInstance().isDiffEnabled() && ExternalDiffSettings.getInstance().isDiffDefault();
    }

    public static boolean isEnabled() {
        return ExternalDiffSettings.getInstance().isDiffEnabled();
    }

    public static void show(@Nullable Project project2, @NotNull DiffRequestChain chain, @NotNull DiffDialogHints hints) {
        if (chain == null) {
            ExternalDiffTool.$$$reportNull$$$0(0);
        }
        if (hints == null) {
            ExternalDiffTool.$$$reportNull$$$0(1);
        }
        try {
            List<DiffRequest> requests = ExternalDiffTool.loadRequestsUnderProgress(project2, chain);
            if (requests == null) {
                return;
            }
            ArrayList<DiffRequest> showInBuiltin = new ArrayList<DiffRequest>();
            for (DiffRequest request2 : requests) {
                if (ExternalDiffTool.canShow(request2)) {
                    ExternalDiffTool.showRequest(project2, request2);
                    continue;
                }
                showInBuiltin.add(request2);
            }
            if (!showInBuiltin.isEmpty()) {
                DiffManagerEx.getInstance().showDiffBuiltin(project2, new SimpleDiffRequestChain(showInBuiltin), hints);
            }
        }
        catch (ProcessCanceledException requests) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog(project2, e.getMessage(), DiffBundle.message("can.t.show.diff.in.external.tool", new Object[0]));
        }
    }

    @Nullable
    private static List<DiffRequest> loadRequestsUnderProgress(@Nullable Project project2, @NotNull DiffRequestChain chain) throws Throwable {
        if (chain == null) {
            ExternalDiffTool.$$$reportNull$$$0(2);
        }
        if (chain instanceof AsyncDiffRequestChain) {
            return VcsUtil.computeWithModalProgress(project2, DiffBundle.message("progress.title.loading.requests", new Object[0]), true, indicator -> {
                ListSelection<? extends DiffRequestProducer> listSelection = ((AsyncDiffRequestChain)chain).loadRequestsInBackground();
                return ExternalDiffTool.collectRequests(project2, listSelection.getList(), listSelection.getSelectedIndex(), indicator);
            });
        }
        List<? extends DiffRequestProducer> allProducers = chain.getRequests();
        int index = chain.getIndex();
        return VcsUtil.computeWithModalProgress(project2, DiffBundle.message("progress.title.loading.requests", new Object[0]), true, indicator -> ExternalDiffTool.collectRequests(project2, allProducers, index, indicator));
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project2, @NotNull List<? extends DiffRequestProducer> allProducers, int index, @NotNull ProgressIndicator indicator) {
        if (allProducers == null) {
            ExternalDiffTool.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            ExternalDiffTool.$$$reportNull$$$0(4);
        }
        if (allProducers.isEmpty()) {
            List<DiffRequest> list2 = Collections.emptyList();
            if (list2 == null) {
                ExternalDiffTool.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List<DiffRequestProducer> producers = Collections.singletonList(allProducers.get(index));
        return ExternalDiffTool.collectRequests(project2, producers, indicator);
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project2, @NotNull List<? extends DiffRequestProducer> producers, @NotNull ProgressIndicator indicator) {
        if (producers == null) {
            ExternalDiffTool.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            ExternalDiffTool.$$$reportNull$$$0(7);
        }
        ArrayList<DiffRequest> requests = new ArrayList<DiffRequest>();
        UserDataHolderBase context = new UserDataHolderBase();
        ArrayList<String> errorRequests = new ArrayList<String>();
        for (DiffRequestProducer diffRequestProducer : producers) {
            try {
                requests.add(diffRequestProducer.process(context, indicator));
            }
            catch (DiffRequestProducerException e) {
                LOG.warn(e);
                errorRequests.add(diffRequestProducer.getName());
            }
        }
        if (!errorRequests.isEmpty()) {
            new Notification("Diff", DiffBundle.message("can.t.load.some.changes", new Object[0]), StringUtil.join(errorRequests, "<br>"), NotificationType.ERROR).notify(project2);
        }
        ArrayList<DiffRequest> arrayList = requests;
        if (arrayList == null) {
            ExternalDiffTool.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showRequest(@Nullable Project project2, @NotNull DiffRequest request2) throws ExecutionException, IOException {
        if (request2 == null) {
            ExternalDiffTool.$$$reportNull$$$0(9);
        }
        request2.onAssigned(true);
        try {
            ExternalDiffSettings settings = ExternalDiffSettings.getInstance();
            List<DiffContent> contents = ((ContentDiffRequest)request2).getContents();
            List<String> titles = ((ContentDiffRequest)request2).getContentTitles();
            ExternalDiffToolUtil.execute(project2, settings, contents, titles, request2.getTitle());
        }
        finally {
            request2.onAssigned(false);
        }
    }

    public static boolean canShow(@NotNull DiffRequest request2) {
        if (request2 == null) {
            ExternalDiffTool.$$$reportNull$$$0(10);
        }
        if (!(request2 instanceof ContentDiffRequest)) {
            return false;
        }
        List<DiffContent> contents = ((ContentDiffRequest)request2).getContents();
        if (contents.size() != 2 && contents.size() != 3) {
            return false;
        }
        for (DiffContent content2 : contents) {
            if (ExternalDiffToolUtil.canCreateFile(content2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProducers";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffTool";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffTool";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadRequestsUnderProgress";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectRequests";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showRequest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canShow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

