/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UnifiedDiffChangeUi {
    @NotNull
    protected final UnifiedDiffViewer myViewer;
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final UnifiedDiffChange myChange;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters;
    @NotNull
    protected final List<DiffGutterOperation> myOperations;

    public UnifiedDiffChangeUi(@NotNull UnifiedDiffViewer viewer, @NotNull UnifiedDiffChange change) {
        if (viewer == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(0);
        }
        if (change == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(1);
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<DiffGutterOperation>();
        this.myViewer = viewer;
        this.myEditor = viewer.getEditor();
        this.myChange = change;
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty() && this.myOperations.isEmpty());
        this.doInstallHighlighters();
        this.doInstallActionHighlighters();
    }

    protected void doInstallActionHighlighters() {
        if (this.myChange.isSkipped()) {
            return;
        }
        boolean leftEditable = this.myViewer.isEditable(Side.LEFT, false);
        boolean rightEditable = this.myViewer.isEditable(Side.RIGHT, false);
        if (leftEditable && rightEditable) {
            this.myOperations.add(this.createAcceptOperation(Side.LEFT));
            this.myOperations.add(this.createAcceptOperation(Side.RIGHT));
        } else if (rightEditable) {
            this.myOperations.add(this.createAcceptOperation(Side.LEFT));
        }
    }

    private void doInstallHighlighters() {
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters(this.myEditor, this.myChange.getDeletedRange(), this.myChange.getInsertedRange(), this.myChange.isExcluded(), this.myChange.isSkipped(), this.myChange.getLineFragment().getInnerFragments()));
    }

    public void updateGutterActions() {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.update(true);
        }
    }

    @NotNull
    protected DiffGutterOperation createOperation(@NotNull DiffGutterOperation.RendererBuilder builder2) {
        if (builder2 == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(2);
        }
        int offset = this.myEditor.getDocument().getLineStartOffset(this.myChange.getLine1());
        return new DiffGutterOperation.Simple(this.myEditor, offset, builder2);
    }

    @NotNull
    private DiffGutterOperation createAcceptOperation(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(3);
        }
        DiffGutterOperation diffGutterOperation = this.createOperation(() -> {
            if (this.myViewer.isStateIsOutOfDate()) {
                return null;
            }
            if (!this.myViewer.isEditable(sourceSide.other(), true)) {
                return null;
            }
            if (sourceSide.isLeft()) {
                return this.createIconRenderer(sourceSide, DiffBundle.message("action.presentation.diff.revert.text", new Object[0]), AllIcons.Diff.Remove);
            }
            return this.createIconRenderer(sourceSide, DiffBundle.message("action.presentation.diff.accept.text", new Object[0]), AllIcons.Actions.Checked);
        });
        if (diffGutterOperation == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(4);
        }
        return diffGutterOperation;
    }

    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull String tooltipText, @NotNull Icon icon2) {
        if (sourceSide == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(5);
        }
        if (tooltipText == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(6);
        }
        if (icon2 == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(7);
        }
        return new DiffGutterRenderer(icon2, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (UnifiedDiffChangeUi.this.myViewer.isStateIsOutOfDate()) {
                    return;
                }
                if (!UnifiedDiffChangeUi.this.myViewer.isEditable(sourceSide.other(), true)) {
                    return;
                }
                Project project2 = UnifiedDiffChangeUi.this.myViewer.getProject();
                Document document = UnifiedDiffChangeUi.this.myViewer.getDocument(sourceSide.other());
                DiffUtil.executeWriteCommand(document, project2, DiffBundle.message("message.replace.change.command", new Object[0]), () -> {
                    UnifiedDiffChangeUi.this.myViewer.replaceChange(UnifiedDiffChangeUi.this.myChange, sourceSide);
                    UnifiedDiffChangeUi.this.myViewer.scheduleRediff();
                });
                UnifiedDiffChangeUi.this.myViewer.rediff();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffChangeUi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffChangeUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAcceptOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAcceptOperation";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

