/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class UnifiedEditorHighlighter
implements EditorHighlighter {
    private static final Logger LOG = Logger.getInstance(UnifiedEditorHighlighter.class);
    @NotNull
    private final Document myDocument;
    @NotNull
    private final List<Element> myPieces;

    UnifiedEditorHighlighter(@NotNull Document document, @NotNull EditorHighlighter highlighter1, @NotNull EditorHighlighter highlighter2, @NotNull List<HighlightRange> ranges2, int textLength) {
        if (document == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(0);
        }
        if (highlighter1 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(1);
        }
        if (highlighter2 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(2);
        }
        if (ranges2 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(3);
        }
        this.myDocument = document;
        this.myPieces = new ArrayList<Element>();
        this.init(highlighter1.createIterator(0), highlighter2.createIterator(0), ranges2, textLength);
    }

    private void init(@NotNull HighlighterIterator it1, @NotNull HighlighterIterator it2, @NotNull List<HighlightRange> ranges2, int textLength) {
        if (it1 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(4);
        }
        if (it2 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(5);
        }
        if (ranges2 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int offset = 0;
        block0: for (HighlightRange range2 : ranges2) {
            TextRange base = range2.getBase();
            TextRange changed2 = range2.getChanged();
            if (base.isEmpty()) continue;
            if (base.getStartOffset() > offset) {
                this.addElement(new Element(offset, base.getStartOffset(), null, TextAttributes.ERASE_MARKER));
                offset = base.getStartOffset();
            }
            HighlighterIterator it = range2.getSide().select(it1, it2);
            while (!it.atEnd() && changed2.getStartOffset() >= it.getEnd()) {
                it.advance();
            }
            if (it.atEnd()) {
                LOG.error("Unexpected end of highlighter");
                break;
            }
            if (changed2.getEndOffset() <= it.getStart()) continue;
            do {
                int relativeStart = Math.max(it.getStart() - changed2.getStartOffset(), 0);
                int relativeEnd = Math.min(it.getEnd() - changed2.getStartOffset(), changed2.getLength() + 1);
                this.addElement(new Element(offset + relativeStart, offset + relativeEnd, it.getTokenType(), it.getTextAttributes()));
                if (changed2.getEndOffset() <= it.getEnd()) {
                    offset += changed2.getLength();
                    continue block0;
                }
                it.advance();
            } while (!it.atEnd());
            LOG.error("Unexpected end of highlighter");
        }
        if (offset < textLength) {
            this.addElement(new Element(offset, textLength, null, TextAttributes.ERASE_MARKER));
        }
    }

    private void addElement(@NotNull Element element2) {
        Element oldElement;
        if (element2 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(7);
        }
        boolean merged = false;
        if (!this.myPieces.isEmpty() && (oldElement = this.myPieces.get(this.myPieces.size() - 1)).getEnd() >= element2.getStart() && Comparing.equal(oldElement.getAttributes(), element2.getAttributes()) && Comparing.equal(oldElement.getElementType(), element2.getElementType())) {
            merged = true;
            this.myPieces.remove(this.myPieces.size() - 1);
            this.myPieces.add(new Element(oldElement.getStart(), element2.getEnd(), element2.getElementType(), element2.getAttributes()));
        }
        if (!merged) {
            this.myPieces.add(element2);
        }
    }

    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int index = Collections.binarySearch(this.myPieces, new Element(startOffset, 0, null, null), Comparator.comparingInt(Element::getStart));
        if (index < 0) {
            index = Math.max(-index - 2, 0);
        }
        return new ProxyIterator(this.myDocument, index, this.myPieces);
    }

    @Override
    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter2";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Element {
        private final int myStart;
        private final int myEnd;
        private final IElementType myElementType;
        private final TextAttributes myAttributes;

        private Element(int start2, int end, IElementType elementType, TextAttributes attributes) {
            this.myStart = start2;
            this.myEnd = end;
            this.myElementType = elementType;
            this.myAttributes = attributes;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        public TextAttributes getAttributes() {
            return this.myAttributes;
        }
    }

    private static class ProxyIterator
    implements HighlighterIterator {
        @NotNull
        private final Document myDocument;
        private int myIdx;
        private final List<Element> myPieces;

        private ProxyIterator(@NotNull Document document, int idx, @NotNull List<Element> pieces) {
            if (document == null) {
                ProxyIterator.$$$reportNull$$$0(0);
            }
            if (pieces == null) {
                ProxyIterator.$$$reportNull$$$0(1);
            }
            this.myDocument = document;
            this.myIdx = idx;
            this.myPieces = pieces;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return this.myPieces.get(this.myIdx).getAttributes();
        }

        @Override
        public int getStart() {
            return this.myPieces.get(this.myIdx).getStart();
        }

        @Override
        public int getEnd() {
            return this.myPieces.get(this.myIdx).getEnd();
        }

        @Override
        public IElementType getTokenType() {
            return this.myPieces.get(this.myIdx).myElementType;
        }

        @Override
        public void advance() {
            if (this.myIdx < this.myPieces.size()) {
                ++this.myIdx;
            }
        }

        @Override
        public void retreat() {
            if (this.myIdx > -1) {
                --this.myIdx;
            }
        }

        @Override
        public boolean atEnd() {
            return this.myIdx < 0 || this.myIdx >= this.myPieces.size();
        }

        @Override
        @NotNull
        public Document getDocument() {
            Document document = this.myDocument;
            if (document == null) {
                ProxyIterator.$$$reportNull$$$0(2);
            }
            return document;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pieces";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter$ProxyIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter$ProxyIterator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

