/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UnifiedFragmentBuilder {
    @NotNull
    protected final List<? extends LineFragment> myFragments;
    @NotNull
    private final Document myDocument1;
    @NotNull
    private final Document myDocument2;
    @NotNull
    private final Side myMasterSide;
    @NotNull
    private final StringBuilder myBuilder;
    @NotNull
    private final List<UnifiedDiffChange> myChanges;
    @NotNull
    private final List<HighlightRange> myRanges;
    @NotNull
    private final LineNumberConvertor.Builder myConvertor1;
    @NotNull
    private final LineNumberConvertor.Builder myConvertor2;
    @NotNull
    private final List<LineRange> myChangedLines;
    private int lastProcessedLine1;
    private int lastProcessedLine2;
    private int totalLines;

    public UnifiedFragmentBuilder(@NotNull List<? extends LineFragment> fragments, @NotNull Document document1, @NotNull Document document2, @NotNull Side masterSide) {
        if (fragments == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(0);
        }
        if (document1 == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(1);
        }
        if (document2 == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(2);
        }
        if (masterSide == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(3);
        }
        this.myBuilder = new StringBuilder();
        this.myChanges = new ArrayList<UnifiedDiffChange>();
        this.myRanges = new ArrayList<HighlightRange>();
        this.myConvertor1 = new LineNumberConvertor.Builder();
        this.myConvertor2 = new LineNumberConvertor.Builder();
        this.myChangedLines = new ArrayList<LineRange>();
        this.lastProcessedLine1 = -1;
        this.lastProcessedLine2 = -1;
        this.totalLines = 0;
        this.myFragments = fragments;
        this.myDocument1 = document1;
        this.myDocument2 = document2;
        this.myMasterSide = masterSide;
    }

    @NotNull
    public Side getMasterSide() {
        Side side = this.myMasterSide;
        if (side == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(4);
        }
        return side;
    }

    public UnifiedFragmentBuilder exec() {
        if (this.myFragments.isEmpty()) {
            this.appendTextMaster(0, 0, UnifiedFragmentBuilder.getLineCount(this.myDocument1) - 1, UnifiedFragmentBuilder.getLineCount(this.myDocument2) - 1);
            return this;
        }
        for (int i = 0; i < this.myFragments.size(); ++i) {
            LineFragment fragment = this.myFragments.get(i);
            this.processEquals(fragment.getStartLine1() - 1, fragment.getStartLine2() - 1);
            this.processChanged(fragment, i);
        }
        this.processEquals(UnifiedFragmentBuilder.getLineCount(this.myDocument1) - 1, UnifiedFragmentBuilder.getLineCount(this.myDocument2) - 1);
        return this;
    }

    private void processEquals(int endLine1, int endLine2) {
        int startLine1 = this.lastProcessedLine1 + 1;
        int startLine2 = this.lastProcessedLine2 + 1;
        this.appendTextMaster(startLine1, startLine2, endLine1, endLine2);
    }

    private void processChanged(@NotNull LineFragment fragment, int fragmentIndex) {
        if (fragment == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(5);
        }
        int startLine1 = fragment.getStartLine1();
        int endLine1 = fragment.getEndLine1() - 1;
        int lines1 = endLine1 - startLine1;
        int startLine2 = fragment.getStartLine2();
        int endLine2 = fragment.getEndLine2() - 1;
        int lines2 = endLine2 - startLine2;
        int linesBefore = this.totalLines;
        if (lines1 >= 0) {
            int startOffset1 = this.myDocument1.getLineStartOffset(startLine1);
            int endOffset1 = this.myDocument1.getLineEndOffset(endLine1);
            this.appendText(Side.LEFT, startOffset1, endOffset1, lines1, lines2, startLine1, -1);
        }
        int linesBetween = this.totalLines;
        if (lines2 >= 0) {
            int startOffset2 = this.myDocument2.getLineStartOffset(startLine2);
            int endOffset2 = this.myDocument2.getLineEndOffset(endLine2);
            this.appendText(Side.RIGHT, startOffset2, endOffset2, lines2, lines2, -1, startLine2);
        }
        int linesAfter = this.totalLines;
        UnifiedDiffChange change = this.createDiffChange(linesBefore, linesBetween, linesAfter, fragmentIndex);
        this.myChanges.add(change);
        if (!change.isSkipped()) {
            this.myChangedLines.add(new LineRange(linesBefore, linesAfter));
        }
        this.lastProcessedLine1 = endLine1;
        this.lastProcessedLine2 = endLine2;
    }

    @NotNull
    protected UnifiedDiffChange createDiffChange(int blockStart, int insertedStart, int blockEnd, int fragmentIndex) {
        return new UnifiedDiffChange(blockStart, insertedStart, blockEnd, this.myFragments.get(fragmentIndex));
    }

    private void appendTextMaster(int startLine1, int startLine2, int endLine1, int endLine2) {
        int lines1 = endLine1 - startLine1;
        int lines2 = endLine2 - startLine2;
        if (this.myMasterSide.select(lines1, lines2) >= 0) {
            int startOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineStartOffset(startLine1) : this.myDocument2.getLineStartOffset(startLine2);
            int endOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineEndOffset(endLine1) : this.myDocument2.getLineEndOffset(endLine2);
            this.appendText(this.myMasterSide, startOffset, endOffset, lines1, lines2, startLine1, startLine2);
        }
    }

    private void appendText(@NotNull Side side, int offset1, int offset2, int lines1, int lines2, int startLine1, int startLine2) {
        int appendix;
        int lines;
        if (side == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(6);
        }
        boolean notEmpty = (lines = side.select(lines1, lines2)) >= 0;
        int n = appendix = notEmpty ? 1 : 0;
        if (startLine1 != -1) {
            this.myConvertor1.put(this.totalLines, startLine1, lines + appendix, lines1 + appendix);
        }
        if (startLine2 != -1) {
            this.myConvertor2.put(this.totalLines, startLine2, lines + appendix, lines2 + appendix);
        }
        if (notEmpty) {
            Document document = side.select(this.myDocument1, this.myDocument2);
            int newline = document.getTextLength() > offset2 + 1 ? 1 : 0;
            TextRange base = new TextRange(this.myBuilder.length(), this.myBuilder.length() + offset2 - offset1 + newline);
            TextRange changed2 = new TextRange(offset1, offset2 + newline);
            this.myRanges.add(new HighlightRange(side, base, changed2));
            this.myBuilder.append(document.getCharsSequence().subSequence(offset1, offset2));
            this.myBuilder.append('\n');
            this.totalLines += lines + 1;
        }
    }

    private static int getLineCount(@NotNull Document document) {
        if (document == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(7);
        }
        return Math.max(document.getLineCount(), 1);
    }

    @NotNull
    public CharSequence getText() {
        StringBuilder stringBuilder = this.myBuilder;
        if (stringBuilder == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(8);
        }
        return stringBuilder;
    }

    @NotNull
    public List<UnifiedDiffChange> getChanges() {
        List<UnifiedDiffChange> list2 = this.myChanges;
        if (list2 == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public List<HighlightRange> getRanges() {
        List<HighlightRange> list2 = this.myRanges;
        if (list2 == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public LineNumberConvertor getConvertor1() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor1.build();
        if (lineNumberConvertor == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(11);
        }
        return lineNumberConvertor;
    }

    @NotNull
    public LineNumberConvertor getConvertor2() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor2.build();
        if (lineNumberConvertor == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(12);
        }
        return lineNumberConvertor;
    }

    @NotNull
    public List<LineRange> getChangedLines() {
        List<LineRange> list2 = this.myChangedLines;
        if (list2 == null) {
            UnifiedFragmentBuilder.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "masterSide";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedFragmentBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMasterSide";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConvertor1";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConvertor2";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLineCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

