/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffModel;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffViewer
extends TwosideTextDiffViewer {
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private final SimpleDiffModel myModel;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final ModifierProvider myModifierProvider;
    @NotNull
    protected final TwosideTextDiffProvider myTextDiffProvider;

    public SimpleDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        if (context == null) {
            SimpleDiffViewer.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request2);
        this.myModel = new SimpleDiffModel(this);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.mySyncScrollable = new MySyncScrollable();
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.getProject(), this.getEditors(), (Disposable)this);
        this.myModifierProvider = new ModifierProvider();
        this.myTextDiffProvider = DiffUtil.createTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, this);
        for (Side side : Side.values()) {
            DiffUtil.installLineConvertor(this.getEditor(side), this.getContent(side), this.myFoldingModel, side.getIndex());
        }
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter());
        this.myModifierProvider.init();
    }

    @Override
    protected void onDispose() {
        this.myModel.clear();
        this.myFoldingModel.destroy();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group.add(new MyToggleExpandByDefaultAction());
        group.add(new TwosideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add(new MyReadOnlyLockAction());
        group.add(this.myEditorSettingsAction);
        group.add(Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add(new TwosideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add(new MyToggleExpandByDefaultAction());
        group.add(Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(new ReplaceSelectedChangesAction(Side.LEFT));
        group.add(new AppendSelectedChangesAction(Side.LEFT));
        group.add(new ReplaceSelectedChangesAction(Side.RIGHT));
        group.add(new AppendSelectedChangesAction(Side.RIGHT));
        group.add(Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myInitialScrollHelper.processContext(this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFoldingModel.updateContext(this.myRequest, this.getFoldingModelSettings());
        this.myInitialScrollHelper.updateContext(this.myRequest);
    }

    @NotNull
    protected SimpleDiffChangeUi createUi(@NotNull SimpleDiffChange change) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(5);
        }
        return new SimpleDiffChangeUi(this, change);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            SimpleDiffViewer.$$$reportNull$$$0(6);
        }
        return settings;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        if (indicator == null) {
            SimpleDiffViewer.$$$reportNull$$$0(7);
        }
        try {
            runnable2 = this.computeDifferences(indicator);
        }
        catch (DiffTooBigException e) {
            Runnable runnable3 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable3 == null) {
                SimpleDiffViewer.$$$reportNull$$$0(9);
            }
            return runnable3;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = this.applyNotification(DiffNotifications.createError());
            if (runnable4 == null) {
                SimpleDiffViewer.$$$reportNull$$$0(10);
            }
            return runnable4;
        }
        if (runnable2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(8);
        }
        return runnable2;
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        boolean isContentsEqual;
        if (indicator == null) {
            SimpleDiffViewer.$$$reportNull$$$0(11);
        }
        indicator.checkCanceled();
        Document document1 = this.getContent1().getDocument();
        Document document2 = this.getContent2().getDocument();
        CharSequence[] texts = ReadAction.compute(() -> new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()});
        List<LineFragment> lineFragments = this.myTextDiffProvider.compare(texts[0], texts[1], indicator);
        boolean bl = isContentsEqual = (lineFragments == null || lineFragments.isEmpty()) && StringUtil.equals(texts[0], texts[1]);
        if (lineFragments == null) {
            Runnable runnable2 = this.apply(null, isContentsEqual);
            if (runnable2 == null) {
                SimpleDiffViewer.$$$reportNull$$$0(12);
            }
            return runnable2;
        }
        ArrayList<SimpleDiffChange> changes = new ArrayList<SimpleDiffChange>();
        for (LineFragment fragment : lineFragments) {
            changes.add(new SimpleDiffChange(changes.size(), fragment));
        }
        Runnable runnable3 = this.apply(changes, isContentsEqual);
        if (runnable3 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(13);
        }
        return runnable3;
    }

    @NotNull
    protected Runnable apply(@Nullable List<SimpleDiffChange> changes, boolean isContentsEqual) {
        List<SimpleDiffChange> nonSkipped = changes != null ? ContainerUtil.filter(changes, it -> !it.isSkipped()) : null;
        FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(nonSkipped, this.getFoldingModelSettings());
        Runnable runnable2 = () -> {
            this.myFoldingModel.updateContext(this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            if (isContentsEqual) {
                boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(this.getContents());
                boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(this.getContents());
                this.myPanel.addNotification(DiffNotifications.createEqualContents(equalCharsets, equalSeparators));
            }
            this.myModel.setChanges(ContainerUtil.notNullize(changes), isContentsEqual);
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDivider();
            this.myStatusPanel.update();
        };
        if (runnable2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(14);
        }
        return runnable2;
    }

    @NotNull
    protected Runnable applyNotification(@Nullable JComponent notification) {
        Runnable runnable2 = () -> {
            this.clearDiffPresentation();
            this.myFoldingModel.destroy();
            if (notification != null) {
                this.myPanel.addNotification(notification);
            }
        };
        if (runnable2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(15);
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myModel.clear();
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.myContentPanel.repaintDivider();
        this.myStatusPanel.update();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            SimpleDiffViewer.$$$reportNull$$$0(16);
        }
        super.onBeforeDocumentChange(e);
        List<Document> documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        Side side = Side.fromValue(documents, e.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        this.myModel.handleBeforeDocumentChange(side, e);
    }

    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        SimpleDiffChange targetChange;
        if (scrollToPolicy == null) {
            SimpleDiffViewer.$$$reportNull$$$0(17);
        }
        if ((targetChange = scrollToPolicy.select(this.getNonSkippedDiffChanges())) == null) {
            targetChange = scrollToPolicy.select(this.getDiffChanges());
        }
        if (targetChange == null) {
            return false;
        }
        this.doScrollToChange(targetChange, false);
        return true;
    }

    private void doScrollToChange(@NotNull SimpleDiffChange change, boolean animated) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(18);
        }
        int line1 = change.getStartLine(Side.LEFT);
        int line2 = change.getStartLine(Side.RIGHT);
        int endLine1 = change.getEndLine(Side.LEFT);
        int endLine2 = change.getEndLine(Side.RIGHT);
        DiffUtil.moveCaret(this.getEditor1(), line1);
        DiffUtil.moveCaret(this.getEditor2(), line2);
        this.getSyncScrollSupport().makeVisible(this.getCurrentSide(), line1, endLine1, line2, endLine2, animated);
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        ChangedLinesIterator changedLinesIterator;
        int line;
        if (context == null) {
            SimpleDiffViewer.$$$reportNull$$$0(19);
        }
        if ((line = context.contextMatchCheck(changedLinesIterator = new ChangedLinesIterator())) == -1) {
            AllLinesIterator allLinesIterator = new AllLinesIterator(this.getEditor(Side.RIGHT).getDocument());
            line = context.contextMatchCheck(allLinesIterator);
        }
        if (line == -1) {
            return false;
        }
        this.scrollToLine(Side.RIGHT, line);
        return true;
    }

    @NotNull
    protected List<SimpleDiffChange> getDiffChanges() {
        List<SimpleDiffChange> list2 = this.myModel.getChanges();
        if (list2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    private List<SimpleDiffChange> getNonSkippedDiffChanges() {
        List<SimpleDiffChange> list2 = ContainerUtil.filter(this.myModel.getChanges(), it -> !it.isSkipped());
        if (list2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable() {
        SyncScrollSupport.SyncScrollable syncScrollable = this.mySyncScrollable;
        if (syncScrollable == null) {
            SimpleDiffViewer.$$$reportNull$$$0(22);
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected StatusPanel getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            SimpleDiffViewer.$$$reportNull$$$0(23);
        }
        return statusPanel;
    }

    @NotNull
    public KeyboardModifierListener getModifierProvider() {
        ModifierProvider modifierProvider = this.myModifierProvider;
        if (modifierProvider == null) {
            SimpleDiffViewer.$$$reportNull$$$0(24);
        }
        return modifierProvider;
    }

    @Override
    @NotNull
    public SyncScrollSupport.TwosideSyncScrollSupport getSyncScrollSupport() {
        SyncScrollSupport.TwosideSyncScrollSupport twosideSyncScrollSupport = super.getSyncScrollSupport();
        if (twosideSyncScrollSupport == null) {
            SimpleDiffViewer.$$$reportNull$$$0(25);
        }
        return twosideSyncScrollSupport;
    }

    protected boolean isEditable(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(26);
        }
        return DiffUtil.isEditable(this.getEditor(side));
    }

    boolean isDiffForLocalChanges() {
        boolean isLastWithLocal = DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL.get(this.myContext, false);
        return isLastWithLocal && !this.isEditable(Side.LEFT) && this.isEditable(Side.RIGHT);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        if (context == null) {
            SimpleDiffViewer.$$$reportNull$$$0(27);
        }
        if (request2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(28);
        }
        return TwosideTextDiffViewer.canShowRequest(context, request2);
    }

    protected boolean isSomeChangeSelected(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(29);
        }
        if (this.getDiffChanges().isEmpty()) {
            return false;
        }
        EditorEx editor = this.getEditor(side);
        return DiffUtil.isSomeRangeSelected(editor, lines -> ContainerUtil.exists(this.getDiffChanges(), change -> SimpleDiffViewer.isChangeSelected(change, lines, side)));
    }

    @NotNull
    protected List<SimpleDiffChange> getSelectedChanges(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(30);
        }
        EditorEx editor = this.getEditor(side);
        BitSet lines = DiffUtil.getSelectedLines(editor);
        List<SimpleDiffChange> list2 = ContainerUtil.filter(this.getDiffChanges(), change -> SimpleDiffViewer.isChangeSelected(change, lines, side));
        if (list2 == null) {
            SimpleDiffViewer.$$$reportNull$$$0(31);
        }
        return list2;
    }

    private static boolean isChangeSelected(SimpleDiffChange change, @NotNull BitSet lines, @NotNull Side side) {
        if (lines == null) {
            SimpleDiffViewer.$$$reportNull$$$0(32);
        }
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(33);
        }
        int line1 = change.getStartLine(side);
        int line2 = change.getEndLine(side);
        return DiffUtil.isSelectedByLine(lines, line1, line2);
    }

    @Nullable
    protected SimpleDiffChange getSelectedChange(@NotNull Side side) {
        if (side == null) {
            SimpleDiffViewer.$$$reportNull$$$0(34);
        }
        int caretLine = this.getEditor((Side)side).getCaretModel().getLogicalPosition().line;
        for (SimpleDiffChange change : this.getDiffChanges()) {
            int line2;
            int line1 = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(caretLine, line1, line2 = change.getEndLine(side))) continue;
            return change;
        }
        return null;
    }

    public void replaceChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(35);
        }
        if (sourceSide == null) {
            SimpleDiffViewer.$$$reportNull$$$0(36);
        }
        if (!change.isValid()) {
            return;
        }
        Side outputSide = sourceSide.other();
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getStartLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        this.myModel.destroyChange(change);
    }

    public void appendChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            SimpleDiffViewer.$$$reportNull$$$0(37);
        }
        if (sourceSide == null) {
            SimpleDiffViewer.$$$reportNull$$$0(38);
        }
        if (!change.isValid()) {
            return;
        }
        if (change.getStartLine(sourceSide) == change.getEndLine(sourceSide)) {
            return;
        }
        Side outputSide = sourceSide.other();
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getEndLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        this.myModel.destroyChange(change);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        SimpleDiffChange change;
        if (dataId == null) {
            SimpleDiffViewer.$$$reportNull$$$0(39);
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getSelectedChange(this.getCurrentSide())) != null) {
            return new LineRange(change.getStartLine(this.getCurrentSide()), change.getEndLine(this.getCurrentSide()));
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer";
                break;
            }
            case 5: 
            case 18: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollToPolicy";
                break;
            }
            case 26: 
            case 29: 
            case 30: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDifferences";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "applyNotification";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffChanges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonSkippedDiffChanges";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollable";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierProvider";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollSupport";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUi";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeDifferences";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToChange";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToContext";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSomeChangeSelected";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChanges";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isChangeSelected";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChange";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyInitialScrollHelper
    extends TwosideTextDiffViewer.MyInitialScrollPositionHelper {
        private MyInitialScrollHelper() {
            super(SimpleDiffViewer.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return SimpleDiffViewer.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToContext(this.myNavigationContext);
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable;

        MyFoldingModel(@Nullable Project project2, @NotNull List<? extends EditorEx> editors, @NotNull Disposable disposable2) {
            if (editors == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable2 == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            super(project2, editors.toArray(new EditorEx[0]), disposable2);
            this.myPaintable = new FoldingModelSupport.MyPaintable(this, 0, 1);
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<SimpleDiffChange> changes, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                MyFoldingModel.$$$reportNull$$$0(3);
            }
            if (divider == null) {
                MyFoldingModel.$$$reportNull$$$0(4);
            }
            this.myPaintable.paintOnDivider(gg, divider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gg";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createState";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintOnDivider";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ModifierProvider
    extends KeyboardModifierListener {
        public void init() {
            this.init(SimpleDiffViewer.this.myPanel, SimpleDiffViewer.this);
        }

        @Override
        public void onModifiersChanged() {
            SimpleDiffViewer.this.myModel.updateGutterActions(false);
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (SimpleDiffViewer.this.myTextDiffProvider.isHighlightingDisabled()) {
                return DiffBundle.message("diff.highlighting.disabled.text", new Object[0]);
            }
            List<SimpleDiffChange> allChanges = SimpleDiffViewer.this.myModel.getAllChanges();
            return DiffUtil.getStatusText(allChanges.size(), ContainerUtil.count(allChanges, it -> it.isExcluded()), SimpleDiffViewer.this.myModel.isContentsEqual());
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private MyDividerPainter() {
        }

        @Override
        @DirtyUI
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                MyDividerPainter.$$$reportNull$$$0(0);
            }
            if (divider == null) {
                MyDividerPainter.$$$reportNull$$$0(1);
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, SimpleDiffViewer.this.getEditor1().getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor(SimpleDiffViewer.this.getEditor1()));
            gg.fill(gg.getClipBounds());
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), SimpleDiffViewer.this.getEditor1(), SimpleDiffViewer.this.getEditor2(), this);
            SimpleDiffViewer.this.myFoldingModel.paintOnDivider(gg, divider);
            gg.dispose();
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                MyDividerPainter.$$$reportNull$$$0(2);
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.getDiffChanges()) {
                if (handler2.processExcludable(diffChange.getStartLine(Side.LEFT), diffChange.getEndLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT), diffChange.getEndLine(Side.RIGHT), SimpleDiffViewer.this.getEditor1(), diffChange.getDiffType(), diffChange.isExcluded())) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        private MySyncScrollable() {
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return SimpleDiffViewer.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        @NotNull
        public Range getRange(@NotNull Side baseSide, int line) {
            if (baseSide == null) {
                MySyncScrollable.$$$reportNull$$$0(0);
            }
            if (SimpleDiffViewer.this.getDiffChanges().isEmpty()) {
                Range range2 = MySyncScrollable.idRange(line);
                if (range2 == null) {
                    MySyncScrollable.$$$reportNull$$$0(1);
                }
                return range2;
            }
            Range range3 = super.getRange(baseSide, line);
            if (range3 == null) {
                MySyncScrollable.$$$reportNull$$$0(2);
            }
            return range3;
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                MySyncScrollable.$$$reportNull$$$0(3);
            }
            if (!helper.process(0, 0)) {
                return;
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.getDiffChanges()) {
                if (!helper.process(diffChange.getStartLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT))) {
                    return;
                }
                if (helper.process(diffChange.getEndLine(Side.LEFT), diffChange.getEndLine(Side.RIGHT))) continue;
                return;
            }
            helper.process(DiffUtil.getLineCount(SimpleDiffViewer.this.getEditor1().getDocument()), DiffUtil.getLineCount(SimpleDiffViewer.this.getEditor2().getDocument()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseSide";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRange";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processHelper";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        private int myIndex = 0;

        private ChangedLinesIterator() {
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < SimpleDiffViewer.this.getDiffChanges().size();
        }

        @Override
        public void loadNextBlock() {
            SimpleDiffChange change = SimpleDiffViewer.this.getDiffChanges().get(this.myIndex);
            ++this.myIndex;
            int line1 = change.getStartLine(Side.RIGHT);
            int line2 = change.getEndLine(Side.RIGHT);
            DocumentEx document = SimpleDiffViewer.this.getEditor(Side.RIGHT).getDocument();
            for (int i = line1; i < line2; ++i) {
                int offset1 = document.getLineStartOffset(i);
                int offset2 = document.getLineEndOffset(i);
                CharSequence text2 = document.getImmutableCharSequence().subSequence(offset1, offset2);
                this.addLine(i, text2);
            }
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction() {
            super(SimpleDiffViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            SimpleDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        AppendSelectedChangesAction(Side focusedSide) {
            if (focusedSide == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other());
            this.setShortcutSet(ActionManager.getInstance().getAction(focusedSide.select("Diff.AppendLeftSide", "Diff.AppendRightSide")).getShortcutSet());
        }

        @Override
        @NotNull
        protected String getText(@NotNull Side side) {
            if (side == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(1);
            }
            String string = this.isBothEditable() ? DiffBundle.message("action.presentation.diff.append.to.the.side.text", this.myModifiedSide.getIndex()) : DiffBundle.message("action.presentation.diff.append.text", new Object[0]);
            if (string == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(3);
            }
            return DiffUtil.getArrowDownIcon(this.myModifiedSide.other());
        }

        @Override
        protected void apply(@NotNull List<SimpleDiffChange> changes) {
            if (changes == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(4);
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.appendChange(change, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        ReplaceSelectedChangesAction(Side focusedSide) {
            if (focusedSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other());
            this.setShortcutSet(ActionManager.getInstance().getAction(focusedSide.select("Diff.ApplyLeftSide", "Diff.ApplyRightSide")).getShortcutSet());
        }

        @Override
        @NotNull
        protected String getText(@NotNull Side side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(1);
            }
            if (this.myModifiedSide == Side.RIGHT && SimpleDiffViewer.this.isDiffForLocalChanges()) {
                String string = DiffBundle.message("action.presentation.diff.revert.text", new Object[0]);
                if (string == null) {
                    ReplaceSelectedChangesAction.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = DiffBundle.message("action.presentation.diff.accept.text", new Object[0]);
            if (string == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(4);
            }
            return DiffUtil.getArrowIcon(this.myModifiedSide.other());
        }

        @Override
        protected void apply(@NotNull List<SimpleDiffChange> changes) {
            if (changes == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(5);
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.replaceChange(change, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends SelectedChangesActionBase {
        @NotNull
        protected final Side myModifiedSide;

        ApplySelectedChangesActionBase(Side modifiedSide) {
            if (modifiedSide == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            this.myModifiedSide = modifiedSide;
        }

        @Override
        protected boolean isVisible(@NotNull Side side) {
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            if (!SimpleDiffViewer.this.isEditable(this.myModifiedSide)) {
                return false;
            }
            return !this.isBothEditable() || side == this.myModifiedSide.other();
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            if (side == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(3);
            }
            if (changes == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(4);
            }
            if (!SimpleDiffViewer.this.isEditable(this.myModifiedSide)) {
                return;
            }
            String title = DiffBundle.message("message.use.selected.changes.command", e.getPresentation().getText());
            DiffUtil.executeWriteCommand(SimpleDiffViewer.this.getEditor(this.myModifiedSide).getDocument(), e.getProject(), title, () -> this.apply(changes));
        }

        protected boolean isBothEditable() {
            return SimpleDiffViewer.this.isEditable(Side.LEFT) && SimpleDiffViewer.this.isEditable(Side.RIGHT);
        }

        protected abstract void apply(@NotNull List<SimpleDiffChange> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedSide";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isVisible";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doPerform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected abstract class SelectedChangesActionBase
    extends DumbAwareAction {
        protected SelectedChangesActionBase() {
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleDiffViewer.this.getEditors(), editor);
            if (side == null || !this.isVisible(side)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setText(this.getText(side));
            e.getPresentation().setIcon(this.getIcon(side));
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(SimpleDiffViewer.this.isSomeChangeSelected(side));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            Editor editor = e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue(SimpleDiffViewer.this.getEditors(), editor);
            if (side == null) {
                return;
            }
            List<SimpleDiffChange> selectedChanges = SimpleDiffViewer.this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, side, ContainerUtil.reverse(selectedChanges));
        }

        protected abstract boolean isVisible(@NotNull Side var1);

        @Nls
        @NotNull
        protected abstract String getText(@NotNull Side var1);

        @Nullable
        protected abstract Icon getIcon(@NotNull Side var1);

        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull Side var2, @NotNull List<SimpleDiffChange> var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$SelectedChangesActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        MyReadOnlyLockAction() {
            super(SimpleDiffViewer.this.getContext(), SimpleDiffViewer.this.getEditableEditors());
        }

        @Override
        protected void doApply(boolean readOnly) {
            super.doApply(readOnly);
            SimpleDiffViewer.this.myModel.updateGutterActions(true);
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<SimpleDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<SimpleDiffChange> getChanges() {
            List list2 = SimpleDiffViewer.this.getNonSkippedDiffChanges();
            if (list2 == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = SimpleDiffViewer.this.getCurrentEditor();
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull SimpleDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return change.getStartLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected int getEndLine(@NotNull SimpleDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return change.getEndLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected void scrollToChange(@NotNull SimpleDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(4);
            }
            SimpleDiffViewer.this.doScrollToChange(change, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "scrollToChange";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

