/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final SimpleThreesideDiffViewer myViewer;
    @Nullable
    private final MergeInnerDifferences myInnerFragments;
    private final int[] myLineStarts;
    private final int[] myLineEnds;
    private boolean myIsValid;

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @Nullable MergeInnerDifferences innerFragments, @NotNull SimpleThreesideDiffViewer viewer) {
        if (fragment == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(0);
        }
        if (conflictType == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(1);
        }
        if (viewer == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(2);
        }
        super(conflictType);
        this.myLineStarts = new int[3];
        this.myLineEnds = new int[3];
        this.myIsValid = true;
        this.myViewer = viewer;
        this.myInnerFragments = innerFragments;
        for (ThreeSide side : ThreeSide.values()) {
            this.myLineStarts[side.getIndex()] = fragment.getStartLine(side);
            this.myLineEnds[side.getIndex()] = fragment.getEndLine(side);
        }
        this.reinstallHighlighters();
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
        this.destroyOperations();
        this.installOperations();
    }

    @Override
    protected void installOperations() {
        this.myOperations.add(this.createAcceptOperation(ThreeSide.LEFT, ThreeSide.BASE));
        this.myOperations.add(this.createAcceptOperation(ThreeSide.RIGHT, ThreeSide.BASE));
        this.myOperations.add(this.createAcceptOperation(ThreeSide.BASE, ThreeSide.LEFT));
        this.myOperations.add(this.createAcceptOperation(ThreeSide.BASE, ThreeSide.RIGHT));
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(3);
        }
        return side.select(this.myLineStarts);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(4);
        }
        return side.select(this.myLineEnds);
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(5);
        }
        return false;
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(6);
        }
        EditorEx editorEx = this.myViewer.getEditor(side);
        if (editorEx == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.myInnerFragments;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public void markInvalid() {
        this.myIsValid = false;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(8);
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        this.myLineStarts[sideIndex] = newRange.startLine;
        this.myLineEnds[sideIndex] = newRange.endLine;
        return newRange.damaged;
    }

    @NotNull
    private DiffGutterOperation createAcceptOperation(@NotNull ThreeSide sourceSide, @NotNull ThreeSide modifiedSide) {
        if (sourceSide == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(9);
        }
        if (modifiedSide == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(10);
        }
        EditorEx editor = this.myViewer.getEditor(sourceSide);
        int offset = DiffGutterOperation.lineToOffset(editor, this.getStartLine(sourceSide));
        return new DiffGutterOperation.Simple(editor, offset, () -> {
            boolean isChanged;
            boolean isOtherEditable = this.myViewer.isEditable(modifiedSide);
            if (!isOtherEditable) {
                return null;
            }
            boolean bl = isChanged = sourceSide != ThreeSide.BASE && this.isChange(sourceSide) || modifiedSide != ThreeSide.BASE && this.isChange(modifiedSide);
            if (!isChanged) {
                return null;
            }
            String text2 = DiffBundle.message("action.presentation.diff.accept.text", new Object[0]);
            Side arrowDirection = Side.fromLeft(sourceSide == ThreeSide.LEFT || modifiedSide == ThreeSide.RIGHT);
            Icon icon2 = DiffUtil.getArrowIcon(arrowDirection);
            return this.createIconRenderer(sourceSide, modifiedSide, text2, icon2, () -> this.myViewer.replaceChange(this, sourceSide, modifiedSide));
        });
    }

    private GutterIconRenderer createIconRenderer(@NotNull ThreeSide sourceSide, final @NotNull ThreeSide modifiedSide, @NotNull String tooltipText, @NotNull Icon icon2, final @NotNull Runnable perform2) {
        if (sourceSide == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(11);
        }
        if (modifiedSide == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(12);
        }
        if (tooltipText == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(13);
        }
        if (icon2 == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(14);
        }
        if (perform2 == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(15);
        }
        return new DiffGutterRenderer(icon2, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (!SimpleThreesideDiffChange.this.isValid()) {
                    return;
                }
                Project project2 = SimpleThreesideDiffChange.this.myViewer.getProject();
                DocumentEx document = SimpleThreesideDiffChange.this.myViewer.getEditor(modifiedSide).getDocument();
                DiffUtil.executeWriteCommand(document, project2, DiffBundle.message("message.replace.change.command", new Object[0]), perform2);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleThreesideDiffChange";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedSide";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStartLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEndLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processChange";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAcceptOperation";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

