/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.FineMergeLineFragment;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleThreesideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffViewer
extends ThreesideTextDiffViewerEx {
    @NotNull
    private final SimpleThreesideTextDiffProvider myTextDiffProvider;
    @NotNull
    private final List<SimpleThreesideDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleThreesideDiffChange> myInvalidDiffChanges;

    public SimpleThreesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        if (context == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request2);
        this.myDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myTextDiffProvider = new SimpleThreesideTextDiffProvider(this.getTextSettings(), this::rediff, this);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        DefaultActionGroup diffGroup = DefaultActionGroup.createPopupGroup(() -> DiffBundle.message("group.compare.contents.text", new Object[0]));
        diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
        diffGroup.add(Separator.create(DiffBundle.message("group.compare.contents.text", new Object[0])));
        diffGroup.add(new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_LEFT, false));
        diffGroup.add(new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_RIGHT, false));
        diffGroup.add(new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT, false));
        group.add(diffGroup);
        group.add(Separator.getInstance());
        group.addAll(this.myTextDiffProvider.getToolbarActions());
        group.add(new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add(new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add(new MyEditorReadOnlyLockAction());
        group.add(this.myEditorSettingsAction);
        group.add(Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add(new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add(new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add(Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(new ReplaceSelectedChangesAction(ThreeSide.LEFT, ThreeSide.BASE));
        group.add(new ReplaceSelectedChangesAction(ThreeSide.RIGHT, ThreeSide.BASE));
        group.add(new ReplaceSelectedChangesAction(ThreeSide.BASE, ThreeSide.LEFT));
        group.add(new ReplaceSelectedChangesAction(ThreeSide.BASE, ThreeSide.RIGHT));
        group.add(Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(5);
        }
        try {
            indicator.checkCanceled();
            List<CharSequence> sequences = ContainerUtil.map(this.getContents(), content2 -> content2.getDocument().getImmutableCharSequence());
            List<FineMergeLineFragment> lineFragments = this.myTextDiffProvider.compare(sequences.get(0), sequences.get(1), sequences.get(2), indicator);
            FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(lineFragments, this.getFoldingModelSettings());
            return this.apply(lineFragments, foldingState);
        }
        catch (DiffTooBigException e) {
            Runnable runnable2 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable2 == null) {
                SimpleThreesideDiffViewer.$$$reportNull$$$0(6);
            }
            return runnable2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable3 = this.applyNotification(DiffNotifications.createError());
            if (runnable3 == null) {
                SimpleThreesideDiffViewer.$$$reportNull$$$0(7);
            }
            return runnable3;
        }
    }

    @NotNull
    private static MergeConflictType invertConflictType(@NotNull MergeConflictType oldConflictType) {
        TextDiffType oldDiffType;
        if (oldConflictType == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(8);
        }
        if ((oldDiffType = oldConflictType.getDiffType()) != TextDiffType.INSERTED && oldDiffType != TextDiffType.DELETED) {
            MergeConflictType mergeConflictType = oldConflictType;
            if (mergeConflictType == null) {
                SimpleThreesideDiffViewer.$$$reportNull$$$0(9);
            }
            return mergeConflictType;
        }
        return new MergeConflictType(oldDiffType == TextDiffType.DELETED ? TextDiffType.INSERTED : TextDiffType.DELETED, oldConflictType.isChange(Side.LEFT), oldConflictType.isChange(Side.RIGHT), oldConflictType.canBeResolved());
    }

    @NotNull
    private MergeConflictType convertConflictType(@NotNull FineMergeLineFragment fragment) {
        if (fragment == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(10);
        }
        MergeConflictType conflictType = fragment.getConflictType();
        if (DiffUtil.getUserData(this.myRequest, this.myContext, DiffUserDataKeys.THREESIDE_DIFF_WITH_RESULT) == Boolean.TRUE) {
            conflictType = SimpleThreesideDiffViewer.invertConflictType(conflictType);
        }
        MergeConflictType mergeConflictType = conflictType;
        if (mergeConflictType == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(11);
        }
        return mergeConflictType;
    }

    @NotNull
    private Runnable apply(@NotNull List<FineMergeLineFragment> fragments, @Nullable FoldingModelSupport.Data foldingState) {
        if (fragments == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(12);
        }
        Runnable runnable2 = () -> {
            this.myFoldingModel.updateContext(this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            this.resetChangeCounters();
            for (FineMergeLineFragment fragment : fragments) {
                MergeConflictType conflictType = this.convertConflictType(fragment);
                MergeInnerDifferences innerFragments = fragment.getInnerFragments();
                SimpleThreesideDiffChange change = new SimpleThreesideDiffChange(fragment, conflictType, innerFragments, this);
                this.myDiffChanges.add(change);
                this.onChangeAdded(change);
            }
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDividers();
            this.myStatusPanel.update();
        };
        if (runnable2 == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(13);
        }
        return runnable2;
    }

    @Override
    protected void destroyChangedBlocks() {
        super.destroyChangedBlocks();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            change.destroy();
        }
        this.myDiffChanges.clear();
        for (SimpleThreesideDiffChange change : this.myInvalidDiffChanges) {
            change.destroy();
        }
        this.myInvalidDiffChanges.clear();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(14);
        }
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        List<Document> documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        ThreeSide side = ThreeSide.fromValue(documents, e.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        ArrayList<SimpleThreesideDiffChange> invalid = new ArrayList<SimpleThreesideDiffChange>();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            if (!change.processChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
            for (SimpleThreesideDiffChange change : invalid) {
                change.markInvalid();
            }
        }
    }

    @NotNull
    public List<SimpleThreesideDiffChange> getChanges() {
        List<SimpleThreesideDiffChange> list2 = this.myDiffChanges;
        if (list2 == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @Override
    @NotNull
    protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
        if (side == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(16);
        }
        return new MyDividerPaintable(side);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        if (context == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(17);
        }
        if (request2 == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(18);
        }
        return ThreesideTextDiffViewer.canShowRequest(context, request2);
    }

    protected boolean isEditable(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(19);
        }
        return DiffUtil.isEditable(this.getEditor(side));
    }

    protected boolean isSomeChangeSelected(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(20);
        }
        if (this.getChanges().isEmpty()) {
            return false;
        }
        EditorEx editor = this.getEditor(side);
        return DiffUtil.isSomeRangeSelected(editor, lines -> ContainerUtil.exists(this.getChanges(), change -> SimpleThreesideDiffViewer.isChangeSelected(change, lines, side)));
    }

    @NotNull
    private List<SimpleThreesideDiffChange> getSelectedChanges(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(21);
        }
        EditorEx editor = this.getEditor(side);
        BitSet lines = DiffUtil.getSelectedLines(editor);
        List<SimpleThreesideDiffChange> list2 = ContainerUtil.filter(this.getChanges(), change -> SimpleThreesideDiffViewer.isChangeSelected(change, lines, side));
        if (list2 == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(22);
        }
        return list2;
    }

    public void replaceChange(@NotNull SimpleThreesideDiffChange change, @NotNull ThreeSide sourceSide, @NotNull ThreeSide outputSide) {
        if (change == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(23);
        }
        if (sourceSide == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(24);
        }
        if (outputSide == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(25);
        }
        if (!change.isValid()) {
            return;
        }
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getStartLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        this.myDiffChanges.remove(change);
        change.markInvalid();
        change.destroy();
    }

    static String getReplaceActionId(@NotNull ThreeSide master, @NotNull ThreeSide modifiedSide) {
        if (master == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(26);
        }
        if (modifiedSide == null) {
            SimpleThreesideDiffViewer.$$$reportNull$$$0(27);
        }
        if (master == ThreeSide.LEFT && modifiedSide == ThreeSide.BASE) {
            return "Diff.ApplyLeftSide";
        }
        if (master == ThreeSide.RIGHT && modifiedSide == ThreeSide.BASE) {
            return "Diff.ApplyRightSide";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConflictType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputSide";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "master";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedSide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "invertConflictType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "convertConflictType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invertConflictType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertConflictType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDividerPaintable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSomeChangeSelected";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChanges";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceActionId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDividerPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final Side mySide;

        MyDividerPaintable(Side side) {
            if (side == null) {
                MyDividerPaintable.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                MyDividerPaintable.$$$reportNull$$$0(1);
            }
            ThreeSide left = this.mySide.select(ThreeSide.LEFT, ThreeSide.BASE);
            ThreeSide right = this.mySide.select(ThreeSide.BASE, ThreeSide.RIGHT);
            for (SimpleThreesideDiffChange diffChange : SimpleThreesideDiffViewer.this.myDiffChanges) {
                if (!diffChange.isChange(this.mySide) || handler2.process(diffChange.getStartLine(left), diffChange.getEndLine(left), diffChange.getStartLine(right), diffChange.getEndLine(right), diffChange.getDiffType().getColor(SimpleThreesideDiffViewer.this.getEditor(ThreeSide.BASE)))) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected abstract class SelectedChangesActionBase
    extends DumbAwareAction {
        protected SelectedChangesActionBase() {
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = e.getData(CommonDataKeys.EDITOR);
            ThreeSide side = ThreeSide.fromValue(SimpleThreesideDiffViewer.this.getEditors(), editor);
            if (side == null || !this.isVisible(side)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setText(this.getText(side));
            e.getPresentation().setIcon(this.getIcon(side));
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(SimpleThreesideDiffViewer.this.isSomeChangeSelected(side));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            Editor editor = e.getData(CommonDataKeys.EDITOR);
            ThreeSide side = ThreeSide.fromValue(SimpleThreesideDiffViewer.this.getEditors(), editor);
            if (side == null) {
                return;
            }
            List selectedChanges = SimpleThreesideDiffViewer.this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, side, ContainerUtil.reverse(selectedChanges));
        }

        protected abstract boolean isVisible(@NotNull ThreeSide var1);

        @Nls
        @NotNull
        protected abstract String getText(@NotNull ThreeSide var1);

        @Nullable
        protected abstract Icon getIcon(@NotNull ThreeSide var1);

        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull ThreeSide var2, @NotNull List<SimpleThreesideDiffChange> var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$SelectedChangesActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ReplaceSelectedChangesAction
    extends SelectedChangesActionBase {
        @NotNull
        protected final ThreeSide mySourceSide;
        @NotNull
        protected final ThreeSide myModifiedSide;

        ReplaceSelectedChangesAction(@NotNull ThreeSide sourceSide, ThreeSide modifiedSide) {
            if (sourceSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(0);
            }
            if (modifiedSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(1);
            }
            this.mySourceSide = sourceSide;
            this.myModifiedSide = modifiedSide;
            String keymapActionId = SimpleThreesideDiffViewer.getReplaceActionId(sourceSide, modifiedSide);
            if (keymapActionId != null) {
                this.copyShortcutFrom(ActionManager.getInstance().getAction(keymapActionId));
            }
        }

        @Override
        protected boolean isVisible(@NotNull ThreeSide side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(2);
            }
            if (!SimpleThreesideDiffViewer.this.isEditable(this.myModifiedSide)) {
                return false;
            }
            return !this.isBothEditable() || side == this.mySourceSide;
        }

        protected boolean isBothEditable() {
            return SimpleThreesideDiffViewer.this.isEditable(this.mySourceSide) && SimpleThreesideDiffViewer.this.isEditable(this.myModifiedSide);
        }

        @Override
        @NotNull
        protected String getText(@NotNull ThreeSide side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(3);
            }
            String string = DiffBundle.message("action.presentation.diff.accept.text", new Object[0]);
            if (string == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull ThreeSide side) {
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(5);
            }
            Side arrowDirection = Side.fromLeft(this.mySourceSide == ThreeSide.LEFT || this.myModifiedSide == ThreeSide.RIGHT);
            return DiffUtil.getArrowIcon(arrowDirection);
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull ThreeSide side, @NotNull List<SimpleThreesideDiffChange> changes) {
            if (e == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(6);
            }
            if (side == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(7);
            }
            if (changes == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(8);
            }
            if (!SimpleThreesideDiffViewer.this.isEditable(this.myModifiedSide)) {
                return;
            }
            String title = DiffBundle.message("message.use.selected.changes.command", e.getPresentation().getText());
            DiffUtil.executeWriteCommand(SimpleThreesideDiffViewer.this.getEditor(this.myModifiedSide).getDocument(), e.getProject(), title, () -> {
                for (SimpleThreesideDiffChange change : changes) {
                    SimpleThreesideDiffViewer.this.replaceChange(change, this.mySourceSide, this.myModifiedSide);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedSide";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$ReplaceSelectedChangesAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isVisible";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "doPerform";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class MyEditorReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyEditorReadOnlyLockAction() {
            super(SimpleThreesideDiffViewer.this.getContext(), SimpleThreesideDiffViewer.this.getEditableEditors());
        }
    }
}

