/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffSplitter
extends Splitter {
    @Nullable
    private Painter myPainter;
    @Nullable
    private AnAction myTopAction;
    @Nullable
    private AnAction myBottomAction;

    public DiffSplitter() {
        this.setDividerWidth(JBUIScale.scale(Registry.intValue("diff.divider.width")));
    }

    @Override
    protected Divider createDivider() {
        return new Splitter.DividerImpl(){

            @Override
            public void setOrientation(boolean isVerticalSplit) {
                int width;
                this.removeAll();
                this.setCursor(Cursor.getPredefinedCursor(10));
                List<JComponent> actionComponents = Arrays.asList(DiffSplitter.createActionComponent(DiffSplitter.this.myTopAction), DiffSplitter.createActionComponent(DiffSplitter.this.myBottomAction));
                List<JComponent> syncComponents = DiffUtil.createSyncHeightComponents(actionComponents);
                GridBag bag = new GridBag();
                JComponent button1 = syncComponents.get(0);
                JComponent button2 = syncComponents.get(1);
                if (button1 != null) {
                    width = button1.getPreferredSize().width;
                    if (DiffSplitter.this.getDividerWidth() < width) {
                        DiffSplitter.this.setDividerWidth(width);
                    }
                }
                if (button2 != null) {
                    width = button2.getPreferredSize().width;
                    if (DiffSplitter.this.getDividerWidth() < width) {
                        DiffSplitter.this.setDividerWidth(width);
                    }
                }
                if (button1 != null) {
                    this.add((Component)button1, bag.nextLine());
                }
                if (button1 != null && button2 != null) {
                    this.add(Box.createVerticalStrut(JBUIScale.scale(20)), bag.nextLine());
                }
                if (button2 != null) {
                    this.add((Component)button2, bag.nextLine());
                }
                this.revalidate();
                this.repaint();
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (DiffSplitter.this.myPainter != null) {
                    DiffSplitter.this.myPainter.paint(g, this);
                }
            }
        };
    }

    public void setTopAction(@Nullable AnAction value2) {
        this.myTopAction = value2;
        this.setOrientation(false);
    }

    public void setBottomAction(@Nullable AnAction value2) {
        this.myBottomAction = value2;
        this.setOrientation(false);
    }

    public void setPainter(@Nullable Painter painter) {
        this.myPainter = painter;
    }

    public void repaintDivider() {
        this.getDivider().repaint();
    }

    @Nullable
    private static JComponent createActionComponent(@Nullable AnAction action2) {
        if (action2 == null) {
            return null;
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DiffSplitter", new DefaultActionGroup(action2), true);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setCursor(Cursor.getDefaultCursor());
        return toolbar.getComponent();
    }

    public static interface Painter {
        public void paint(@NotNull Graphics var1, @NotNull JComponent var2);
    }
}

