/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class FocusTrackerSupport<S> {
    @NotNull
    public abstract S getCurrentSide();

    public abstract void setCurrentSide(@NotNull S var1);

    public abstract void processContextHints(@NotNull DiffRequest var1, @NotNull DiffContext var2);

    public abstract void updateContextHints(@NotNull DiffRequest var1, @NotNull DiffContext var2);

    public static class Threeside
    extends FocusTrackerSupport<ThreeSide> {
        @NotNull
        private ThreeSide myCurrentSide;

        public Threeside(@NotNull List<? extends EditorHolder> holders) {
            if (holders == null) {
                Threeside.$$$reportNull$$$0(0);
            }
            this.myCurrentSide = ThreeSide.BASE;
            this.addListener(holders, ThreeSide.LEFT);
            this.addListener(holders, ThreeSide.BASE);
            this.addListener(holders, ThreeSide.RIGHT);
        }

        @Override
        @NotNull
        public ThreeSide getCurrentSide() {
            ThreeSide threeSide = this.myCurrentSide;
            if (threeSide == null) {
                Threeside.$$$reportNull$$$0(1);
            }
            return threeSide;
        }

        @Override
        public void setCurrentSide(@NotNull ThreeSide side) {
            if (side == null) {
                Threeside.$$$reportNull$$$0(2);
            }
            this.myCurrentSide = side;
        }

        @Override
        public void processContextHints(@NotNull DiffRequest request2, @NotNull DiffContext context) {
            ThreeSide side;
            if (request2 == null) {
                Threeside.$$$reportNull$$$0(3);
            }
            if (context == null) {
                Threeside.$$$reportNull$$$0(4);
            }
            if ((side = DiffUtil.getUserData(request2, context, DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE)) != null) {
                this.setCurrentSide(side);
            }
        }

        @Override
        public void updateContextHints(@NotNull DiffRequest request2, @NotNull DiffContext context) {
            if (request2 == null) {
                Threeside.$$$reportNull$$$0(5);
            }
            if (context == null) {
                Threeside.$$$reportNull$$$0(6);
            }
            context.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE, this.myCurrentSide);
        }

        private void addListener(@NotNull List<? extends EditorHolder> holders, @NotNull ThreeSide side) {
            if (holders == null) {
                Threeside.$$$reportNull$$$0(7);
            }
            if (side == null) {
                Threeside.$$$reportNull$$$0(8);
            }
            side.select(holders).installFocusListener(new MyFocusListener(side));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentSide";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setCurrentSide";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processContextHints";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateContextHints";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final ThreeSide mySide;

            private MyFocusListener(ThreeSide side) {
                if (side == null) {
                    MyFocusListener.$$$reportNull$$$0(0);
                }
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e) {
                Threeside.this.myCurrentSide = this.mySide;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$Threeside$MyFocusListener", "<init>"));
            }
        }
    }

    public static class Twoside
    extends FocusTrackerSupport<Side> {
        @NotNull
        private Side myCurrentSide;

        public Twoside(@NotNull List<? extends EditorHolder> holders) {
            if (holders == null) {
                Twoside.$$$reportNull$$$0(0);
            }
            assert (holders.size() == 2);
            this.myCurrentSide = Side.RIGHT;
            this.addListener(holders, Side.LEFT);
            this.addListener(holders, Side.RIGHT);
        }

        @Override
        @NotNull
        public Side getCurrentSide() {
            Side side = this.myCurrentSide;
            if (side == null) {
                Twoside.$$$reportNull$$$0(1);
            }
            return side;
        }

        @Override
        public void setCurrentSide(@NotNull Side side) {
            if (side == null) {
                Twoside.$$$reportNull$$$0(2);
            }
            this.myCurrentSide = side;
        }

        @Override
        public void processContextHints(@NotNull DiffRequest request2, @NotNull DiffContext context) {
            Side side;
            if (request2 == null) {
                Twoside.$$$reportNull$$$0(3);
            }
            if (context == null) {
                Twoside.$$$reportNull$$$0(4);
            }
            if ((side = DiffUtil.getUserData(request2, context, DiffUserDataKeys.PREFERRED_FOCUS_SIDE)) != null) {
                this.setCurrentSide(side);
            }
        }

        @Override
        public void updateContextHints(@NotNull DiffRequest request2, @NotNull DiffContext context) {
            if (request2 == null) {
                Twoside.$$$reportNull$$$0(5);
            }
            if (context == null) {
                Twoside.$$$reportNull$$$0(6);
            }
            context.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE, this.myCurrentSide);
        }

        private void addListener(@NotNull List<? extends EditorHolder> holders, @NotNull Side side) {
            if (holders == null) {
                Twoside.$$$reportNull$$$0(7);
            }
            if (side == null) {
                Twoside.$$$reportNull$$$0(8);
            }
            side.select(holders).installFocusListener(new MyFocusListener(side));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentSide";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setCurrentSide";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processContextHints";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateContextHints";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final Side mySide;

            private MyFocusListener(Side side) {
                if (side == null) {
                    MyFocusListener.$$$reportNull$$$0(0);
                }
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e) {
                Twoside.this.myCurrentSide = this.mySide;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$Twoside$MyFocusListener", "<init>"));
            }
        }
    }
}

