/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ComponentUtil;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyboardModifierListener
implements Disposable {
    private boolean myShiftPressed;
    private boolean myCtrlPressed;
    private boolean myAltPressed;
    @Nullable
    private Window myWindow;
    private final WindowFocusListener myWindowFocusListener = new WindowFocusListener(){

        @Override
        public void windowGainedFocus(WindowEvent e) {
            KeyboardModifierListener.this.resetState();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            KeyboardModifierListener.this.resetState();
        }
    };

    public void init(@NotNull JComponent component2, @NotNull Disposable disposable2) {
        if (component2 == null) {
            KeyboardModifierListener.$$$reportNull$$$0(0);
        }
        if (disposable2 == null) {
            KeyboardModifierListener.$$$reportNull$$$0(1);
        }
        assert (this.myWindow == null);
        Disposer.register(disposable2, this);
        IdeEventQueue.getInstance().addPostprocessor(e -> {
            if (e instanceof KeyEvent) {
                this.onKeyEvent((KeyEvent)e);
            }
            return false;
        }, disposable2);
        this.myWindow = ComponentUtil.getWindow(component2);
        if (this.myWindow != null) {
            this.myWindow.addWindowFocusListener(this.myWindowFocusListener);
        }
    }

    @Override
    public void dispose() {
        if (this.myWindow != null) {
            this.myWindow.removeWindowFocusListener(this.myWindowFocusListener);
            this.myWindow = null;
        }
    }

    private void onKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 16) {
            this.myShiftPressed = e.getID() == 401;
            this.onModifiersChanged();
        }
        if (keyCode == 17) {
            this.myCtrlPressed = e.getID() == 401;
            this.onModifiersChanged();
        }
        if (keyCode == 18) {
            this.myAltPressed = e.getID() == 401;
            this.onModifiersChanged();
        }
    }

    private void resetState() {
        this.myShiftPressed = false;
        this.myAltPressed = false;
        this.myCtrlPressed = false;
        this.onModifiersChanged();
    }

    public boolean isShiftPressed() {
        return this.myShiftPressed;
    }

    public boolean isCtrlPressed() {
        return this.myCtrlPressed;
    }

    public boolean isAltPressed() {
        return this.myAltPressed;
    }

    public void onModifiersChanged() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "disposable";
                break;
            }
        }
        objectArray[1] = "com/intellij/diff/tools/util/KeyboardModifierListener";
        objectArray[2] = "init";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

