/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftHardCacheMap<K, V> {
    @NotNull
    private final SLRUMap<K, V> mySLRUMap;
    @NotNull
    private final Map<K, V> mySoftLinkMap = ContainerUtil.createSoftValueMap();

    public SoftHardCacheMap(int protectedQueueSize, int probationalQueueSize) {
        this.mySLRUMap = new SLRUMap(protectedQueueSize, probationalQueueSize);
    }

    @Nullable
    public V get(@NotNull K key) {
        V val;
        if (key == null) {
            SoftHardCacheMap.$$$reportNull$$$0(0);
        }
        if ((val = this.mySLRUMap.get(key)) != null) {
            return val;
        }
        val = this.mySoftLinkMap.get(key);
        if (val != null) {
            this.mySLRUMap.put(key, val);
        }
        return val;
    }

    public void put(@NotNull K key, @NotNull V value2) {
        if (key == null) {
            SoftHardCacheMap.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            SoftHardCacheMap.$$$reportNull$$$0(2);
        }
        this.mySLRUMap.put(key, value2);
        this.mySoftLinkMap.put(key, value2);
    }

    public boolean remove(@NotNull K key) {
        if (key == null) {
            SoftHardCacheMap.$$$reportNull$$$0(3);
        }
        boolean remove1 = this.mySLRUMap.remove(key);
        boolean remove2 = this.mySoftLinkMap.remove(key) != null;
        return remove1 || remove2;
    }

    public void clear() {
        this.mySLRUMap.clear();
        this.mySoftLinkMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/SoftHardCacheMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

