/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.DiffContentPanel;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwosideContentPanel
extends JPanel {
    @NotNull
    private final DiffSplitter mySplitter;
    @NotNull
    private final List<DiffContentPanel> myPanels;

    public TwosideContentPanel(@NotNull List<? extends JComponent> contents) {
        if (contents == null) {
            TwosideContentPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        assert (contents.size() == 2);
        this.myPanels = ContainerUtil.map(contents, it -> new DiffContentPanel((JComponent)it));
        this.mySplitter = new DiffSplitter();
        this.mySplitter.setFirstComponent(Side.LEFT.select(this.myPanels));
        this.mySplitter.setSecondComponent(Side.RIGHT.select(this.myPanels));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.add((Component)this.mySplitter, "Center");
    }

    public void setTitles(@NotNull List<JComponent> titleComponents) {
        if (titleComponents == null) {
            TwosideContentPanel.$$$reportNull$$$0(1);
        }
        for (Side side : Side.values()) {
            DiffContentPanel panel2 = side.select(this.myPanels);
            JComponent title = side.select(titleComponents);
            panel2.setTitle(title);
        }
    }

    public void setBreadcrumbs(@NotNull Side side, @Nullable DiffBreadcrumbsPanel breadcrumbs, final @NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
        if (side == null) {
            TwosideContentPanel.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            TwosideContentPanel.$$$reportNull$$$0(3);
        }
        if (breadcrumbs != null) {
            final DiffContentPanel panel2 = side.select(this.myPanels);
            panel2.setBreadcrumbs(breadcrumbs);
            panel2.updateBreadcrumbsPlacement(settings.getBreadcrumbsPlacement());
            settings.addListener(new TextDiffSettingsHolder.TextDiffSettings.Listener.Adapter(){

                @Override
                public void breadcrumbsPlacementChanged() {
                    panel2.updateBreadcrumbsPlacement(settings.getBreadcrumbsPlacement());
                    TwosideContentPanel.this.repaintDivider();
                }
            }, breadcrumbs);
        }
    }

    public void setBottomAction(@Nullable AnAction value2) {
        this.mySplitter.setBottomAction(value2);
    }

    public void setTopAction(@Nullable AnAction value2) {
        this.mySplitter.setTopAction(value2);
    }

    public void setPainter(@Nullable DiffSplitter.Painter painter) {
        this.mySplitter.setPainter(painter);
    }

    public void repaintDivider() {
        this.mySplitter.repaintDivider();
    }

    @NotNull
    public DiffSplitter getSplitter() {
        DiffSplitter diffSplitter = this.mySplitter;
        if (diffSplitter == null) {
            TwosideContentPanel.$$$reportNull$$$0(4);
        }
        return diffSplitter;
    }

    @NotNull
    public static TwosideContentPanel createFromHolders(@NotNull List<? extends EditorHolder> holders) {
        if (holders == null) {
            TwosideContentPanel.$$$reportNull$$$0(5);
        }
        return new TwosideContentPanel(ContainerUtil.map(holders, holder -> holder.getComponent()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/TwosideContentPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/TwosideContentPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTitles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBreadcrumbs";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFromHolders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

