/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.InnerFragmentsPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProviderBase;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Range;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleTextDiffProvider
extends TwosideTextDiffProviderBase
implements TwosideTextDiffProvider {
    private static final Logger LOG = Logger.getInstance(SimpleTextDiffProvider.class);
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES_CHUNKS};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.BY_CHAR, HighlightPolicy.DO_NOT_HIGHLIGHT};
    private static final HighlightPolicy[] CUSTOM_COMPUTER_HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.DO_NOT_HIGHLIGHT};
    @Nullable
    private final DiffUserDataKeysEx.DiffComputer myDiffComputer;

    public SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable2) {
        if (settings == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(0);
        }
        if (rediff == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(1);
        }
        if (disposable2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(2);
        }
        this(settings, rediff, disposable2, null);
    }

    public SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable2, @Nullable DiffUserDataKeysEx.DiffComputer diffComputer) {
        if (settings == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(3);
        }
        if (rediff == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(4);
        }
        if (disposable2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(5);
        }
        this(settings, rediff, disposable2, diffComputer, IGNORE_POLICIES, diffComputer != null ? CUSTOM_COMPUTER_HIGHLIGHT_POLICIES : HIGHLIGHT_POLICIES);
    }

    private SimpleTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable2, @Nullable DiffUserDataKeysEx.DiffComputer diffComputer, IgnorePolicy @NotNull [] ignorePolicies, HighlightPolicy @NotNull [] highlightPolicies) {
        if (settings == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(6);
        }
        if (rediff == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(7);
        }
        if (disposable2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(8);
        }
        if (ignorePolicies == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(9);
        }
        if (highlightPolicies == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(10);
        }
        super(settings, rediff, disposable2, ignorePolicies, highlightPolicies);
        this.myDiffComputer = diffComputer;
    }

    @Override
    @NotNull
    protected List<List<LineFragment>> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<? extends Range> linesRanges, @NotNull IgnorePolicy ignorePolicy, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(12);
        }
        if (lineOffsets1 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(13);
        }
        if (lineOffsets2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(14);
        }
        if (ignorePolicy == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(15);
        }
        if (highlightPolicy == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(17);
        }
        return SimpleTextDiffProvider.compareRange(this.myDiffComputer, text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy, highlightPolicy, indicator);
    }

    @NotNull
    public static List<List<LineFragment>> compareRange(@Nullable DiffUserDataKeysEx.DiffComputer diffComputer, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<? extends Range> linesRanges, @NotNull IgnorePolicy ignorePolicy, @NotNull HighlightPolicy highlightPolicy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(18);
        }
        if (text2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(19);
        }
        if (lineOffsets1 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(20);
        }
        if (lineOffsets2 == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(21);
        }
        if (ignorePolicy == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(22);
        }
        if (highlightPolicy == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(23);
        }
        if (indicator == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(24);
        }
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        InnerFragmentsPolicy fragmentsPolicy = highlightPolicy.getFragmentsPolicy();
        if (diffComputer != null && linesRanges != null) {
            LOG.error(new Throwable("Unsupported operation: ranged diff with custom DiffComputer - " + diffComputer));
        }
        ComparisonManagerImpl comparisonManager = ComparisonManagerImpl.getInstanceImpl();
        if (linesRanges == null) {
            if (diffComputer != null) {
                List<LineFragment> fragments = diffComputer.compute(text1, text2, policy, fragmentsPolicy != InnerFragmentsPolicy.NONE, indicator);
                List<List<LineFragment>> list2 = Collections.singletonList(fragments);
                if (list2 == null) {
                    SimpleTextDiffProvider.$$$reportNull$$$0(25);
                }
                return list2;
            }
            List<LineFragment> fragments = comparisonManager.compareLinesInner(text1, text2, lineOffsets1, lineOffsets2, policy, fragmentsPolicy, indicator);
            List<List<LineFragment>> list3 = Collections.singletonList(fragments);
            if (list3 == null) {
                SimpleTextDiffProvider.$$$reportNull$$$0(26);
            }
            return list3;
        }
        ArrayList<List<LineFragment>> result2 = new ArrayList<List<LineFragment>>();
        for (Range range2 : linesRanges) {
            result2.add(comparisonManager.compareLinesInner(range2, text1, text2, lineOffsets1, lineOffsets2, policy, fragmentsPolicy, indicator));
        }
        ArrayList<List<LineFragment>> arrayList = result2;
        if (arrayList == null) {
            SimpleTextDiffProvider.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicies";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightPolicies";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets1";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets2";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicy";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightPolicy";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/text/SimpleTextDiffProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/text/SimpleTextDiffProvider";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "compareRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doCompare";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "compareRange";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NoIgnore
    extends SimpleTextDiffProvider
    implements TwosideTextDiffProvider.NoIgnore {
        public NoIgnore(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable2) {
            if (settings == null) {
                NoIgnore.$$$reportNull$$$0(0);
            }
            if (rediff == null) {
                NoIgnore.$$$reportNull$$$0(1);
            }
            if (disposable2 == null) {
                NoIgnore.$$$reportNull$$$0(2);
            }
            this(settings, rediff, disposable2, null);
        }

        public NoIgnore(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable2, @Nullable DiffUserDataKeysEx.DiffComputer diffComputer) {
            if (settings == null) {
                NoIgnore.$$$reportNull$$$0(3);
            }
            if (rediff == null) {
                NoIgnore.$$$reportNull$$$0(4);
            }
            if (disposable2 == null) {
                NoIgnore.$$$reportNull$$$0(5);
            }
            super(settings, rediff, disposable2, diffComputer, IGNORE_POLICIES, ArrayUtil.remove(HIGHLIGHT_POLICIES, HighlightPolicy.DO_NOT_HIGHLIGHT));
        }

        @Override
        @NotNull
        public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                NoIgnore.$$$reportNull$$$0(6);
            }
            if (text2 == null) {
                NoIgnore.$$$reportNull$$$0(7);
            }
            if (indicator == null) {
                NoIgnore.$$$reportNull$$$0(8);
            }
            List list2 = super.compare(text1, text2, indicator);
            if (list2 == null) {
                NoIgnore.$$$reportNull$$$0(9);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<List<LineFragment>> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<Range> linesRanges, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                NoIgnore.$$$reportNull$$$0(10);
            }
            if (text2 == null) {
                NoIgnore.$$$reportNull$$$0(11);
            }
            if (linesRanges == null) {
                NoIgnore.$$$reportNull$$$0(12);
            }
            if (indicator == null) {
                NoIgnore.$$$reportNull$$$0(13);
            }
            List list2 = super.compare(text1, text2, (List)linesRanges, indicator);
            if (list2 == null) {
                NoIgnore.$$$reportNull$$$0(14);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rediff";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linesRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/text/SimpleTextDiffProvider$NoIgnore";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 9: 
                case 14: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

