/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

public class Range {
    public final int start1;
    public final int end1;
    public final int start2;
    public final int end2;

    public Range(int start1, int end1, int start2, int end2) {
        assert (start1 <= end1 && start2 <= end2);
        this.start1 = start1;
        this.end1 = end1;
        this.start2 = start2;
        this.end2 = end2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range2 = (Range)o;
        if (this.start1 != range2.start1) {
            return false;
        }
        if (this.end1 != range2.end1) {
            return false;
        }
        if (this.start2 != range2.start2) {
            return false;
        }
        return this.end2 == range2.end2;
    }

    public int hashCode() {
        int result2 = this.start1;
        result2 = 31 * result2 + this.end1;
        result2 = 31 * result2 + this.start2;
        result2 = 31 * result2 + this.end2;
        return result2;
    }

    public String toString() {
        return "[" + this.start1 + ", " + this.end1 + ") - [" + this.start2 + ", " + this.end2 + ")";
    }

    public boolean isEmpty() {
        return this.start1 == this.end1 && this.start2 == this.end2;
    }
}

