/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CantRunException
extends ExecutionException {
    public CantRunException(String message) {
        super(message);
    }

    public CantRunException(String s, Throwable cause) {
        super(s, cause);
    }

    public static CantRunException noModuleConfigured(@Nullable String moduleName) {
        if (StringUtil.isEmptyOrSpaces(moduleName)) {
            return new CantRunException(ExecutionBundle.message("no.module.defined.error.message", new Object[0]));
        }
        return new CantRunException(ExecutionBundle.message("module.does.not.exist.error.message", moduleName));
    }

    public static CantRunException noJdkForModule(@NotNull Module module2) {
        if (module2 == null) {
            CantRunException.$$$reportNull$$$0(0);
        }
        return new CantRunException(ExecutionBundle.message("no.jdk.for.module.error.message", module2.getName()));
    }

    public static CantRunException jdkMisconfigured(@NotNull Sdk jdk, @NotNull Module module2) {
        if (jdk == null) {
            CantRunException.$$$reportNull$$$0(1);
        }
        if (module2 == null) {
            CantRunException.$$$reportNull$$$0(2);
        }
        return new CantRunException(ExecutionBundle.message("jdk.is.bad.configured.error.message", jdk.getName()));
    }

    public static CantRunException classNotFound(@NotNull String className, @NotNull Module module2) {
        if (className == null) {
            CantRunException.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            CantRunException.$$$reportNull$$$0(4);
        }
        return new CantRunException(ExecutionBundle.message("class.not.found.in.module.error.message", className, module2.getName()));
    }

    public static CantRunException packageNotFound(String packageName) {
        return new CantRunException(ExecutionBundle.message("package.not.found.error.message", packageName));
    }

    public static CantRunException noJdkConfigured(String jdkName) {
        if (jdkName != null) {
            return new CantRunException(ExecutionBundle.message("jdk.not.configured.error.message", jdkName));
        }
        return new CantRunException(ExecutionBundle.message("project.has.no.jdk.error.message", new Object[0]));
    }

    public static CantRunException badModuleDependencies() {
        return new CantRunException(ExecutionBundle.message("some.modules.has.circular.dependency.error.message", new Object[0]));
    }

    public static CantRunException noJdkConfigured() {
        return new CantRunException(ExecutionBundle.message("project.has.no.jdk.configured.error.message", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/CantRunException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "noJdkForModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "jdkMisconfigured";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "classNotFound";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

