/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InputRedirectAware
extends RunConfiguration {
    public static final List<String> TYPES_WITH_REDIRECT_AWARE_UI = ContainerUtil.immutableList("Application", "Java Scratch", "JUnit", "JarApplication");

    @NotNull
    public InputRedirectOptions getInputRedirectOptions();

    @Nullable
    public static InputRedirectOptions getInputRedirectOptions(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            InputRedirectAware.$$$reportNull$$$0(0);
        }
        return TYPES_WITH_REDIRECT_AWARE_UI.contains(runConfiguration.getType().getId()) ? ((InputRedirectAware)runConfiguration).getInputRedirectOptions() : null;
    }

    @Nullable
    public static File getInputFile(@NotNull RunConfiguration configuration) {
        InputRedirectOptions inputRedirectOptions;
        if (configuration == null) {
            InputRedirectAware.$$$reportNull$$$0(1);
        }
        if ((inputRedirectOptions = InputRedirectAware.getInputRedirectOptions(configuration)) == null || !inputRedirectOptions.isRedirectInput()) {
            return null;
        }
        String filePath2 = inputRedirectOptions.getRedirectInputPath();
        if (!StringUtil.isEmpty(filePath2)) {
            String directory;
            Module module2 = configuration instanceof CommonProgramRunConfigurationParameters ? ProgramParametersUtil.getModule((CommonProgramRunConfigurationParameters)((Object)configuration)) : null;
            filePath2 = FileUtil.toSystemDependentName(ProgramParametersUtil.expandPathAndMacros(filePath2, module2, configuration.getProject()));
            File file2 = new File(filePath2);
            if (configuration instanceof CommonProgramRunConfigurationParameters && !FileUtil.isAbsolute(filePath2) && (directory = ((CommonProgramRunConfigurationParameters)((Object)configuration)).getWorkingDirectory()) != null) {
                file2 = new File(new File(directory), filePath2);
            }
            return file2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/InputRedirectAware";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInputRedirectOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInputFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Deprecated
    public static final class InputRedirectOptionsImpl
    implements InputRedirectOptions {
        public static final String REDIRECT_INPUT = "REDIRECT_INPUT";
        public static final String INPUT_FILE = "INPUT_FILE";
        @Nullable
        public String myInputFile = null;
        public boolean myRedirectInput = false;

        public void readExternal(@NotNull Element element2) {
            if (element2 == null) {
                InputRedirectOptionsImpl.$$$reportNull$$$0(0);
            }
            this.myRedirectInput = Boolean.parseBoolean(JDOMExternalizerUtil.readField(element2, REDIRECT_INPUT, "false"));
            this.myInputFile = JDOMExternalizerUtil.readField(element2, INPUT_FILE);
        }

        public void writeExternal(Element element2) {
            if (this.myRedirectInput) {
                JDOMExternalizerUtil.writeField(element2, REDIRECT_INPUT, "true");
            }
            if (this.myInputFile != null) {
                JDOMExternalizerUtil.writeField(element2, INPUT_FILE, this.myInputFile);
            }
        }

        @NotNull
        public InputRedirectOptionsImpl copy() {
            InputRedirectOptionsImpl options = new InputRedirectOptionsImpl();
            options.myRedirectInput = this.myRedirectInput;
            options.myInputFile = this.myInputFile;
            InputRedirectOptionsImpl inputRedirectOptionsImpl = options;
            if (inputRedirectOptionsImpl == null) {
                InputRedirectOptionsImpl.$$$reportNull$$$0(1);
            }
            return inputRedirectOptionsImpl;
        }

        @Override
        public boolean isRedirectInput() {
            return this.myRedirectInput;
        }

        @Override
        public void setRedirectInput(boolean value2) {
            this.myRedirectInput = value2;
        }

        @Override
        @Nullable
        public String getRedirectInputPath() {
            return this.myInputFile;
        }

        @Override
        public void setRedirectInputPath(String value2) {
            this.myInputFile = value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/InputRedirectAware$InputRedirectOptionsImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/InputRedirectAware$InputRedirectOptionsImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "readExternal";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface InputRedirectOptions {
        public boolean isRedirectInput();

        public void setRedirectInput(boolean var1);

        @Nullable
        public String getRedirectInputPath();

        public void setRedirectInputPath(String var1);
    }
}

