/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaExecutionUtil {
    private static final Logger LOG = Logger.getInstance(JavaExecutionUtil.class);

    private JavaExecutionUtil() {
    }

    public static Module findModule(Module contextModule, Set<String> patterns, Project project2, Condition<? super PsiClass> isTestMethod) {
        Module nextModule;
        HashSet<Module> modules = new HashSet<Module>();
        for (String className : patterns) {
            PsiClass psiClass = JavaExecutionUtil.findMainClass(project2, className.contains(",") ? className.substring(0, className.indexOf(44)) : className, GlobalSearchScope.allScope(project2));
            if (psiClass == null || !isTestMethod.value(psiClass)) continue;
            modules.add(ModuleUtilCore.findModuleForPsiElement(psiClass));
        }
        if (modules.size() == 1 && (nextModule = (Module)modules.iterator().next()) != null) {
            return nextModule;
        }
        if (contextModule != null && modules.size() > 1) {
            HashSet moduleDependencies = new HashSet();
            ModuleUtilCore.getDependencies(contextModule, moduleDependencies);
            if (moduleDependencies.containsAll(modules)) {
                return contextModule;
            }
            return null;
        }
        return contextModule;
    }

    @Nullable
    public static String getRuntimeQualifiedName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaExecutionUtil.$$$reportNull$$$0(0);
        }
        return ClassUtil.getJVMClassName(aClass);
    }

    @Nullable
    public static String getPresentableClassName(@Nullable String rtClassName) {
        return JavaExecutionUtil.getPresentableClassName(rtClassName, null);
    }

    @Deprecated
    @Nullable
    public static String getPresentableClassName(@Nullable String rtClassName, JavaRunConfigurationModule configurationModule) {
        if (StringUtil.isEmpty(rtClassName)) {
            return null;
        }
        int lastDot = rtClassName.lastIndexOf(46);
        return lastDot == -1 || lastDot == rtClassName.length() - 1 ? rtClassName : rtClassName.substring(lastDot + 1);
    }

    public static Module findModule(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaExecutionUtil.$$$reportNull$$$0(1);
        }
        return ModuleUtilCore.findModuleForPsiElement(psiClass.getContainingFile());
    }

    @Nullable
    public static PsiClass findMainClass(Module module2, String mainClassName) {
        return JavaExecutionUtil.findMainClass(module2.getProject(), mainClassName, module2.getModuleRuntimeScope(true));
    }

    @Nullable
    public static PsiClass findMainClass(Project project2, String mainClassName, GlobalSearchScope scope) {
        if (project2.isDefault() || DumbService.isDumb(project2) && !DumbService.getInstance(project2).isAlternativeResolveEnabled()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance(project2);
        String shortName = StringUtil.getShortName(mainClassName);
        String packageName = StringUtil.getPackageName(mainClassName);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(psiManager.getProject());
        PsiClass psiClass = psiFacade.findClass(StringUtil.getQualifiedName(packageName, shortName.replace('$', '.')), scope);
        return psiClass == null ? psiFacade.findClass(mainClassName, scope) : psiClass;
    }

    public static boolean isNewName(String name) {
        return name == null || name.startsWith(ExecutionBundle.message("run.configuration.unnamed.name.prefix", new Object[0]));
    }

    public static Location stepIntoSingleClass(@NotNull Location location2) {
        PsiClassOwner psiFile;
        PsiClass[] classes;
        Object element2;
        if (location2 == null) {
            JavaExecutionUtil.$$$reportNull$$$0(2);
        }
        if (!((element2 = location2.getPsiElement()) instanceof PsiClassOwner)) {
            if (PsiTreeUtil.getParentOfType(element2, PsiClass.class) != null) {
                return location2;
            }
            if ((element2 = PsiTreeUtil.getParentOfType(element2, PsiClassOwner.class)) == null) {
                return location2;
            }
        }
        if ((classes = (psiFile = (PsiClassOwner)element2).getClasses()).length != 1) {
            return location2;
        }
        if (classes[0].getTextRange() == null) {
            return location2;
        }
        return PsiLocation.fromPsiElement(classes[0]);
    }

    public static String getShortClassName(@Nullable String fqName) {
        return fqName == null ? "" : StringUtil.getShortName(fqName);
    }

    @Deprecated
    public static void showExecutionErrorMessage(ExecutionException e, String title, Project project2) {
        ExecutionErrorDialog.show(e, title, project2);
    }

    @Nullable
    public static String handleSpacesInAgentPath(@NotNull String agentPath, @NotNull String copyDirName, @Nullable String agentPathPropertyKey) {
        if (agentPath == null) {
            JavaExecutionUtil.$$$reportNull$$$0(3);
        }
        if (copyDirName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(4);
        }
        return JavaExecutionUtil.handleSpacesInAgentPath(agentPath, copyDirName, agentPathPropertyKey, null);
    }

    @Nullable
    public static String handleSpacesInAgentPath(@NotNull String agentPath, @NotNull String copyDirName, @Nullable String agentPathPropertyKey, @Nullable FileFilter fileFilter) {
        String agentName;
        String containingDir;
        if (agentPath == null) {
            JavaExecutionUtil.$$$reportNull$$$0(5);
        }
        if (copyDirName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(6);
        }
        return (containingDir = JavaExecutionUtil.handleSpacesInContainingDir(agentPath, agentName = new File(agentPath).getName(), copyDirName, agentPathPropertyKey, fileFilter)) == null ? null : FileUtil.join(containingDir, agentName);
    }

    @Nullable
    private static String handleSpacesInContainingDir(@NotNull String agentPath, @NotNull String agentName, @NotNull String copyDirName, @Nullable String agentPathPropertyKey, @Nullable FileFilter fileFilter) {
        String userDefined;
        String agentContainingDir;
        if (agentPath == null) {
            JavaExecutionUtil.$$$reportNull$$$0(7);
        }
        if (agentName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(8);
        }
        if (copyDirName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(9);
        }
        if ((agentContainingDir = (userDefined = agentPathPropertyKey == null ? null : System.getProperty(agentPathPropertyKey)) != null && new File(userDefined).exists() ? userDefined : new File(agentPath).getParent()).contains(" ")) {
            String res2 = JavaExecutionUtil.tryCopy(agentContainingDir, agentName, new File(PathManager.getSystemPath(), copyDirName), fileFilter);
            if (res2 == null) {
                try {
                    res2 = JavaExecutionUtil.tryCopy(agentContainingDir, agentName, FileUtil.createTempDirectory(copyDirName, "jars"), fileFilter);
                    if (res2 == null) {
                        String message = "agent not used since the agent path contains spaces: " + agentContainingDir;
                        if (agentPathPropertyKey != null) {
                            message = message + "\nOne can move the agent libraries to a directory with no spaces in path and specify its path in idea.properties as " + agentPathPropertyKey + "=<path>";
                        }
                        LOG.info(message);
                    }
                }
                catch (IOException e) {
                    LOG.info(e);
                }
            }
            return res2;
        }
        return agentContainingDir;
    }

    @Nullable
    private static String tryCopy(@NotNull String agentDir, @NotNull String agentName, @NotNull File targetDir, @Nullable FileFilter fileFilter) {
        if (agentDir == null) {
            JavaExecutionUtil.$$$reportNull$$$0(10);
        }
        if (agentName == null) {
            JavaExecutionUtil.$$$reportNull$$$0(11);
        }
        if (targetDir == null) {
            JavaExecutionUtil.$$$reportNull$$$0(12);
        }
        if (targetDir.getAbsolutePath().contains(" ")) {
            return null;
        }
        try {
            if (fileFilter == null) {
                FileUtil.copy(new File(agentDir, agentName), new File(targetDir, agentName));
            } else {
                FileUtil.copyDir(new File(agentDir), targetDir, fileFilter);
            }
            LOG.info("Agent jars were copied to " + targetDir.getPath());
            return targetDir.getPath();
        }
        catch (IOException e) {
            LOG.info(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentPath";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyDirName";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/JavaExecutionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRuntimeQualifiedName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stepIntoSingleClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleSpacesInAgentPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleSpacesInContainingDir";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCopy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

