/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.PsiLocation;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Location<E extends PsiElement> {
    public static final DataKey<Location<?>> DATA_KEY = DataKey.create("Location");
    public static final DataKey<Location<?>[]> DATA_KEYS = DataKey.create("LocationArray");

    @NotNull
    public abstract E getPsiElement();

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract <T extends PsiElement> Iterator<Location<T>> getAncestors(Class<T> var1, boolean var2);

    @Nullable
    public VirtualFile getVirtualFile() {
        E psiElement = this.getPsiElement();
        if (psiElement.isValid()) {
            VirtualFile virtualFile2;
            if (psiElement instanceof PsiFileSystemItem) {
                return ((PsiFileSystemItem)psiElement).getVirtualFile();
            }
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile != null && (virtualFile2 = psiFile.getVirtualFile()) != null && virtualFile2.isValid()) {
                return virtualFile2;
            }
        }
        return null;
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        VirtualFile file2 = this.getVirtualFile();
        return file2 != null ? new OpenFileDescriptor(this.getProject(), file2, this.getPsiElement().getTextOffset()) : null;
    }

    @Nullable
    public <Ancestor extends PsiElement> Location<Ancestor> getParent(Class<Ancestor> parentClass) {
        Location<PsiElement> parent;
        Iterator<Location<PsiElement>> ancestors = this.getAncestors(PsiElement.class, true);
        if (ancestors.hasNext() && parentClass.isInstance((parent = ancestors.next()).getPsiElement())) {
            Location<PsiElement> location2 = parent;
            return location2;
        }
        return null;
    }

    @Nullable
    public <Ancestor extends PsiElement> Ancestor getParentElement(Class<Ancestor> parentClass) {
        return Location.safeGetPsiElement(this.getParent(parentClass));
    }

    @Nullable
    public static <T extends PsiElement> T safeGetPsiElement(Location<T> location2) {
        return location2 != null ? (T)location2.getPsiElement() : null;
    }

    @Nullable
    public static <T> T safeCast(Object obj, Class<T> expectedClass) {
        if (expectedClass.isInstance(obj)) {
            Object t = obj;
            return (T)t;
        }
        return null;
    }

    @NotNull
    public PsiLocation<E> toPsiLocation() {
        return new PsiLocation<E>(this.getProject(), this.getPsiElement());
    }

    @Nullable
    public abstract Module getModule();
}

