/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProgramRunnerUtil {
    private static final Logger LOG = Logger.getInstance(ProgramRunnerUtil.class);

    private ProgramRunnerUtil() {
    }

    @Deprecated
    @Nullable
    public static ProgramRunner<?> getRunner(@NotNull String executorId, @Nullable RunnerAndConfigurationSettings configuration) {
        if (executorId == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(0);
        }
        return configuration == null ? null : ProgramRunner.getRunner(executorId, configuration.getConfiguration());
    }

    public static void executeConfiguration(@NotNull ExecutionEnvironment environment2, boolean showSettings, boolean assignNewId) {
        if (environment2 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(1);
        }
        ProgramRunnerUtil.executeConfigurationAsync(environment2, showSettings, assignNewId, null);
    }

    @NotNull
    public static String getCannotRunOnErrorMessage(@NotNull RunProfile profile, @NotNull ExecutionTarget target2) {
        if (profile == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(2);
        }
        if (target2 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(3);
        }
        String string = StringUtil.escapeXmlEntities("Cannot run '" + profile.getName() + "' on '" + target2.getDisplayName() + "'");
        if (string == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void executeConfigurationAsync(@NotNull ExecutionEnvironment environment2, boolean showSettings, boolean assignNewId, @Nullable ProgramRunner.Callback callback2) {
        ExecutionManagerImpl manager;
        if (environment2 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(5);
        }
        if (!(manager = (ExecutionManagerImpl)ExecutionManager.getInstance(environment2.getProject())).isStarting(environment2)) {
            if (callback2 != null) {
                environment2.setCallback(callback2);
            }
            manager.executeConfiguration(environment2, showSettings, assignNewId);
        }
    }

    public static void handleExecutionError(Project project2, @NotNull ExecutionEnvironment environment2, Throwable e, RunProfile configuration) {
        if (environment2 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(6);
        }
        String name = configuration != null ? configuration.getName() : environment2.getRunProfile().getName();
        String windowId = RunContentManager.getInstance(project2).getToolWindowIdByEnvironment(environment2);
        if (configuration instanceof ConfigurationWithCommandLineShortener && ExecutionUtil.isProcessNotCreated(e)) {
            ProgramRunnerUtil.handleProcessNotStartedError((ConfigurationWithCommandLineShortener)((Object)configuration), (ExecutionException)((ProcessNotCreatedException)e), name, windowId);
        } else {
            ExecutionUtil.handleExecutionError(project2, windowId, name, e);
        }
    }

    private static void handleProcessNotStartedError(ConfigurationWithCommandLineShortener configuration, ExecutionException e, String name, String windowId) {
        String description = e.getMessage();
        HyperlinkListener listener2 = null;
        Project project2 = configuration.getProject();
        RunManager runManager = RunManager.getInstance(project2);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager.getAllSettings().stream().filter(settings -> settings.getConfiguration() == configuration).findFirst().orElse(null);
        if (runnerAndConfigurationSettings != null && (configuration.getShortenCommandLine() == null || configuration.getShortenCommandLine() == ShortenCommandLine.NONE)) {
            ConfigurationFactory factory = runnerAndConfigurationSettings.getFactory();
            RunnerAndConfigurationSettings configurationTemplate = runManager.getConfigurationTemplate(factory);
            description = "Command line is too long. Shorten command line for <a href=\"current\">" + name + "</a>";
            if (((ConfigurationWithCommandLineShortener)((Object)configurationTemplate.getConfiguration())).getShortenCommandLine() == null) {
                description = description + " or also for " + factory.getName() + " <a href=\"default\">default</a> configuration";
            }
            description = description + ".";
            listener2 = event -> {
                boolean isDefaultConfigurationChosen;
                SingleConfigurableEditor dialog2;
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (dialog2 = RunDialog.editShortenClasspathSetting((isDefaultConfigurationChosen = "default".equals(event.getDescription())) ? configurationTemplate : runnerAndConfigurationSettings, "Edit" + (isDefaultConfigurationChosen ? " Default" : "") + " Configuration")).showAndGet() && isDefaultConfigurationChosen) {
                    configuration.setShortenCommandLine(((ConfigurationWithCommandLineShortener)((Object)configurationTemplate.getConfiguration())).getShortenCommandLine());
                }
            };
        }
        ExecutionUtil.handleExecutionError(project2, windowId, name, e, description, listener2);
    }

    @Deprecated
    public static void executeConfiguration(@NotNull Project project2, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        if (project2 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(8);
        }
        if (executor == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(9);
        }
        ProgramRunnerUtil.executeConfiguration(configuration, executor);
    }

    public static void executeConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        ExecutionEnvironmentBuilder builder2;
        if (configuration == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(10);
        }
        if (executor == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(11);
        }
        try {
            builder2 = ExecutionEnvironmentBuilder.create(executor, configuration);
        }
        catch (ExecutionException e) {
            LOG.error(e);
            return;
        }
        ProgramRunnerUtil.executeConfiguration(builder2.contentToReuse(null).dataContext(null).activeTarget().build(), true, true);
    }

    @NotNull
    public static Icon getConfigurationIcon(@NotNull RunnerAndConfigurationSettings settings, boolean invalid) {
        Icon configurationIcon;
        if (settings == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(12);
        }
        Icon icon2 = ProgramRunnerUtil.getRawIcon(settings);
        Icon icon3 = configurationIcon = settings.isTemporary() ? ProgramRunnerUtil.getTemporaryIcon(icon2) : icon2;
        if (invalid) {
            Icon icon4 = LayeredIcon.create((Icon)configurationIcon, (Icon)AllIcons.RunConfigurations.InvalidConfigurationLayer);
            if (icon4 == null) {
                ProgramRunnerUtil.$$$reportNull$$$0(13);
            }
            return icon4;
        }
        Icon icon5 = configurationIcon;
        if (icon5 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(14);
        }
        return icon5;
    }

    @NotNull
    public static Icon getRawIcon(@NotNull RunnerAndConfigurationSettings settings) {
        Icon icon2;
        if (settings == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(15);
        }
        Icon icon3 = (icon2 = settings.getFactory().getIcon(settings.getConfiguration())) == null ? AllIcons.Actions.Help : icon2;
        if (icon3 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(16);
        }
        return icon3;
    }

    @NotNull
    public static Icon getTemporaryIcon(@NotNull Icon rawIcon) {
        if (rawIcon == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(17);
        }
        Icon icon2 = IconLoader.getTransparentIcon(rawIcon, 0.3f);
        if (icon2 == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(18);
        }
        return icon2;
    }

    @NotNull
    public static String shortenName(@Nullable String name, int toBeAdded) {
        if (name == null) {
            return "";
        }
        int symbols = Math.max(10, 20 - toBeAdded);
        String string = name.length() < symbols + 3 ? name : name.substring(0, symbols) + "...";
        if (string == null) {
            ProgramRunnerUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ProgramRunnerUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ProgramRunnerUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCannotRunOnErrorMessage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationIcon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIcon";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemporaryIcon";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCannotRunOnErrorMessage";
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeConfigurationAsync";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleExecutionError";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRawIcon";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTemporaryIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

