/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ShortenCommandLine {
    NONE("none", "java [options] className [args]"),
    MANIFEST("JAR manifest", "java -cp classpath.jar className [args]"),
    CLASSPATH_FILE("classpath file", "java WrapperClass classpathFile className [args]"){

        @Override
        public boolean isApplicable(String jreRoot) {
            return jreRoot == null || !JdkUtil.isModularRuntime(jreRoot);
        }
    }
    ,
    ARGS_FILE("@argfile (Java 9+)", "java @argfile className [args]"){

        @Override
        public boolean isApplicable(String jreRoot) {
            return jreRoot != null && JdkUtil.isModularRuntime(jreRoot);
        }
    };

    private final String myPresentableName;
    private final String myDescription;

    private ShortenCommandLine(String presentableName, String description) {
        this.myPresentableName = presentableName;
        this.myDescription = description;
    }

    public boolean isApplicable(String jreRoot) {
        return true;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NotNull
    public static ShortenCommandLine getDefaultMethod(@Nullable Project project2, String rootPath) {
        if (!JdkUtil.useDynamicClasspath(project2)) {
            ShortenCommandLine shortenCommandLine = NONE;
            if (shortenCommandLine == null) {
                ShortenCommandLine.$$$reportNull$$$0(0);
            }
            return shortenCommandLine;
        }
        if (rootPath != null && JdkUtil.isModularRuntime(rootPath)) {
            ShortenCommandLine shortenCommandLine = ARGS_FILE;
            if (shortenCommandLine == null) {
                ShortenCommandLine.$$$reportNull$$$0(1);
            }
            return shortenCommandLine;
        }
        if (JdkUtil.useClasspathJar()) {
            ShortenCommandLine shortenCommandLine = MANIFEST;
            if (shortenCommandLine == null) {
                ShortenCommandLine.$$$reportNull$$$0(2);
            }
            return shortenCommandLine;
        }
        ShortenCommandLine shortenCommandLine = CLASSPATH_FILE;
        if (shortenCommandLine == null) {
            ShortenCommandLine.$$$reportNull$$$0(3);
        }
        return shortenCommandLine;
    }

    @Deprecated
    public static ShortenCommandLine readShortenClasspathMethod(@NotNull Element element2) {
        Element mode;
        if (element2 == null) {
            ShortenCommandLine.$$$reportNull$$$0(4);
        }
        return (mode = element2.getChild("shortenClasspath")) != null ? ShortenCommandLine.valueOf(mode.getAttributeValue("name")) : null;
    }

    @Deprecated
    public static void writeShortenClasspathMethod(@NotNull Element element2, ShortenCommandLine shortenCommandLine) {
        if (element2 == null) {
            ShortenCommandLine.$$$reportNull$$$0(5);
        }
        if (shortenCommandLine != null) {
            element2.addContent(new Element("shortenClasspath").setAttribute("name", shortenCommandLine.name()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ShortenCommandLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMethod";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ShortenCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readShortenClasspathMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeShortenClasspathMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

