/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsComboBoxAction
extends ComboBoxAction
implements DumbAware {
    private static final String BUTTON_MODE = "ButtonMode";
    public static final Icon CHECKED_ICON = JBUI.scale(new SizedIcon(AllIcons.Actions.Checked, 16, 16));
    public static final Icon CHECKED_SELECTED_ICON = JBUI.scale(new SizedIcon(AllIcons.Actions.Checked_selected, 16, 16));
    public static final Icon EMPTY_ICON = EmptyIcon.ICON_16;
    private ComboBoxAction.ComboBoxButton myButton;

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        Project project2 = e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isMainMenuOrActionSearch(e.getPlace())) {
            presentation.setDescription(ExecutionBundle.messagePointer("choose.run.configuration.action.description", new Object[0]));
        }
        try {
            if (project2 == null || project2.isDisposed() || !project2.isOpen()) {
                RunConfigurationsComboBoxAction.updatePresentation(null, null, null, presentation, e.getPlace());
                presentation.setEnabled(false);
            } else {
                RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget(project2), RunManager.getInstance(project2).getSelectedConfiguration(), project2, presentation, e.getPlace());
                presentation.setEnabled(true);
            }
        }
        catch (IndexNotReadyException e1) {
            presentation.setEnabled(false);
        }
    }

    private static void updatePresentation(@Nullable ExecutionTarget target2, @Nullable RunnerAndConfigurationSettings settings, @Nullable Project project2, @NotNull Presentation presentation, String actionPlace) {
        if (presentation == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(1);
        }
        presentation.putClientProperty(BUTTON_MODE, null);
        if (project2 != null && target2 != null && settings != null) {
            String name = Executor.shortenNameIfNeeded(settings.getName());
            if (target2 != DefaultExecutionTarget.INSTANCE && !target2.isExternallyManaged()) {
                name = name + " | " + target2.getDisplayName();
            } else if (!ExecutionTargetManager.canRun(settings.getConfiguration(), target2)) {
                name = name + " | Nothing to run on";
            }
            presentation.setText(name, false);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, settings, project2);
            }
        } else {
            presentation.putClientProperty(BUTTON_MODE, Boolean.TRUE);
            presentation.setText(ExecutionBundle.messagePointer("action.presentation.RunConfigurationsComboBoxAction.text", new Object[0]));
            presentation.setDescription(ActionsBundle.actionDescription("editRunConfigurations"));
            if ("TouchBarGeneral".equals(actionPlace)) {
                presentation.setIcon(AllIcons.General.Add);
            } else {
                presentation.setIcon(null);
            }
        }
    }

    private static void setConfigurationIcon(Presentation presentation, RunnerAndConfigurationSettings settings, Project project2) {
        try {
            presentation.setIcon(RunManagerEx.getInstanceEx(project2).getConfigurationIcon(settings, true));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Presentation presentation;
        if (e == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(2);
        }
        if ("TouchBarGeneral".equals(e.getPlace()) && Boolean.TRUE.equals((presentation = e.getPresentation()).getClientProperty(BUTTON_MODE))) {
            RunConfigurationsComboBoxAction.performWhenButton(this.myButton, "TouchBarGeneral");
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    protected boolean shouldShowDisabledActions() {
        return true;
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(final @NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(3);
        }
        if (place == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(4);
        }
        this.myButton = new ComboBoxAction.ComboBoxButton(presentation){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = Math.max(d.width, JBUIScale.scale(75));
                return d;
            }

            @Override
            protected void doShiftClick() {
                DataContext context = DataManager.getInstance().getDataContext(this);
                Project project2 = CommonDataKeys.PROJECT.getData(context);
                if (project2 != null && !ActionUtil.isDumbMode(project2)) {
                    new EditConfigurationsDialog(project2).show();
                    return;
                }
                super.doShiftClick();
            }

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                if (Boolean.TRUE.equals(presentation.getClientProperty(RunConfigurationsComboBoxAction.BUTTON_MODE))) {
                    RunConfigurationsComboBoxAction.performWhenButton(this, "unknown");
                    return;
                }
                super.fireActionPerformed(event);
            }

            @Override
            protected boolean isArrowVisible(@NotNull Presentation presentation2) {
                if (presentation2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !Boolean.TRUE.equals(presentation2.getClientProperty(RunConfigurationsComboBoxAction.BUTTON_MODE));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$1", "isArrowVisible"));
            }
        };
        NonOpaquePanel panel2 = new NonOpaquePanel(new BorderLayout());
        JBEmptyBorder border = UIUtil.isUnderDefaultMacTheme() ? JBUI.Borders.empty(0, 2) : JBUI.Borders.empty(0, 5, 0, 4);
        panel2.setBorder(border);
        panel2.add(this.myButton);
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(5);
        }
        return nonOpaquePanel;
    }

    private static void performWhenButton(@NotNull Component src, String place) {
        if (src == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(6);
        }
        ActionManager manager = ActionManager.getInstance();
        manager.tryToExecute(manager.getAction("editRunConfigurations"), new MouseEvent(src, 501, System.currentTimeMillis(), 0, 0, 0, 0, false, 0), src, place, true);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
        DefaultActionGroup allActionsGroup = new DefaultActionGroup();
        Project project2 = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(button2));
        if (project2 == null) {
            DefaultActionGroup defaultActionGroup = allActionsGroup;
            if (defaultActionGroup == null) {
                RunConfigurationsComboBoxAction.$$$reportNull$$$0(7);
            }
            return defaultActionGroup;
        }
        allActionsGroup.add(ActionManager.getInstance().getAction("editRunConfigurations"));
        allActionsGroup.add(new SaveTemporaryAction());
        allActionsGroup.addSeparator();
        RunnerAndConfigurationSettings selected2 = RunManager.getInstance(project2).getSelectedConfiguration();
        if (selected2 != null) {
            ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget(project2);
            for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor(project2, selected2.getConfiguration())) {
                allActionsGroup.add(new SelectTargetAction(project2, eachTarget, eachTarget.equals(activeTarget)));
            }
            allActionsGroup.addSeparator();
        }
        for (Map<String, List<RunnerAndConfigurationSettings>> structure : RunManagerImpl.getInstanceImpl(project2).getConfigurationsGroupedByTypeAndFolder(true).values()) {
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : structure.entrySet()) {
                String folderName = entry.getKey();
                DefaultActionGroup group = folderName == null ? actionGroup : DefaultActionGroup.createPopupGroup(() -> folderName);
                group.getTemplatePresentation().setIcon(AllIcons.Nodes.Folder);
                for (RunnerAndConfigurationSettings settings : entry.getValue()) {
                    group.add(new SelectConfigAction(settings, project2));
                }
                if (group == actionGroup) continue;
                actionGroup.add(group);
            }
            allActionsGroup.add(actionGroup);
            allActionsGroup.addSeparator();
        }
        DefaultActionGroup defaultActionGroup = allActionsGroup;
        if (defaultActionGroup == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performWhenButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SelectConfigAction
    extends DumbAwareAction {
        private final RunnerAndConfigurationSettings myConfiguration;
        private final Project myProject;

        SelectConfigAction(RunnerAndConfigurationSettings configuration, Project project2) {
            this.myConfiguration = configuration;
            this.myProject = project2;
            String name = Executor.shortenNameIfNeeded(configuration.getName());
            if (name.isEmpty()) {
                name = " ";
            }
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            presentation.setDescription(ExecutionBundle.message("select.0.1", configuration.getType().getConfigurationTypeDescription(), name));
            this.updateIcon(presentation);
        }

        private void updateIcon(Presentation presentation) {
            RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, this.myConfiguration, this.myProject);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectConfigAction.$$$reportNull$$$0(0);
            }
            RunManager.getInstance(this.myProject).setSelectedConfiguration(this.myConfiguration);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget(this.myProject), this.myConfiguration, this.myProject, e.getPresentation(), e.getPlace());
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectConfigAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            this.updateIcon(e.getPresentation());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SelectConfigAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SelectTargetAction
    extends AnAction {
        private final Project myProject;
        private final ExecutionTarget myTarget;

        SelectTargetAction(Project project2, ExecutionTarget target2, boolean selected2) {
            this.myProject = project2;
            this.myTarget = target2;
            String name = target2.getDisplayName();
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            presentation.setDescription(ExecutionBundle.message("select.0", name));
            presentation.setIcon(selected2 ? CHECKED_ICON : EMPTY_ICON);
            presentation.setSelectedIcon(selected2 ? CHECKED_SELECTED_ICON : EMPTY_ICON);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectTargetAction.$$$reportNull$$$0(0);
            }
            ExecutionTargetManager.setActiveTarget(this.myProject, this.myTarget);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget(this.myProject), RunManager.getInstance(this.myProject).getSelectedConfiguration(), this.myProject, e.getPresentation(), e.getPlace());
        }

        @Override
        public boolean isDumbAware() {
            RunnerAndConfigurationSettings configuration = RunManager.getInstance(this.myProject).getSelectedConfiguration();
            return configuration == null || configuration.getType().isDumbAware();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SelectTargetAction", "actionPerformed"));
        }
    }

    private static class SaveTemporaryAction
    extends DumbAwareAction {
        SaveTemporaryAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.Menu_saveall);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            RunnerAndConfigurationSettings settings;
            Project project2;
            if (e == null) {
                SaveTemporaryAction.$$$reportNull$$$0(0);
            }
            if ((project2 = e.getData(CommonDataKeys.PROJECT)) != null && (settings = SaveTemporaryAction.chooseTempSettings(project2)) != null) {
                RunManager runManager = RunManager.getInstance(project2);
                runManager.makeStable(settings);
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SaveTemporaryAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            Project project2 = e.getData(CommonDataKeys.PROJECT);
            if (project2 == null) {
                SaveTemporaryAction.disable(presentation);
                return;
            }
            RunnerAndConfigurationSettings settings = SaveTemporaryAction.chooseTempSettings(project2);
            if (settings == null) {
                SaveTemporaryAction.disable(presentation);
            } else {
                presentation.setText(ExecutionBundle.messagePointer("save.temporary.run.configuration.action.name", Executor.shortenNameIfNeeded(settings.getName())));
                presentation.setDescription(presentation.getText());
                presentation.setEnabledAndVisible(true);
            }
        }

        private static void disable(Presentation presentation) {
            presentation.setEnabledAndVisible(false);
        }

        @Nullable
        private static RunnerAndConfigurationSettings chooseTempSettings(@NotNull Project project2) {
            RunnerAndConfigurationSettings selectedConfiguration2;
            if (project2 == null) {
                SaveTemporaryAction.$$$reportNull$$$0(2);
            }
            if ((selectedConfiguration2 = RunManager.getInstance(project2).getSelectedConfiguration()) != null && selectedConfiguration2.isTemporary()) {
                return selectedConfiguration2;
            }
            return ContainerUtil.getFirstItem(RunManager.getInstance(project2).getTempConfigurationsList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SaveTemporaryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseTempSettings";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

