/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public final class ShowRunningListAction
extends AnAction {
    private static final Object KEY = new Object();

    public ShowRunningListAction() {
        super(ExecutionBundle.messagePointer("show.running.list.action.name", new Object[0]), ExecutionBundle.messagePointer("show.running.list.action.description", new Object[0]), null);
    }

    @Override
    public void actionPerformed(final @NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowRunningListAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null || project2.isDisposed()) {
            return;
        }
        final Ref stateRef = new Ref();
        final Ref balloonRef = new Ref();
        final Timer timer2 = TimerUtil.createNamedTimer("runningLists", 250);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Balloon balloon = (Balloon)balloonRef.get();
                if (project2.isDisposed() || balloon != null && balloon.isDisposed()) {
                    timer2.stop();
                    return;
                }
                ArrayList<Project> projects = new ArrayList<Project>(Arrays.asList(ProjectManager.getInstance().getOpenProjects()));
                projects.remove(project2);
                projects.add(0, project2);
                Pair state = ShowRunningListAction.getCurrentState(projects);
                Pair prevState = (Pair)stateRef.get();
                if (prevState != null && ((String)prevState.getSecond()).equals(state.getSecond())) {
                    return;
                }
                stateRef.set(state);
                BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)state.getFirst());
                builder2.setShowCallout(false).setTitle(ExecutionBundle.message("show.running.list.balloon.title", new Object[0])).setBlockClicksThroughBalloon(true).setDialogMode(true).setHideOnKeyOutside(false);
                IdeFrame frame = e.getData(IdeFrame.KEY);
                if (frame == null) {
                    frame = WindowManagerEx.getInstanceEx().getFrameHelper(project2);
                }
                if (balloon != null) {
                    balloon.hide();
                }
                builder2.setClickHandler(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() instanceof MouseEvent) {
                            MouseEvent mouseEvent = (MouseEvent)e.getSource();
                            Component component2 = mouseEvent.getComponent();
                            Object value2 = ((JComponent)(component2 = SwingUtilities.getDeepestComponentAt(component2, mouseEvent.getX(), mouseEvent.getY()))).getClientProperty(KEY);
                            if (value2 instanceof Trinity) {
                                Project aProject = (Project)((Trinity)value2).first;
                                JFrame aFrame = WindowManager.getInstance().getFrame(aProject);
                                if (aFrame != null && !aFrame.isActive()) {
                                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(aFrame, true));
                                }
                                RunContentManager.getInstance(aProject).toFrontRunContent((Executor)((Trinity)value2).second, (RunContentDescriptor)((Trinity)value2).third);
                            }
                        }
                    }
                }, false);
                balloon = builder2.createBalloon();
                balloonRef.set(balloon);
                JComponent component2 = frame.getComponent();
                RelativePoint point = new RelativePoint(component2, new Point(component2.getWidth(), 0));
                balloon.show(point, Balloon.Position.below);
            }
        };
        timer2.addActionListener(actionListener);
        timer2.setInitialDelay(0);
        timer2.start();
    }

    private static Pair<? extends JComponent, String> getCurrentState(@NotNull List<? extends Project> projects) {
        if (projects == null) {
            ShowRunningListAction.$$$reportNull$$$0(1);
        }
        NonOpaquePanel panel2 = new NonOpaquePanel(new GridLayout(0, 1, 10, 10));
        StringBuilder state = new StringBuilder();
        for (int i = 0; i < projects.size(); ++i) {
            Project project2 = projects.get(i);
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project2);
            List<RunContentDescriptor> runningDescriptors2 = executionManager.getRunningDescriptors(Conditions.alwaysTrue());
            if (!runningDescriptors2.isEmpty() && projects.size() > 1) {
                state.append(project2.getName());
                panel2.add(new JLabel(ExecutionBundle.message("html.body.b.project.0.b.body.html", project2.getName())));
            }
            for (RunContentDescriptor descriptor2 : runningDescriptors2) {
                Set<Executor> executors = executionManager.getExecutors(descriptor2);
                for (Executor executor : executors) {
                    state.append(System.identityHashCode(descriptor2.getAttachedContent())).append("@").append(System.identityHashCode(executor.getIcon())).append(";");
                    ProcessHandler processHandler2 = descriptor2.getProcessHandler();
                    Icon icon2 = processHandler2 instanceof KillableProcess && processHandler2.isProcessTerminating() ? AllIcons.Debugger.KillProcess : executor.getIcon();
                    HyperlinkLabel label2 = new HyperlinkLabel(descriptor2.getDisplayName());
                    label2.setIcon(icon2);
                    label2.setIconTextGap(JBUIScale.scale(2));
                    label2.setCursor(Cursor.getPredefinedCursor(12));
                    label2.putClientProperty(KEY, Trinity.create(project2, executor, descriptor2));
                    panel2.add(label2);
                }
            }
        }
        if (panel2.getComponentCount() == 0) {
            panel2.setBorder(JBUI.Borders.empty(10));
            panel2.add(new JLabel(ExecutionBundle.message("show.running.list.balloon.nothing", new Object[0]), 0));
        } else {
            panel2.setBorder(JBUI.Borders.empty(10, 10, 0, 10));
            JLabel label3 = new JLabel(ExecutionBundle.message("show.running.list.balloon.hint", new Object[0]));
            label3.setFont(JBUI.Fonts.miniFont());
            panel2.add(label3);
        }
        return Pair.create(panel2, state.toString());
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Project[] projects;
        if (e == null) {
            ShowRunningListAction.$$$reportNull$$$0(2);
        }
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            boolean enabled = project2 != null && !project2.isDisposed() && !ExecutionManagerImpl.getInstance(project2).getRunningDescriptors(Conditions.alwaysTrue()).isEmpty();
            e.getPresentation().setEnabled(enabled);
            if (enabled) break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/actions/ShowRunningListAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

