/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.PathsList;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParameters
extends SimpleJavaParameters {
    private static final Logger LOG = Logger.getInstance(JavaParameters.class);
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    public static final String JAVA_ENABLE_PREVIEW_PROPERTY = "--enable-preview";
    public static final DataKey<JavaParameters> JAVA_PARAMETERS = DataKey.create("javaParameters");
    public static final int JDK_ONLY = 1;
    public static final int CLASSES_ONLY = 2;
    public static final int TESTS_ONLY = 4;
    public static final int INCLUDE_PROVIDED = 8;
    public static final int JDK_AND_CLASSES = 3;
    public static final int JDK_AND_CLASSES_AND_TESTS = 7;
    public static final int CLASSES_AND_TESTS = 6;
    public static final int JDK_AND_CLASSES_AND_PROVIDED = 11;

    public String getJdkPath() throws CantRunException {
        Sdk jdk = this.getJdk();
        if (jdk == null) {
            throw new CantRunException(ExecutionBundle.message("no.jdk.specified..error.message", new Object[0]));
        }
        VirtualFile jdkHome = jdk.getHomeDirectory();
        if (jdkHome == null) {
            throw new CantRunException(ExecutionBundle.message("home.directory.not.specified.for.jdk.error.message", new Object[0]));
        }
        return jdkHome.getPresentableUrl();
    }

    public void configureByModule(Module module2, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(module2.getProject());
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries(module2).recursively(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries(module2).recursively());
        this.configureJavaEnablePreviewProperty(OrderEnumerator.orderEntries(module2).recursively(), jdk);
    }

    private void configureJavaEnablePreviewProperty(OrderEnumerator orderEnumerator, Sdk jdk) {
        ParametersList vmParameters = this.getVMParametersList();
        if (vmParameters.hasParameter(JAVA_ENABLE_PREVIEW_PROPERTY) || !JavaSdkVersionUtil.isAtLeast(jdk, JavaSdkVersion.JDK_11)) {
            return;
        }
        orderEnumerator.forEachModule(module2 -> {
            LanguageLevel languageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel(module2);
            if (languageLevel.isPreview()) {
                vmParameters.add(JAVA_ENABLE_PREVIEW_PROPERTY);
                return false;
            }
            return true;
        });
    }

    private void configureJavaLibraryPath(OrderEnumerator enumerator) {
        PathsList pathsList = new PathsList();
        enumerator.runtimeOnly().withoutSdk().roots(NativeLibraryOrderRootType.getInstance()).collectPaths(pathsList);
        if (!pathsList.getPathList().isEmpty()) {
            ParametersList vmParameters = this.getVMParametersList();
            if (vmParameters.hasProperty(JAVA_LIBRARY_PATH_PROPERTY)) {
                LOG.info("java.library.path property is already specified, native library paths from dependencies (" + pathsList.getPathsString() + ") won't be added");
            } else {
                vmParameters.addProperty(JAVA_LIBRARY_PATH_PROPERTY, pathsList.getPathsString());
            }
        }
    }

    public void setDefaultCharset(Project project2) {
        Charset encoding = EncodingProjectManager.getInstance(project2).getDefaultCharset();
        this.setCharset(encoding);
    }

    public void configureByModule(Module module2, int classPathType) throws CantRunException {
        this.configureByModule(module2, classPathType, JavaParameters.getValidJdkToRunModule(module2, (classPathType & 4) == 0));
    }

    @Deprecated
    public static Sdk getModuleJdk(Module module2) throws CantRunException {
        return JavaParameters.getValidJdkToRunModule(module2, false);
    }

    @NotNull
    public static Sdk getValidJdkToRunModule(Module module2, boolean productionOnly) throws CantRunException {
        Sdk jdk = JavaParameters.getJdkToRunModule(module2, productionOnly);
        if (jdk == null) {
            throw CantRunException.noJdkForModule(module2);
        }
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null || !homeDirectory.isValid()) {
            throw CantRunException.jdkMisconfigured(jdk, module2);
        }
        Sdk sdk2 = jdk;
        if (sdk2 == null) {
            JavaParameters.$$$reportNull$$$0(0);
        }
        return sdk2;
    }

    @Nullable
    public static Sdk getJdkToRunModule(Module module2, boolean productionOnly) {
        Sdk moduleSdk = ModuleRootManager.getInstance(module2).getSdk();
        if (moduleSdk == null) {
            return null;
        }
        LinkedHashSet sdksFromDependencies = new LinkedHashSet();
        OrderEnumerator enumerator = OrderEnumerator.orderEntries(module2).runtimeOnly().recursively();
        if (productionOnly) {
            enumerator = enumerator.productionOnly();
        }
        enumerator.forEachModule(module1 -> {
            Sdk sdk2 = ModuleRootManager.getInstance(module1).getSdk();
            if (sdk2 != null && sdk2.getSdkType().equals(moduleSdk.getSdkType())) {
                sdksFromDependencies.add(sdk2);
            }
            return true;
        });
        return JavaParameters.findLatestVersion(moduleSdk, sdksFromDependencies);
    }

    @NotNull
    private static Sdk findLatestVersion(@NotNull Sdk mainSdk, @NotNull Set<? extends Sdk> sdks) {
        if (mainSdk == null) {
            JavaParameters.$$$reportNull$$$0(1);
        }
        if (sdks == null) {
            JavaParameters.$$$reportNull$$$0(2);
        }
        Sdk result2 = mainSdk;
        for (Sdk sdk2 : sdks) {
            if (VersionComparatorUtil.compare(result2.getVersionString(), sdk2.getVersionString()) >= 0) continue;
            result2 = sdk2;
        }
        Sdk sdk3 = result2;
        if (sdk3 == null) {
            JavaParameters.$$$reportNull$$$0(3);
        }
        return sdk3;
    }

    public void configureByProject(Project project2, int classPathType, Sdk jdk) throws CantRunException {
        if ((classPathType & 1) != 0) {
            if (jdk == null) {
                throw CantRunException.noJdkConfigured();
            }
            this.setJdk(jdk);
        }
        if ((classPathType & 2) == 0) {
            return;
        }
        this.setDefaultCharset(project2);
        JavaParameters.configureEnumerator(OrderEnumerator.orderEntries(project2).runtimeOnly(), classPathType, jdk).collectPaths(this.getClassPath());
        this.configureJavaLibraryPath(OrderEnumerator.orderEntries(project2));
        this.configureJavaEnablePreviewProperty(OrderEnumerator.orderEntries(project2), jdk);
    }

    private static OrderRootsEnumerator configureEnumerator(OrderEnumerator enumerator, int classPathType, Sdk jdk) {
        if ((classPathType & 8) == 0) {
            enumerator = enumerator.runtimeOnly();
        }
        if ((classPathType & 1) == 0) {
            enumerator = enumerator.withoutSdk();
        }
        if ((classPathType & 4) == 0) {
            enumerator = enumerator.productionOnly();
        }
        OrderRootsEnumerator rootsEnumerator = enumerator.classes();
        if ((classPathType & 1) != 0) {
            rootsEnumerator = rootsEnumerator.usingCustomRootProvider(e -> e instanceof JdkOrderEntry ? JavaParameters.jdkRoots(jdk) : e.getFiles(OrderRootType.CLASSES));
        }
        return rootsEnumerator;
    }

    private static VirtualFile[] jdkRoots(Sdk jdk) {
        return (VirtualFile[])Arrays.stream(jdk.getRootProvider().getFiles(OrderRootType.CLASSES)).filter(f -> !JrtFileSystem.isModuleRoot(f)).toArray(VirtualFile[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/JavaParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainSdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidJdkToRunModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/JavaParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findLatestVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findLatestVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

