/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RunConfiguration
extends RunProfile,
Cloneable {
    public static final DataKey<RunConfiguration> DATA_KEY = DataKey.create("runtimeConfiguration");

    @NotNull
    default public ConfigurationType getType() {
        ConfigurationFactory factory = this.getFactory();
        ConfigurationType configurationType = factory == null ? UnknownConfigurationType.getInstance() : factory.getType();
        if (configurationType == null) {
            RunConfiguration.$$$reportNull$$$0(0);
        }
        return configurationType;
    }

    @Nullable
    public ConfigurationFactory getFactory();

    public void setName(String var1);

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor();

    public Project getProject();

    @Nullable
    default public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
        return null;
    }

    @Nullable
    default public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
        return null;
    }

    public RunConfiguration clone();

    default public int getUniqueID() {
        return System.identityHashCode(this);
    }

    @Nullable
    default public String getId() {
        return null;
    }

    @Transient
    @NotNull
    default public String getPresentableType() {
        if (PlatformUtils.isPhpStorm()) {
            String string = " (" + StringUtil.first(this.getType().getDisplayName(), 10, true) + ")";
            if (string == null) {
                RunConfiguration.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    default public boolean hideDisabledExecutorButtons() {
        return false;
    }

    default public void checkConfiguration() throws RuntimeConfigurationException {
    }

    default public void readExternal(@NotNull Element element2) {
        if (element2 == null) {
            RunConfiguration.$$$reportNull$$$0(2);
        }
    }

    default public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            RunConfiguration.$$$reportNull$$$0(3);
        }
    }

    @NotNull
    default public List<BeforeRunTask<?>> getBeforeRunTasks() {
        List<BeforeRunTask<?>> list2 = Collections.emptyList();
        if (list2 == null) {
            RunConfiguration.$$$reportNull$$$0(4);
        }
        return list2;
    }

    default public void setBeforeRunTasks(@NotNull List<BeforeRunTask<?>> value2) {
        if (value2 == null) {
            RunConfiguration.$$$reportNull$$$0(5);
        }
    }

    default public boolean isAllowRunningInParallel() {
        return false;
    }

    default public void setAllowRunningInParallel(boolean value2) {
    }

    default public RestartSingletonResult restartSingleton(@NotNull ExecutionEnvironment environment2) {
        if (environment2 == null) {
            RunConfiguration.$$$reportNull$$$0(6);
        }
        return RestartSingletonResult.ASK_AND_RESTART;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/RunConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableType";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/RunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRunTasks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setBeforeRunTasks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restartSingleton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum RestartSingletonResult {
        ASK_AND_RESTART,
        RESTART,
        NO_FURTHER_ACTION;

    }
}

