/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationCreationListener;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationBase<T>
extends UserDataHolderBase
implements RunConfiguration,
TargetAwareRunProfile,
ConfigurationCreationListener {
    private static final String SHOW_CONSOLE_ON_STD_OUT = "show_console_on_std_out";
    private static final String SHOW_CONSOLE_ON_STD_ERR = "show_console_on_std_err";
    @Nullable
    private final ConfigurationFactory myFactory;
    private final Project myProject;
    private String myName;
    private RunConfigurationOptions myOptions;
    @NotNull
    private List<BeforeRunTask<?>> myBeforeRunTasks;

    protected RunConfigurationBase(@NotNull Project project2, @Nullable ConfigurationFactory factory, @Nullable String name) {
        if (project2 == null) {
            RunConfigurationBase.$$$reportNull$$$0(0);
        }
        this.myBeforeRunTasks = Collections.emptyList();
        this.myProject = project2;
        this.myFactory = factory;
        this.myName = name;
        this.myOptions = this.createOptions();
    }

    @NotNull
    private RunConfigurationOptions createOptions() {
        RunConfigurationOptions runConfigurationOptions = ReflectionUtil.newInstance(this.getOptionsClass());
        if (runConfigurationOptions == null) {
            RunConfigurationBase.$$$reportNull$$$0(1);
        }
        return runConfigurationOptions;
    }

    @NotNull
    protected RunConfigurationOptions getOptions() {
        RunConfigurationOptions runConfigurationOptions = this.myOptions;
        if (runConfigurationOptions == null) {
            RunConfigurationBase.$$$reportNull$$$0(2);
        }
        return runConfigurationOptions;
    }

    @Override
    @Transient
    @NotNull
    public List<BeforeRunTask<?>> getBeforeRunTasks() {
        List<BeforeRunTask<?>> list2 = this.myBeforeRunTasks;
        if (list2 == null) {
            RunConfigurationBase.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public void setBeforeRunTasks(@NotNull List<BeforeRunTask<?>> value2) {
        if (value2 == null) {
            RunConfigurationBase.$$$reportNull$$$0(4);
        }
        this.myBeforeRunTasks = value2;
    }

    @Override
    @Nullable
    public final ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public final void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            RunConfigurationBase.$$$reportNull$$$0(5);
        }
        return project2;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myFactory == null ? null : this.myFactory.getIcon();
    }

    @Override
    @Transient
    @NotNull
    public final String getName() {
        String string = StringUtilRt.notNullize(this.myName);
        if (string == null) {
            RunConfigurationBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void checkRunnerSettings(@NotNull ProgramRunner runner, @Nullable RunnerSettings runnerSettings2, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings2) throws RuntimeConfigurationException {
        if (runner == null) {
            RunConfigurationBase.$$$reportNull$$$0(7);
        }
    }

    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
    }

    @Override
    public boolean canRunOn(@NotNull ExecutionTarget target2) {
        if (target2 == null) {
            RunConfigurationBase.$$$reportNull$$$0(8);
        }
        return true;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public RunConfiguration clone() {
        RunConfigurationBase result2 = (RunConfigurationBase)super.clone();
        result2.myOptions = this.createOptions();
        result2.doCopyOptionsFrom(this);
        return result2;
    }

    void doCopyOptionsFrom(@NotNull RunConfigurationBase<T> template) {
        if (template == null) {
            RunConfigurationBase.$$$reportNull$$$0(9);
        }
        this.myOptions.copyFrom(template.myOptions);
        this.myOptions.resetModificationCount();
        this.myOptions.setAllowRunningInParallel(template.isAllowRunningInParallel());
        this.myBeforeRunTasks = ContainerUtil.copyList(template.myBeforeRunTasks);
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        return null;
    }

    public void removeAllPredefinedLogFiles() {
        this.getOptions().getPredefinedLogFiles().clear();
    }

    public void addPredefinedLogFile(@NotNull PredefinedLogFile predefinedLogFile) {
        if (predefinedLogFile == null) {
            RunConfigurationBase.$$$reportNull$$$0(10);
        }
        this.getOptions().getPredefinedLogFiles().add(predefinedLogFile);
    }

    @NotNull
    public List<PredefinedLogFile> getPredefinedLogFiles() {
        List<PredefinedLogFile> list2 = this.getOptions().getPredefinedLogFiles();
        if (list2 == null) {
            RunConfigurationBase.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    public ArrayList<LogFileOptions> getAllLogFiles() {
        ArrayList<LogFileOptions> list2 = new ArrayList<LogFileOptions>(this.getLogFiles());
        for (PredefinedLogFile predefinedLogFile : this.getOptions().getPredefinedLogFiles()) {
            LogFileOptions options = this.getOptionsForPredefinedLogFile(predefinedLogFile);
            if (options == null) continue;
            list2.add(options);
        }
        ArrayList<LogFileOptions> arrayList = list2;
        if (arrayList == null) {
            RunConfigurationBase.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public List<LogFileOptions> getLogFiles() {
        List<LogFileOptions> list2 = this.getOptions().getLogFiles();
        if (list2 == null) {
            RunConfigurationBase.$$$reportNull$$$0(13);
        }
        return list2;
    }

    public void addLogFile(String file2, String alias, boolean checked) {
        this.getOptions().getLogFiles().add(new LogFileOptions(alias, file2, checked));
    }

    public void addLogFile(String file2, String alias, boolean checked, boolean skipContent, boolean showAll) {
        this.getOptions().getLogFiles().add(new LogFileOptions(alias, file2, checked, skipContent, showAll));
    }

    public void removeAllLogFiles() {
        this.getOptions().getLogFiles().clear();
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
    }

    public void customizeLogConsole(LogConsole console) {
    }

    @Nullable
    public T getState() {
        return (T)this.getOptions();
    }

    public void loadState(@NotNull T state) {
        if (state == null) {
            RunConfigurationBase.$$$reportNull$$$0(14);
        }
        this.myOptions = state instanceof Element ? XmlSerializer.deserialize((Element)state, this.getOptionsClass()) : (RunConfigurationOptions)state;
    }

    @Override
    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        if (element2 == null) {
            RunConfigurationBase.$$$reportNull$$$0(15);
        }
        boolean isAllowRunningInParallel = this.myOptions.isAllowRunningInParallel();
        this.loadState(element2);
        this.myOptions.setAllowRunningInParallel(isAllowRunningInParallel);
    }

    @Override
    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            RunConfigurationBase.$$$reportNull$$$0(16);
        }
        XmlSerializer.serializeObjectInto(this.myOptions, element2);
    }

    @ApiStatus.Experimental
    public void setOptionsFromConfigurationFile(@NotNull BaseState state) {
        if (state == null) {
            RunConfigurationBase.$$$reportNull$$$0(17);
        }
        this.myOptions.copyFrom(state, false);
    }

    protected Class<? extends RunConfigurationOptions> getOptionsClass() {
        Class<? extends BaseState> result2;
        Class<? extends BaseState> clazz = result2 = this.myFactory == null ? null : this.myFactory.getOptionsClass();
        if (result2 != null) {
            return result2;
        }
        if (this instanceof PersistentStateComponent) {
            PersistentStateComponent instance2 = (PersistentStateComponent)((Object)this);
            return ComponentSerializationUtil.getStateClass(instance2.getClass());
        }
        return this.getDefaultOptionsClass();
    }

    @NotNull
    protected Class<? extends RunConfigurationOptions> getDefaultOptionsClass() {
        return RunConfigurationOptions.class;
    }

    @Transient
    public boolean isSaveOutputToFile() {
        return this.myOptions.getFileOutput().isSaveOutput();
    }

    public void setSaveOutputToFile(boolean redirectOutput) {
        this.myOptions.getFileOutput().setSaveOutput(redirectOutput);
    }

    @Attribute(value="show_console_on_std_out")
    public boolean isShowConsoleOnStdOut() {
        return this.myOptions.isShowConsoleOnStdOut();
    }

    public void setShowConsoleOnStdOut(boolean showConsoleOnStdOut) {
        this.myOptions.setShowConsoleOnStdOut(showConsoleOnStdOut);
    }

    @Attribute(value="show_console_on_std_err")
    public boolean isShowConsoleOnStdErr() {
        return this.myOptions.isShowConsoleOnStdErr();
    }

    public void setShowConsoleOnStdErr(boolean showConsoleOnStdErr) {
        this.myOptions.setShowConsoleOnStdErr(showConsoleOnStdErr);
    }

    @Transient
    public String getOutputFilePath() {
        return this.myOptions.getFileOutput().getFileOutputPath();
    }

    public void setFileOutputPath(String fileOutputPath) {
        this.myOptions.getFileOutput().setFileOutputPath(fileOutputPath);
    }

    public boolean collectOutputFromProcessHandler() {
        return true;
    }

    @Deprecated
    public boolean excludeCompileBeforeLaunchOption() {
        return false;
    }

    public String toString() {
        return this.getType().getDisplayName() + ": " + this.getName();
    }

    @Deprecated
    protected boolean isNewSerializationUsed() {
        return false;
    }

    @Override
    public final boolean isAllowRunningInParallel() {
        return this.getOptions().isAllowRunningInParallel();
    }

    @Override
    public final void setAllowRunningInParallel(boolean value2) {
        this.getOptions().setAllowRunningInParallel(value2);
    }

    @Override
    public void onNewConfigurationCreated() {
    }

    @Override
    public void onConfigurationCopied() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/RunConfigurationBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedLogFile";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/RunConfigurationBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRunTasks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLogFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLogFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBeforeRunTasks";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnerSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCopyOptionsFrom";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedLogFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setOptionsFromConfigurationFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

