/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="module")
public class RunConfigurationModule
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(RunConfigurationModule.class);
    @NonNls
    private static final String ELEMENT = "module";
    @NonNls
    private static final String ATTRIBUTE = "name";
    @Nullable
    private ModulePointer myModulePointer;
    private final Project myProject;

    public RunConfigurationModule(@NotNull Project project2) {
        if (project2 == null) {
            RunConfigurationModule.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @Override
    public void readExternal(@NotNull Element element2) {
        List<Element> modules;
        if (element2 == null) {
            RunConfigurationModule.$$$reportNull$$$0(1);
        }
        if (!(modules = element2.getChildren(ELEMENT)).isEmpty()) {
            String moduleName;
            if (modules.size() > 1) {
                LOG.warn("Module serialized more than one time");
            }
            if (!StringUtil.isEmpty(moduleName = modules.get(0).getAttributeValue(ATTRIBUTE))) {
                this.myModulePointer = ModulePointerManager.getInstance(this.myProject).create(moduleName);
            }
        }
    }

    @Override
    public void writeExternal(@NotNull Element parent) {
        Element prev;
        if (parent == null) {
            RunConfigurationModule.$$$reportNull$$$0(2);
        }
        if ((prev = parent.getChild(ELEMENT)) == null) {
            prev = new Element(ELEMENT);
            parent.addContent(prev);
        }
        prev.setAttribute(ATTRIBUTE, this.getModuleName());
    }

    @Deprecated
    public void init() {
        this.setModuleToAnyFirstIfNotSpecified();
    }

    public void setModuleToAnyFirstIfNotSpecified() {
        Module[] modules;
        if (StringUtil.isEmptyOrSpaces(this.getModuleName()) && (modules = this.getModuleManager().getModules()).length > 0) {
            this.setModule(modules[0]);
        }
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            RunConfigurationModule.$$$reportNull$$$0(3);
        }
        return project2;
    }

    @Transient
    @Nullable
    public Module getModule() {
        return this.myModulePointer != null ? this.myModulePointer.getModule() : null;
    }

    @Nullable
    public Module findModule(@NotNull String moduleName) {
        if (moduleName == null) {
            RunConfigurationModule.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return this.getModuleManager().findModuleByName(moduleName);
    }

    public void setModule(Module module2) {
        this.myModulePointer = module2 != null ? ModulePointerManager.getInstance(this.myProject).create(module2) : null;
    }

    public void setModuleName(@Nullable String moduleName) {
        if (this.myModulePointer != null && !this.myModulePointer.getModuleName().equals(moduleName) || this.myModulePointer == null && moduleName != null) {
            this.myModulePointer = moduleName != null ? ModulePointerManager.getInstance(this.myProject).create(moduleName) : null;
        }
    }

    @Attribute(value="name")
    @NotNull
    public String getModuleName() {
        return this.myModulePointer != null ? this.myModulePointer.getModuleName() : "";
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance(this.myProject);
    }

    public void checkForWarning() throws RuntimeConfigurationException {
        Module module2 = this.getModule();
        if (module2 != null) {
            if (ModuleRootManager.getInstance(module2).getSdk() == null) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message("no.jdk.specified.for.module.warning.text", module2.getName()));
            }
        } else {
            if (this.myModulePointer != null) {
                String moduleName = this.myModulePointer.getModuleName();
                if (ModuleManager.getInstance(this.myProject).getUnloadedModuleDescription(moduleName) != null) {
                    throw new RuntimeConfigurationError(ExecutionBundle.message("module.is.unloaded.from.project.error.text", moduleName));
                }
                throw new RuntimeConfigurationError(ExecutionBundle.message("module.doesn.t.exist.in.project.error.text", moduleName));
            }
            throw new RuntimeConfigurationError(ExecutionBundle.message("module.not.specified.error.text", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/RunConfigurationModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/RunConfigurationModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

