/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleHistoryModel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultConsoleHistoryModel
extends SimpleModificationTracker
implements ConsoleHistoryModel {
    private static final Map<String, DefaultConsoleHistoryModel> ourModels = ConcurrentFactoryMap.create(key -> new DefaultConsoleHistoryModel(null), ContainerUtil::createConcurrentWeakValueMap);
    private final Object myLock;
    private final LinkedList<String> myEntries;
    private int myIndex;
    private String myContent;

    public static DefaultConsoleHistoryModel createModel(String persistenceId) {
        return ourModels.get(persistenceId).copy();
    }

    DefaultConsoleHistoryModel(@Nullable DefaultConsoleHistoryModel masterModel) {
        LinkedList<String> linkedList;
        if (masterModel == null) {
            LinkedList<String> linkedList2;
            linkedList = linkedList2;
        } else {
            linkedList = masterModel.myEntries;
        }
        this.myEntries = linkedList;
        this.myLock = masterModel == null ? this : masterModel.myLock;
        this.resetIndex();
    }

    public DefaultConsoleHistoryModel copy() {
        return new DefaultConsoleHistoryModel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetEntries(@NotNull List<String> entries) {
        if (entries == null) {
            DefaultConsoleHistoryModel.$$$reportNull$$$0(0);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myEntries.addAll(ContainerUtil.getFirstItems(entries, this.getMaxHistorySize()));
            this.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToHistory(@Nullable String statement2) {
        if (StringUtil.isEmptyOrSpaces(statement2)) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            int maxHistorySize = this.getMaxHistorySize();
            this.myEntries.remove(statement2);
            int size = this.myEntries.size();
            if (size >= maxHistorySize && size > 0) {
                this.myEntries.removeFirst();
            }
            this.myEntries.addLast(statement2);
            this.incModificationCount();
        }
    }

    @Override
    public void incModificationCount() {
        this.resetIndex();
        super.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetIndex() {
        Object object = this.myLock;
        synchronized (object) {
            this.myIndex = this.myEntries.size();
        }
    }

    @Override
    public int getMaxHistorySize() {
        return UISettings.getInstance().getConsoleCommandHistoryLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromHistory(String statement2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.remove(statement2);
            this.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<String> getEntries() {
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList<String> arrayList = new ArrayList<String>(this.myEntries);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        DefaultConsoleHistoryModel.$$$reportNull$$$0(1);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myEntries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHistorySize() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myEntries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryNext() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIndex >= 0) {
                --this.myIndex;
            }
            return new ConsoleHistoryModel.Entry(this.getCurrentEntry(), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryPrev() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIndex <= this.myEntries.size() - 1) {
                ++this.myIndex;
            }
            return new ConsoleHistoryModel.Entry(this.getCurrentEntry(), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasHistory() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIndex <= this.myEntries.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCurrentEntry() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIndex >= 0 && this.myIndex < this.myEntries.size() ? this.myEntries.get(this.myIndex) : (this.myIndex == this.myEntries.size() ? this.myContent : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentIndex() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myIndex;
        }
    }

    @Override
    public void setContent(@NotNull String userContent) {
        if (userContent == null) {
            DefaultConsoleHistoryModel.$$$reportNull$$$0(2);
        }
        this.myContent = userContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/DefaultConsoleHistoryModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/DefaultConsoleHistoryModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEntries";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

