/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.WeighedItem;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RunDashboardRunConfigurationStatus
implements WeighedItem {
    public static final RunDashboardRunConfigurationStatus STARTED = new RunDashboardRunConfigurationStatus(ExecutionBundle.message("run.dashboard.started.group.name", new Object[0]), AllIcons.Actions.Execute, 10);
    public static final RunDashboardRunConfigurationStatus FAILED = new RunDashboardRunConfigurationStatus(ExecutionBundle.message("run.dashboard.failed.group.name", new Object[0]), AllIcons.General.Error, 20);
    public static final RunDashboardRunConfigurationStatus STOPPED = new RunDashboardRunConfigurationStatus(ExecutionBundle.message("run.dashboard.stopped.group.name", new Object[0]), AllIcons.Actions.Restart, 30);
    public static final RunDashboardRunConfigurationStatus CONFIGURED = new RunDashboardRunConfigurationStatus(ExecutionBundle.message("run.dashboard.configured.group.name", new Object[0]), AllIcons.General.Settings, 40);
    private final String myName;
    private final Icon myIcon;
    private final int myWeight;

    public RunDashboardRunConfigurationStatus(String name, Icon icon2, int weight2) {
        this.myName = name;
        this.myIcon = icon2;
        this.myWeight = weight2;
    }

    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public int getWeight() {
        return this.myWeight;
    }

    @NotNull
    public static RunDashboardRunConfigurationStatus getStatus(RunDashboardRunConfigurationNode node) {
        RunContentDescriptor descriptor2 = node.getDescriptor();
        if (descriptor2 == null) {
            RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus = CONFIGURED;
            if (runDashboardRunConfigurationStatus == null) {
                RunDashboardRunConfigurationStatus.$$$reportNull$$$0(0);
            }
            return runDashboardRunConfigurationStatus;
        }
        ProcessHandler processHandler2 = descriptor2.getProcessHandler();
        if (processHandler2 == null) {
            RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus = STOPPED;
            if (runDashboardRunConfigurationStatus == null) {
                RunDashboardRunConfigurationStatus.$$$reportNull$$$0(1);
            }
            return runDashboardRunConfigurationStatus;
        }
        Integer exitCode = processHandler2.getExitCode();
        if (exitCode == null) {
            RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus = STARTED;
            if (runDashboardRunConfigurationStatus == null) {
                RunDashboardRunConfigurationStatus.$$$reportNull$$$0(2);
            }
            return runDashboardRunConfigurationStatus;
        }
        Boolean terminationRequested = processHandler2.getUserData(ProcessHandler.TERMINATION_REQUESTED);
        if (exitCode == 0 || terminationRequested != null && terminationRequested.booleanValue()) {
            RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus = STOPPED;
            if (runDashboardRunConfigurationStatus == null) {
                RunDashboardRunConfigurationStatus.$$$reportNull$$$0(3);
            }
            return runDashboardRunConfigurationStatus;
        }
        RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus = FAILED;
        if (runDashboardRunConfigurationStatus == null) {
            RunDashboardRunConfigurationStatus.$$$reportNull$$$0(4);
        }
        return runDashboardRunConfigurationStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardRunConfigurationStatus", "getStatus"));
    }
}

