/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RemoveRunConfigurationTypeAction
extends DumbAwareAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        Set<ConfigurationType> types;
        if (e == null) {
            RemoveRunConfigurationTypeAction.$$$reportNull$$$0(0);
        }
        if ((types = RemoveRunConfigurationTypeAction.getTargetTypes(e)).isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(true);
        presentation.setText(ExecutionBundle.messagePointer("run.dashboard.remove.run.configuration.type.action.name", types.size()));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            RemoveRunConfigurationTypeAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance(project2);
        HashSet<String> types = new HashSet<String>(runDashboardManager.getTypes());
        Set<ConfigurationType> targetTypes = RemoveRunConfigurationTypeAction.getTargetTypes(e);
        for (ConfigurationType type : targetTypes) {
            types.remove(type.getId());
        }
        runDashboardManager.setTypes(types);
    }

    private static Set<ConfigurationType> getTargetTypes(AnActionEvent e) {
        JBIterable<RunDashboardRunConfigurationNode> nodes = ServiceViewActionUtils.getTargets(e, RunDashboardRunConfigurationNode.class);
        return nodes.map(node -> node.getConfigurationSettings().getType()).toSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/execution/dashboard/actions/RemoveRunConfigurationTypeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

