/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RestoreHiddenConfigurationsAction
extends DumbAwareAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if ("ServicesToolbar".equals(e.getPlace())) {
            e.getPresentation().setEnabledAndVisible(RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project2));
            e.getPresentation().setText(ExecutionBundle.message("run.dashboard.restore.hidden.configurations.toolbar.action.name", new Object[0]));
            return;
        }
        e.getPresentation().setText(ExecutionBundle.message("run.dashboard.restore.hidden.configurations.popup.action.name", new Object[0]));
        RunDashboardServiceViewContributor root = ServiceViewActionUtils.getTarget(e, RunDashboardServiceViewContributor.class);
        if (root != null) {
            e.getPresentation().setEnabledAndVisible(RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project2));
            return;
        }
        if (!PropertiesComponent.getInstance(project2).getBoolean("ConfigurationTypeDashboardGroupingRule", true)) {
            JBIterable<RunDashboardNode> nodes = ServiceViewActionUtils.getTargets(e, RunDashboardNode.class);
            e.getPresentation().setEnabledAndVisible(nodes.isNotEmpty() && RestoreHiddenConfigurationsAction.hasHiddenConfiguration(project2));
            return;
        }
        Set<ConfigurationType> types = RestoreHiddenConfigurationsAction.getTargetTypes(e);
        if (types.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Set<RunConfiguration> hiddenConfigurations = ((RunDashboardManagerImpl)RunDashboardManager.getInstance(project2)).getHiddenConfigurations();
        List<RunConfiguration> configurations = ContainerUtil.filter(hiddenConfigurations, configuration -> types.contains(configuration.getType()));
        e.getPresentation().setEnabledAndVisible(!configurations.isEmpty());
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            RestoreHiddenConfigurationsAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        RunDashboardServiceViewContributor root = ServiceViewActionUtils.getTarget(e, RunDashboardServiceViewContributor.class);
        if ("ServicesToolbar".equals(e.getPlace()) || root != null || !PropertiesComponent.getInstance(project2).getBoolean("ConfigurationTypeDashboardGroupingRule", true)) {
            RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance(project2);
            runDashboardManager.restoreConfigurations(new THashSet<RunConfiguration>(runDashboardManager.getHiddenConfigurations()));
            return;
        }
        Set<ConfigurationType> types = RestoreHiddenConfigurationsAction.getTargetTypes(e);
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance(project2);
        List<RunConfiguration> configurations = ContainerUtil.filter(runDashboardManager.getHiddenConfigurations(), configuration -> types.contains(configuration.getType()));
        runDashboardManager.restoreConfigurations(configurations);
    }

    private static boolean hasHiddenConfiguration(Project project2) {
        return !((RunDashboardManagerImpl)RunDashboardManager.getInstance(project2)).getHiddenConfigurations().isEmpty();
    }

    private static Set<ConfigurationType> getTargetTypes(AnActionEvent e) {
        JBIterable<RunDashboardNode> targets2 = ServiceViewActionUtils.getTargets(e, RunDashboardNode.class);
        if (targets2.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ConfigurationType> types = new HashSet<ConfigurationType>();
        for (RunDashboardNode node : targets2) {
            if (node instanceof RunDashboardRunConfigurationNode) {
                types.add(((RunDashboardRunConfigurationNode)node).getConfigurationSettings().getType());
                continue;
            }
            if (node instanceof GroupingNode) {
                RunDashboardGroupImpl group = (RunDashboardGroupImpl)((GroupingNode)node).getGroup();
                ConfigurationType type = ObjectUtils.tryCast(group.getValue(), ConfigurationType.class);
                if (type == null) {
                    return Collections.emptySet();
                }
                types.add(type);
                continue;
            }
            return Collections.emptySet();
        }
        return types;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/execution/dashboard/actions/RestoreHiddenConfigurationsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

