/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationNode
extends AbstractTreeNode<RunDashboardManager.RunDashboardService>
implements RunDashboardRunConfigurationNode {
    private final List<RunDashboardCustomizer> myCustomizers;
    private final UserDataHolder myUserDataHolder;

    public RunConfigurationNode(Project project2, @NotNull RunDashboardManager.RunDashboardService service, @NotNull List<RunDashboardCustomizer> customizers) {
        if (service == null) {
            RunConfigurationNode.$$$reportNull$$$0(0);
        }
        if (customizers == null) {
            RunConfigurationNode.$$$reportNull$$$0(1);
        }
        super(project2, service);
        this.myUserDataHolder = new UserDataHolderBase();
        this.myCustomizers = customizers;
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettings getConfigurationSettings() {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = ((RunDashboardManager.RunDashboardService)this.getValue()).getSettings();
        if (runnerAndConfigurationSettings == null) {
            RunConfigurationNode.$$$reportNull$$$0(2);
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    @Nullable
    public RunContentDescriptor getDescriptor() {
        return ((RunDashboardManager.RunDashboardService)this.getValue()).getDescriptor();
    }

    @Override
    @Nullable
    public Content getContent() {
        return ((RunDashboardManager.RunDashboardService)this.getValue()).getContent();
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            RunConfigurationNode.$$$reportNull$$$0(3);
        }
        RunnerAndConfigurationSettings configurationSettings = this.getConfigurationSettings();
        boolean isStored = RunManager.getInstance(this.getProject()).hasSettings(configurationSettings);
        SimpleTextAttributes nameAttributes = isStored ? (this.getContent() != null ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES) : SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
        presentation.addText(configurationSettings.getName(), nameAttributes);
        Icon icon2 = this.getIcon(configurationSettings);
        presentation.setIcon(isStored ? icon2 : IconLoader.createLazy(() -> IconLoader.getDisabledIcon(icon2)));
        for (RunDashboardCustomizer customizer : this.myCustomizers) {
            if (!customizer.updatePresentation(presentation, this)) continue;
            return;
        }
    }

    private Icon getIcon(RunnerAndConfigurationSettings configurationSettings) {
        Icon icon2 = null;
        RunDashboardRunConfigurationStatus status = this.getStatus();
        if (RunDashboardRunConfigurationStatus.STARTED.equals(status)) {
            icon2 = this.getExecutorIcon();
        } else if (RunDashboardRunConfigurationStatus.FAILED.equals(status)) {
            icon2 = status.getIcon();
        }
        if (icon2 == null) {
            icon2 = RunManagerEx.getInstanceEx(this.getProject()).getConfigurationIcon(configurationSettings);
        }
        return icon2;
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        for (RunDashboardCustomizer customizer : this.myCustomizers) {
            Collection<AbstractTreeNode<?>> children2 = customizer.getChildren(this);
            if (children2 == null) continue;
            for (AbstractTreeNode<?> child2 : children2) {
                child2.setParent(this);
            }
            Collection<AbstractTreeNode<?>> collection = children2;
            if (collection == null) {
                RunConfigurationNode.$$$reportNull$$$0(4);
            }
            return collection;
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            RunConfigurationNode.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            RunConfigurationNode.$$$reportNull$$$0(6);
        }
        return this.myUserDataHolder.getUserData(key);
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            RunConfigurationNode.$$$reportNull$$$0(7);
        }
        this.myUserDataHolder.putUserData(key, value2);
    }

    @Override
    @NotNull
    public List<RunDashboardCustomizer> getCustomizers() {
        List<RunDashboardCustomizer> list2 = this.myCustomizers;
        if (list2 == null) {
            RunConfigurationNode.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    public RunDashboardRunConfigurationStatus getStatus() {
        for (RunDashboardCustomizer customizer : this.myCustomizers) {
            RunDashboardRunConfigurationStatus status = customizer.getStatus(this);
            if (status == null) continue;
            RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus = status;
            if (runDashboardRunConfigurationStatus == null) {
                RunConfigurationNode.$$$reportNull$$$0(9);
            }
            return runDashboardRunConfigurationStatus;
        }
        RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus = RunDashboardRunConfigurationStatus.getStatus(this);
        if (runDashboardRunConfigurationStatus == null) {
            RunConfigurationNode.$$$reportNull$$$0(10);
        }
        return runDashboardRunConfigurationStatus;
    }

    @Nullable
    private Icon getExecutorIcon() {
        Executor executor;
        Content content2 = this.getContent();
        if (content2 != null && !RunContentManagerImpl.isTerminated(content2) && (executor = RunContentManagerImpl.getExecutorByContent(content2)) != null) {
            return executor.getIcon();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getConfigurationSettings().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizers";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/tree/RunConfigurationNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/tree/RunConfigurationNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

