/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionFilterFactory;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionExFilterFactory
implements ExceptionFilterFactory {
    @Override
    @NotNull
    public Filter create(@NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            ExceptionExFilterFactory.$$$reportNull$$$0(0);
        }
        return new MyFilter(searchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/filters/ExceptionExFilterFactory", "create"));
    }

    private static class MyFilter
    implements Filter,
    FilterMixin {
        private final ExceptionInfoCache myCache;

        MyFilter(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                MyFilter.$$$reportNull$$$0(0);
            }
            this.myCache = new ExceptionInfoCache(scope);
        }

        @Override
        public Filter.Result applyFilter(@NotNull String line, int textEndOffset) {
            if (line == null) {
                MyFilter.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        public boolean shouldRunHeavy() {
            return true;
        }

        @Override
        public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<? super FilterMixin.AdditionalHighlight> consumer) {
            if (copiedFragment == null) {
                MyFilter.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                MyFilter.$$$reportNull$$$0(3);
            }
            THashMap<String, ExceptionWorker.ParsedLine> visited = new THashMap<String, ExceptionWorker.ParsedLine>();
            ExceptionWorker.ParsedLine emptyInfo = new ExceptionWorker.ParsedLine(TextRange.EMPTY_RANGE, TextRange.EMPTY_RANGE, TextRange.EMPTY_RANGE, null, -1);
            ExceptionWorker worker = new ExceptionWorker(this.myCache);
            for (int i = 0; i < copiedFragment.getLineCount(); ++i) {
                ExceptionWorker.ParsedLine info;
                int lineEndOffset;
                int lineStartOffset = copiedFragment.getLineStartOffset(i);
                String lineText = copiedFragment.getText(new TextRange(lineStartOffset, lineEndOffset = copiedFragment.getLineEndOffset(i)));
                if (!lineText.contains(".java:") || (info = (ExceptionWorker.ParsedLine)visited.get(lineText)) == emptyInfo) continue;
                if (info == null) {
                    info = ReadAction.compute(() -> DumbService.isDumb(worker.getProject()) ? null : MyFilter.doParse(worker, lineEndOffset, lineText));
                    visited.put(lineText, info == null ? emptyInfo : info);
                    if (info == null) continue;
                }
                int off = startOffset + lineStartOffset;
                final Color color = UIUtil.getInactiveTextColor();
                consumer.consume(new FilterMixin.AdditionalHighlight(off + info.classFqnRange.getStartOffset(), off + info.methodNameRange.getEndOffset()){

                    @Override
                    @NotNull
                    public TextAttributes getTextAttributes(@Nullable TextAttributes source) {
                        return new TextAttributes(null, null, color, EffectType.BOLD_DOTTED_LINE, 0);
                    }
                });
            }
        }

        private static ExceptionWorker.ParsedLine doParse(@NotNull ExceptionWorker worker, int lineEndOffset, @NotNull String lineText) {
            PsiCodeBlock tryBlock;
            Filter.Result result2;
            if (worker == null) {
                MyFilter.$$$reportNull$$$0(4);
            }
            if (lineText == null) {
                MyFilter.$$$reportNull$$$0(5);
            }
            if ((result2 = worker.execute(lineText, lineEndOffset)) == null) {
                return null;
            }
            HyperlinkInfo hyperlinkInfo = result2.getHyperlinkInfo();
            if (!(hyperlinkInfo instanceof FileHyperlinkInfo)) {
                return null;
            }
            OpenFileDescriptor descriptor2 = ((FileHyperlinkInfo)hyperlinkInfo).getDescriptor();
            if (descriptor2 == null) {
                return null;
            }
            PsiFile psiFile = worker.getFile();
            if (psiFile == null || psiFile instanceof PsiCompiledFile) {
                return null;
            }
            int offset = descriptor2.getOffset();
            if (offset <= 0) {
                return null;
            }
            PsiElement element2 = psiFile.findElementAt(offset);
            PsiTryStatement parent = PsiTreeUtil.getParentOfType(element2, PsiTryStatement.class, true, PsiClass.class);
            PsiCodeBlock psiCodeBlock = tryBlock = parent != null ? parent.getTryBlock() : null;
            if (tryBlock == null || !tryBlock.getTextRange().contains(offset)) {
                return null;
            }
            return worker.getInfo();
        }

        @Override
        @NotNull
        public String getUpdateMessage() {
            return "Highlighting try blocks...";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copiedFragment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "worker";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineText";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFilter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyHeavyFilter";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doParse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

