/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleFilesHyperlinkInfo
extends HyperlinkInfoBase
implements FileHyperlinkInfo {
    private final List<? extends VirtualFile> myVirtualFiles;
    private final int myLineNumber;
    private final Project myProject;
    private final ToIntFunction<? super PsiFile> myColumnFinder;

    MultipleFilesHyperlinkInfo(@NotNull List<? extends VirtualFile> virtualFiles, int lineNumber, @NotNull Project project2) {
        if (virtualFiles == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(1);
        }
        this(virtualFiles, lineNumber, project2, null);
    }

    MultipleFilesHyperlinkInfo(@NotNull List<? extends VirtualFile> virtualFiles, int lineNumber, @NotNull Project project2, @Nullable ToIntFunction<? super PsiFile> columnFinder) {
        if (virtualFiles == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(3);
        }
        this.myVirtualFiles = virtualFiles;
        this.myLineNumber = lineNumber;
        this.myProject = project2;
        this.myColumnFinder = columnFinder == null ? f -> 0 : columnFinder;
    }

    @Override
    public void navigate(@NotNull Project project2, @Nullable RelativePoint hyperlinkLocationPoint) {
        if (project2 == null) {
            MultipleFilesHyperlinkInfo.$$$reportNull$$$0(4);
        }
        ArrayList currentFiles = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            for (VirtualFile virtualFile2 : this.myVirtualFiles) {
                PsiFile psiFile;
                if (!virtualFile2.isValid() || (psiFile = PsiManager.getInstance(project2).findFile(virtualFile2)) == null) continue;
                PsiElement navigationElement = psiFile.getNavigationElement();
                if (navigationElement instanceof PsiFile) {
                    currentFiles.add((PsiFile)navigationElement);
                    continue;
                }
                currentFiles.add(psiFile);
            }
        });
        if (currentFiles.isEmpty()) {
            return;
        }
        if (currentFiles.size() == 1) {
            PsiFile file2 = (PsiFile)currentFiles.get(0);
            new OpenFileHyperlinkInfo(this.myProject, file2.getVirtualFile(), this.myLineNumber, this.myColumnFinder.applyAsInt(file2)).navigate(project2);
        } else {
            JFrame frame = WindowManager.getInstance().getFrame(project2);
            int width = frame != null ? frame.getSize().width : 200;
            JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(currentFiles).setRenderer(new GotoFileCellRenderer(width)).setTitle(ExecutionBundle.message("popup.title.choose.target.file", new Object[0])).setItemChosenCallback(selectedValue -> {
                VirtualFile file2 = selectedValue.getVirtualFile();
                new OpenFileHyperlinkInfo(this.myProject, file2, this.myLineNumber, this.myColumnFinder.applyAsInt((PsiFile)selectedValue)).navigate(project2);
            }).createPopup();
            if (hyperlinkLocationPoint != null) {
                popup2.show(hyperlinkLocationPoint);
            } else {
                popup2.showInFocusCenter();
            }
        }
    }

    @Override
    @Nullable
    public OpenFileDescriptor getDescriptor() {
        VirtualFile file2 = this.getPreferredFile();
        return file2 != null ? new OpenFileDescriptor(this.myProject, file2, this.myLineNumber, 0) : null;
    }

    @Nullable
    private VirtualFile getPreferredFile() {
        return ContainerUtil.getFirstItem(this.myVirtualFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/filters/impl/MultipleFilesHyperlinkInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

